offline = (window.location.protocol=="file:"?true:false);

function bitPercentage(word,compare) {
	var mCount = 0;
	word = word&compare;
	//Loop the value while there are still bits
	while (compare != 0) {
		//Remove the end bit
		compare = compare & (compare - 1);
		//Increment the count
		mCount++;
	}
	var cCount = 0;
	//Loop the value while there are still bits
	while (word != 0) {
		//Remove the end bit
		word = word & (word - 1);
		//Increment the count
		cCount++;
	}
	
	//Return the count
	return (cCount/mCount);
}

loading = false;

function parseHex(str,padding) {
	var padding = padding||8;
	return "0x"+pad(parseInt(str).toString(16).toUpperCase(),8);
}

function pad(n, width, z) {
  z = z || '0';
  n = n + '';
  return n.length >= width ? n : new Array(width - n.length + 1).join(z) + n;
}

loadingBar = {
	running: false,
	total: 0,
	current: 0
};

function updateLoadingBar() {
	var percentage = (loadingBar.current/Math.max(loadingBar.total,1))*100;
	$("#loadingBar > .bar").css("width",percentage.toFixed(1)+"%");
	$("#loadingBar > .barAmount").text(loadingBar.current+"/"+loadingBar.total);
	$("#loadingBar > .barPercentage").text(percentage.toFixed(1)+"%");
	if (percentage >= 100) {
		$("#loadingBar > .barText").text("Done");
		loadingBar.running = false;
	} else {
		$("#loadingBar > .barText").text(loadingBar.text);
	}
}

function setLoadingBar(current,total,text,hide) {
	loadingBar.total = total;
	loadingBar.current = current;
	loadingBar.text = text;
	if (!loadingBar.running && !hide) {
		$('#loadingBar').slideDown(100);
		loadingBar.running = true;
	}
	if (typeof(hide) != "undefined" && hide !== null) {
		loadingBar.running = false;
		$('#loadingBar').delay(hide).slideUp(100);
	}
	updateLoadingBar();
}

function popup(message,time,type) {
	if (typeof message === 'undefined') {
		$(".popup").finish().slideUp(250);
		return;
	}
	$(".popup > p").text(message);
	$(".popup").attr("class","popup "+type).finish().slideDown(250,function(){
		$(".popup").delay(time).slideUp(250);
	});
}

function sideToggle(element, forward) {
	var container = $(element).parent();
	var children = container.children("div");
	var currentChild = children.filter(":visible");
	if (forward && currentChild[0] != children.first()[0]) {
		currentChild.hide().prev("div").show();
	} else if (!forward && currentChild[0] != children.last()[0]) {
		currentChild.hide().next("div").show();
	}
}

$(document).ready(function(){

	$("[data-step=next]").click(function(){
		event.preventDefault?event.preventDefault():event.returnValue=false;
		sideToggle(this, true);
	});
	
	$("[data-step=previous]").click(function(){
		event.preventDefault?event.preventDefault():event.returnValue=false;
		sideToggle(this);
	});
	
	$("[data-tab] > a").click(function(){
		event.preventDefault?event.preventDefault():event.returnValue=false;
		var $this = $(this);
		var selector = $this.parent().attr("data-tab");
		var $container = $(selector);
		$container.show();
		$container.children(":eq("+$this.index()+")").slideToggle(250).siblings().slideUp(250);
	});

});