function arrayFromMask (nMask) { //Function copied from https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Bitwise_Operators
  // nMask must be between -2147483648 and 2147483647
  if (nMask > 0x7fffffff || nMask < -0x80000000) { throw new TypeError("arrayFromMask - out of range"); }
  for (var nShifted = nMask, aFromMask = []; nShifted; aFromMask.push(Boolean(nShifted & 1)), nShifted >>>= 1);
  return aFromMask;
}

function pad (str, max) { //copied from http://stackoverflow.com/questions/6466135/adding-extra-zeros-in-front-of-a-number-using-jquery
  return str.length < max ? pad("0" + str, max) : str;
}

function DecToHex (value, length) {
	return pad(Number(value).toString(16),length).toUpperCase();
}

function closestOffset (val){
	var key,
		keyNum,
		keyNumTwo,
		diff,
		diffTwo,
		closest = {
			key: null,
			diff: null
		};
		for(key in $offsets) {
			if($offsets.hasOwnProperty(key)) {
				if ($offsets[key].Length == "0001") {
					keyNum = parseInt(key,16);
					diff = Math.abs(parseInt(val,16) - keyNum);
				} else {
					keyNum = parseInt(key.substr(0, 4),16);
					keyNumTwo = parseInt(key.substr(5, 4),16);
					diff = Math.abs(parseInt(val,16) - keyNum);
					diffTwo = Math.abs(parseInt(val,16) - keyNumTwo);
					diff = Math.min(diff, diffTwo);
				}
				if(!closest.key || diff < closest.diff) {
					closest.key = key;
					closest.diff = diff;
				}
			}
		}
		
		return closest.key;
}

function compareStrings(s1,s2) {
	if ((typeof s1 == 'string' || s1 instanceof String) && (typeof s2 == 'string' || s2 instanceof String)) {
		if (s1.toLowerCase() == s2.toLowerCase()) {
			return true;
		}
	}
	return false;
}

function isset(testVar) {
	return !(typeof testVar === 'undefined');
}

/*******************************************
Array filter polyfill
*******************************************/

if (!Array.prototype.filter)
{
  Array.prototype.filter = function(fun /*, thisArg */)
  {
    "use strict";

    if (this === void 0 || this === null)
      throw new TypeError();

    var t = Object(this);
    var len = t.length >>> 0;
    if (typeof fun !== "function")
      throw new TypeError();

    var res = [];
    var thisArg = arguments.length >= 2 ? arguments[1] : void 0;
    for (var i = 0; i < len; i++)
    {
      if (i in t)
      {
        var val = t[i];

        // NOTE: Technically this should Object.defineProperty at
        //       the next index, as push can be affected by
        //       properties on Object.prototype and Array.prototype.
        //       But that method's new, and collisions should be
        //       rare, so use the more-compatible alternative.
        if (fun.call(thisArg, val, i, t))
          res.push(val);
      }
    }

    return res;
  };
}

/*******************************************
RBA CALCULATOR
*******************************************/

function itemSearch(string) { //Used to find an item by its name, altname, or shortnames
	var lookup = $items.filter(function (item) { //Loop through all items and filter out the ones that doesn't have
		var shortname = [];
		if (item.Shortname) { //Check if the item has any shortnames
			 shortname = item.Shortname.filter(function (name) { //Loop through all shortnames of the item to see if one matches
				return (compareStrings(name, string) && name != "")
			});
		}
		if (compareStrings(item.Name, string) || compareStrings(item.AltName, string) || shortname.length > 0) { //If the item had a a matching shortname, or if it's name/altname matches, add it.
			return true;
		}
	});
	return lookup;
}

function rba(II, B, Ver) {
	Ver = typeof Ver !== 'undefined' ? Ver : "3DS";
	offset = 0x0074;
	var get = {};
	var lose = {};
	lookup = [];
	
	if (II == null) II = window.prompt("Item on II:\nInsert a number 0x0-0xFF, 0-255 or bottle type","");
	if (B == null) B = window.prompt("Item on B:\nInsert a number 0x0-0xFF, 0-255 or bottle type","");
		
	lookup = itemSearch(B);
	if (lookup.length > 0) B = lookup[0].ID
	lookup = itemSearch(II);
	if (lookup.length > 0) II = lookup[0].ID
	
	if ($items[parseInt(B)] == null || parseInt(B) > 255) return "badB";
	if ($items[parseInt(II)] == null || parseInt(II) > 255) return "badII";
	
	II = "0x" + Number(II).toString(16); //Convert the number to Hex
	B = "0x" + Number(B).toString(16); //Convert the number to Hex
	var write = DecToHex(offset + parseInt(II, 16), 4); //Add II to offset to get the write value
	
	
	if (Ver == "3DS") { //Apply alternative name if available when in 3DS mode

	} else if (Ver == "N64") {
	/*
		ram = parseInt(II, 16);
		ram = (ram==42||ram==43?44:ram); //Move index 42 & 43 to unused (44).
		ram = (ram>=24&&ram<=41?ram+2:ram); //Add 2 for index 24-41
		ram = (ram==43?42:(ram==42?43:ram)); //Flip 42-43
		ram = (ram>=44&&ram<=47?47-(ram-44):ram); //Reverse 44-47
		ram = (ram>=48&&ram<=51?51-(ram-48):ram); //Reverse 48-51
		console.log("N64");
		//console.log("Write to: 0x"+ram+" ("+$offsets[DecToHex(offset + ram, 4)].Usage+")");
		write = DecToHex(offset + ram, 4);
		*/
	}
	
	if ($offsets[write] == null) { //Offset doesn't exist. Find a range.
		    write = closestOffset(write);
	}
	
	if (!$offsets[write].Value) {
		if ("Flags" in $offsets[write]) {
			lose = $.extend({}, $offsets[write].Flags);
			$.each($offsets[write].Flags, function(i, e){
				if ((B & i) == i)
				{
					bitsSet = arrayFromMask(i); //Create a boolean array from the bit mask
					$.each(bitsSet, function(index,val){ //Loop through the array
						if (val==true) { //If the bit is set
							bit = "0x"+DecToHex(Math.pow(2,index),2);
							delete get[bit]; //Delete the specified bit from the result
						}
					});
					get[i] = e;
					delete lose[i];
				}
			});
			if ($.isEmptyObject(get)) get["0x00"] = "Nothing";
		}
		
		if ($.isEmptyObject(get)) {
			get = "Nothing/Unknown";
		}
		
		if ($.isEmptyObject(lose)) {
			lose = "Nothing/Unknown";
		}
		
	} else {
		get = $offsets[write].Value;
		get = get.replace(/u\[([^,\]]*),?([^,\]]*)\]/g, function(match, $1, $2) {
			flags=7;
			bitmodifier = 0;
			itemmodifier = 0;
			if ($1 == 4) flags=3;
			if ($1 > 4) {
				bitmodifier = -1;
				itemmodifier = -18;
			}
			padding = ($2?($2/3):($1/3));
			byte = (B).toString(2) << 8*Math.floor(padding);
			upgrade = ((byte >> 3*$1+bitmodifier)&flags);
			result = (upgrade?(73+($1*3)+itemmodifier+upgrade):255);
			if (result!=255) return "wrap["+$items[result].Name+",highlight] icon["+result+"] ("+$items[result].Effect[$1]+")";
			else return "wrap[default,highlight]"+("Effect" in $items[result]?" ("+$items[result].Effect[$1]+")":"");
		});
		
		if (arrayFromMask(B)[0] == true){ //Mix
			strengthmix = "wrap[Strength Upgrade Mix,highlight] is wrap[Enabled,highlight]<br>\
			[indent][indent]wrap[No upgrade,highlight] becomes wrap[i[Name,83],highlight] icon[83] ("+$items[83].Effect[2]+")<br>\
			[indent][indent]wrap[i[Name,80],highlight] icon[80] becomes wrap[i[Name,84],highlight] icon[84] ("+$items[84].Effect[2]+")<br>\
			[indent][indent]wrap[i[Name,81],highlight] icon[81] becomes wrap[i[Name,85],highlight] icon[85] ("+$items[85].Effect[2]+")<br>\
			[indent][indent]wrap[i[Name,82],highlight] icon[82] becomes wrap[i[Name,86],highlight] icon[86] ("+$items[86].Effect[2]+")\
			";
			bulletmix = "wrap[Bullet Bag Mix,highlight] is wrap[Enabled,highlight]<br>\
			[indent][indent]wrap[No upgrade,highlight] becomes wrap[i[Name,74],highlight] icon[74] ("+$items[74].Effect[5]+")<br>\
			[indent][indent]wrap[i[Name,71],highlight] icon[71] becomes wrap[i[Name,75],highlight] icon[75] ("+$items[75].Effect[5]+")<br>\
			[indent][indent]wrap[i[Name,72],highlight] icon[72] becomes wrap[i[Name,76],highlight] icon[76] ("+$items[76].Effect[5]+")<br>\
			[indent][indent]wrap[i[Name,73],highlight] icon[73] becomes wrap[i[Name,77],highlight] icon[77] ("+$items[77].Effect[5]+")\
			";
		} else { //Not Mixed
			strengthmix = "wrap[Strength Upgrade Mix,highlight] is wrap[Disabled,highlight]";
			bulletmix = "wrap[Bullet Bag Mix,highlight] is wrap[Disabled,highlight]";
		}
		
		get = get.replace("mix[s]", strengthmix);
		get = get.replace("mix[b]", bulletmix);
		get = get.replace(/i\[Name\]/g, "i[Name]");
		get = get.replace(/\[indent\]/g, "<span style='margin-left:10px;'></span>");
		get = get.replace(/o\[([^\]]*)\]/g, function(match, $1) { return $offsets[write][$1]; });
		get = get.replace(/i\[([^,\]]*),?([^,\]]*)\]/g, function(match, $1, $2) { return $items[($2?$2:parseInt(B,16))][$1]; });
		get = get.replace(/m\[([^\]]*)\]/g, function(match, $1) { return calc($1); });
		get = get.replace(/max\[([^,\]]*),([^,\]]*)\]/g, function(match, $1, $2) { return Math.max($1,$2); });
		get = get.replace(/min\[([^,\]]*),([^,\]]*)\]/g, function(match, $1, $2) { return Math.min($1,$2); });
		get = get.replace(/floor\[([^\]]*)\]/g, function(match, $1) { return Math.floor($1); });
		get = get.replace(/icon\[([^\]]*)\]/ig, function(match, $1) { return "<img class='icon' src='assets/images/items/"+$1+".png'/>"; });
		get = get.replace(/wrap\[([^,\]]*),([^,\]]*)\]/g, function(match, $1, $2) { return "<span class='"+$2+"'>"+$1+"</span>"; });
		get = get.replace(/v\[([^\]]*)\]/g, function(match, $1) { 
			if ($1 == "B") {
				return B;
			} else if ($1 == "II") {
				return II;
			} else {
				return window[$1];
			}
		});
		
		lose = "Nothing";
	}
	//console.log("Modifier: "+B+" ("+parseInt(B,16)+"/"+$items[parseInt(B,16)]["Name"]+")");
	//console.log("You Receive: ");
	//console.log(get);
	//console.log("You Lose: ");
	//console.log(lose);
	
	return {"II":parseInt(II,16),"B":parseInt(B,16), "Usage":$offsets[write].Usage, "Lose":lose, "Address":write, "Get":get, "Version":Ver};
}


function rbaCalculate(II, B, V) {
	result = rba(II, B, V);
	$("#searchResult, #rbaResult").hide();
	$("#rbaType").parent().removeClass("hidden");
	if (result == "badB") {
		//$("#rbaError").html("The specified B item doesn't exist.");
		popup("The specified B item doesn't exist.",5000,"error");
		$("#rbaResult").children().hide();
		//$("#rbaResult").children(":first-child").show();
	} else if (result == "badII") {
		//$("#rbaError").html("The specified C-Right item doesn't exist.");
		popup("The specified C-Right item doesn't exist.",5000,"error");
		$("#rbaResult").children().hide();
		//$("#rbaResult").children(":first-child").show();
	} else {
		popup();
		$("#rbaResult").show();
		$("#rbaType").html($items[result.B]["Name"]+" <img class='icon' src='assets/images/items/"+result.B+".png'/> RBA "+$items[result.II]["Name"]+" <img class='icon' src='assets/images/items/"+result.II+".png'/> ("+result.Version+")");
		$("#rbaUsage").html(result.Usage);
		$("#rbaReceive").html(parseFlags(result.Get,V).html());
		$("#rbaLose").html(parseFlags(result.Lose,V).html());
		$("#rbaResult").children().show();
		//$("#rbaResult").children(":first-child").hide();
	}
}

/******************************************
Parse Flags
******************************************/

function parseFlags(flags, version) {
	version = typeof version !== 'undefined' ? version : "3DS";
	
	var rowdata = $('<td/>');
	if (typeof flags == "string") {
		rowdata.append(flags);
	} else {
		$.each(flags, function(flag, item) { //Loop through the bottle results
			rowdata.append("<span class='hexvalue'>"+flag+"</span> ");
			if (isNaN(item)) {
				rowdata.append(item+" ");
			} else {
				rowdata.append($items[item].Name+" <img class='icon' src='assets/images/items/"+item+".png'/>");
			}
			rowdata.append("<br>");
		});
	}
	return rowdata;
}

/******************************************
RBA Searcher
******************************************/

function rbaSearch(item) {

	var offset = 0x0074;
	var search = item;
	var result = [];
	
	$.each($offsets, function ($offset, value) { 
		if ((isset(value.Search) && value.Search.toLowerCase().indexOf(search.toLowerCase()) >= 0) || compareStrings(value.Offset, search)) {
			result.push($offsets[$offset]);
			//console.log(value);
		}
	});
	
	if (result.length != 1) {
		return result;
	} else {
		var address = DecToHex(parseInt(result[0].Offset,16) - offset,2);		
		var bottles = [
			20,
			24,
			25,
			28,
			29
			//31
		];
		var rbaresults = [];
		
		$.each(bottles, function(i, bottleval){
			rbaresults.push(rba(parseInt(address,16).toString(),bottleval));
		});
		/*
		ram64 = parseInt(address,16);
		ram64 = (ram64==43?42:(ram64==42?43:ram64)); //Flip 42-43
		ram64 = (ram64>=26&&ram64<=43?ram64-2:ram64); //Substract 2 for index 26-43
		ram64 = (ram64>=44&&ram64<=47?47-(ram64-44):ram64); //Reverse 44-47
		ram64 = (ram64>=48&&ram64<=51?51-(ram64-48):ram64); //Reverse 48-51
		*/
		
		return {"Bottles":rbaresults, "ID":parseInt(address,16).toString()};
	}
	//console.log(lookup);
	
}

function RBASearcher(value) {
	var results = rbaSearch(value);
	$(".rrbatemp").remove();
	$("#rbaResult, #searchResult").hide();
	$("#rrbaFlags").remove();
	if (results.length == 0) {
		popup("Could not find that item or data.",5000,"error");
	} else if (results.length > 20) {
		popup("Found more than 20 results, be more specific.",5000,"error");
	} else if (results.length > 1) {
		popup(); 
		var offset = 0x0074;
		$("#searchOutput").html("Did you mean one of the following:");
		$.each(results, function(index, result){
			var item = parseInt(result.Offset, 16) - offset;
			var row = $('<tr/>')
				.addClass("rrbatemp")
				.append($('<td class="text-right" />')
					.append($('<strong />')
						.html($items[item].Name)
					)
				)
				.append($('<td />')
					.append($('<span class="clickable-text" />')
						.html(result.Usage)
						.click(function() {
							RBASearcher(result.Offset);
						})
					)
				)
			;
			$("#searchOutput").parents("table").append(row);
		});
		$("#searchResult").show();
	} else {
		popup();
		$("#searchOutput").html(
			$items[results["ID"]]["Name"] + " <img class='icon' src='assets/images/items/"+results["ID"]+".png'/> (N64)"
		);
		flags = $offsets[results.Bottles[0].Address].Flags;
		if (typeof flags === "object") {
			$("#searchResult").append(
				$('<tr/>')
					.attr('id','rrbaFlags')
					.append($('<td class="text-right" />')
						.append($('<strong />')
							.html('Affected')
						)
					)
					.append(parseFlags(flags, "N64"))
			);
		}
		$.each(results.Bottles, function(index, bottle){ //Loop through the bottles
			var row = $('<tr/>')
				.addClass("rrbatemp")
				.append($('<td class="text-right" />')
					.html($items[bottle.B]["Name"]+" <img class='icon' src='assets/images/items/"+bottle.B+".png'/>")
				)
			;
			var rowdata = parseFlags(bottle.Get, "N64");
			row.append(rowdata);
			$("#searchResult").append(row);
		});
		$("#searchResult").show();
	}
}

/********************************
EVENTS
********************************/
$(document).ready(function(){

	$("#search").submit(function( event ){
		event.preventDefault();
		var rbaQuery = $("#itemQuery").val();
		RBASearcher(rbaQuery);
	});

	$("#calculate").submit(function( event ){
		event.preventDefault();
		var rbaPointer = $("#itemPointer").val();
		var rbaModifier = $("#itemModifier").val();
		var rbaVersion = "N64";
		rbaCalculate(rbaPointer, rbaModifier, rbaVersion);
	});

	$("#rbaV").on("change", function(e){
		if ($(this).val() == "N64") $("#rbaO").html("Item on C-Right");
		else $("#rbaO").html("Item on II");
	});
	
});