function bitPercentage(word,compare) {
	var mCount = 0;
	word = word&compare;
	//Loop the value while there are still bits
	while (compare != 0) {
		//Remove the end bit
		compare = compare & (compare - 1);
		//Increment the count
		mCount++;
	}
	var cCount = 0;
	//Loop the value while there are still bits
	while (word != 0) {
		//Remove the end bit
		word = word & (word - 1);
		//Increment the count
		cCount++;
	}
	
	//Return the count
	return (cCount/mCount);
}

loading = false;

function parseHex(str,padding) {
	var padding = padding||8;
	return "0x"+pad(parseInt(str).toString(16).toUpperCase(),8);
}

function pad(n, width, z) {
  z = z || '0';
  n = n + '';
  return n.length >= width ? n : new Array(width - n.length + 1).join(z) + n;
}

loadingBar = {
	running: false,
	total: 0,
	current: 0
};

function updateLoadingBar() {
	var percentage = (loadingBar.current/Math.max(loadingBar.total,1))*100;
	$("#combineBar > .bar").css("width",percentage.toFixed(1)+"%");
	$("#combineBar > .barAmount").text(loadingBar.current+"/"+loadingBar.total);
	$("#combineBar > .barPercentage").text(percentage.toFixed(1)+"%");
	if (percentage >= 100) {
		$("#combineBar > .barText").text("Done");
		loadingBar.running = false;
	} else {
		$("#combineBar > .barText").text(loadingBar.text);
	}
}

function setLoadingBar(current,total,text,hide) {
	loadingBar.total = total;
	loadingBar.current = current;
	loadingBar.text = text;
	if (!loadingBar.running && !hide) {
		$('#combineBar').slideDown(100);
		loadingBar.running = true;
	}
	updateLoadingBar();
}

function popup(message,time,type) {
	$(".popup > p").text(message);
	$(".popup").attr("class","popup "+type).finish().slideDown(250,function(){
		$(".popup").delay(time).slideUp(250);
	});
}

function toggleChangelog(forward) {
	var changelog = $("#changelog");
	var logs = changelog.children("div");
	var currentLog = logs.filter(":visible");
	if (forward && currentLog[0] != logs.first()[0]) {
		currentLog.hide().prev("div").show();
	} else if (!forward && currentLog[0] != logs.last()[0]) {
		currentLog.hide().next("div").show();
	}
}
		
function getExtension(name) {
	return name.split('.').pop().toLowerCase();
}
		
function timestamp() {
	var time = new Date();
	var stamp = "";
	stamp += time.getFullYear();
	stamp += pad(time.getMonth()+1,2);
	stamp += pad(time.getDate(),2);
	stamp += pad(time.getHours(),2);
	stamp += pad(time.getMinutes(),2);
	stamp += pad(time.getSeconds(),2);
	return stamp;
}
	
$(document).ready(function(){

	$("#menuButtons > a").click(function(){
		$("#centerPanel").show();
		$("#centerPanel > :eq("+$(this).index()+")").slideToggle(250).siblings().slideUp(250);
	});
	
	offline = (window.location.protocol=="file:"?true:false);

	$files = {
		"loaded":{}
	};

	var ignoreDrag = function(e) {
		var event = typeof e.originalEvent != 'undefined' ? e.originalEvent : e;
		if (event.stopPropagation) {
			event.stopPropagation();
		}
		if (event.preventDefault) {
			event.preventDefault();
		}
	};
	$('html').bind('dragover', ignoreDrag).bind('dragenter', ignoreDrag).bind('drop', function(e){
		e = (e&&e.originalEvent?e.originalEvent:window.event) || e;
		ignoreDrag(e);
		// And that for the fix to work we accept `e.files`
		var files = (e.files||e.dataTransfer.files);
		if (files.length == 2 && !loading) { //Patch
			loading = true;
			function compare() {

				if (loadedFiles.z64.byteLength != loadedFiles.compare.byteLength) {
					popup("The size of the ROMs were not equal. Make sure that they are the same size.")
					delete loadedFiles;
					loading = false;
					return;
				}
				
				var scriptBlob = new Blob([document.querySelector('#compareScript').textContent]);
				try {//Try to create a worker from a url blob (Not possible in IE)
					var worker = new Worker(window.URL.createObjectURL(scriptBlob));
				} catch (err) {
					try {//If it doesn't work, try to load the worker from an external script. (Not possible with local files in Chrome)
						var worker = new Worker('resources/scripts/compare.js');
					} catch (err) {//If none of the methods work, abort the compare.
						popup("Could not compare files. Make sure that your browser is up to date.",5000,"error");
						delete $ROMname;
						delete loadedFiles;
						loading = false;
						return;
					}
				}
				worker.postMessage(
					{
					type:"start",
					ROM: loadedFiles
					}
				);
				worker.addEventListener('message', function(e) {
					if (e.data.type == 'loading') {
						setLoadingBar(e.data.current,e.data.total,"Comparing bytes");
					} else if (e.data.type == 'done') {
						saveAs(new Blob([e.data.patch[0]], { type: "text/plain" }), $ROMname[0].slice(0, -4)+"_Patch_"+timestamp()+".txt");
						saveAs(new Blob([e.data.patch[1]], { type: "text/plain" }), $ROMname[1].slice(0, -4)+"_Patch_"+timestamp()+".txt");
						delete $ROMname;
						delete loadedFiles;
						loading = false;
						$('#combineBar').slideUp(1000, function(){
							setLoadingBar(0,1,"",true);
						});
					}
				}, false);
			}
			
			function applyPatchFile(patch,fname,ofs) {
				var adders = {};
				var conditions = {};
				var directory = "";
				if (ofs) {
					adders.ofs = parseInt(ofs);
				}
				//Convert gameshark lines
				patch = patch.replace(/^([0-9A-F]{8}) ([0-9A-F ]*)$/igm, "0x$1,$2");
				patch = patch.replace(/^([^;]*).*$/igm, "$1");
				patch = patch.replace(/[ \t\f\v]/g, '');
				var lines = patch.match(/^.*$/gm);
				//console.log(lines);
				$.each(lines, function(i,line){
					if (aborted) {
						return false;
					}
					i = Math.floor(i/2)+1;
					if (line == "" || line.substring(0,1) == ";") return;
					//console.log("______________________________________");
					//Check if end condition
					var check = line.match(/^(endcon),([a-z_0-9]*)$/im);
					if (check) {
						check.splice(0, 1);
						delete check.index; 
						delete conditions[check[1]];
						//console.log("End Condition "+check[1]+" (Line "+i+" in patch)");
						//console.log(i+": "+line);
						//console.log(check);
						return;
					} else if (!$.isEmptyObject(conditions)) {
						//console.log("All conditions are not met. Skipping Line "+i);
						return;
					}
					//Check if end adder
					var check = line.match(/^(endadd),([a-z_0-9]*)$/im);
					if (check) {
						check.splice(0, 1);
						delete check.index; 
						delete adders[check[1]];
						//console.log("End adder "+check[1]+" (Line "+i+" in patch)");
						//console.log(i+": "+line);
						//console.log(check);
						return;
					}
					//Check if end
					var check = line.match(/^end$/im);
					if (check) {
						check.splice(0, 1);
						delete check.index;
						//console.log("End (Line "+i+" in patch)");
						//console.log(i+": "+line);
						//console.log(check);
						return false;
					}
					//Check if abort
					var check = line.match(/^abort$/im);
					if (check) {
						check.splice(0, 1);
						delete check.index;
						//console.log("Abort (Line "+i+" in patch)");
						//console.log(i+": "+line);
						//console.log(check);
						aborted = true;
						return false;
					}
					//Check if alert
					var check = line.match(/^(alert),(.*)$/im);
					if (check) {
						check.splice(0, 1);
						delete check.index; 
						popup(check[1],5000,"error");
						//console.log("Alert (Line "+i+" in patch)");
						//console.log(i+": "+line);
						//console.log(check);
						return;
					}
					//Check if directory
					var check = line.match(/^(dir),(.*)$/im);
					if (check) {
						check.splice(0, 1);
						delete check.index;
						
						//console.log("Directory (Line "+i+" in patch)");
						//console.log(i+": "+line);
						//console.log(check);
						directory = check[1].toLowerCase();
						return;
					}
					//Check if disabler
					var check = line.match(/^(dis),(.*)$/im);
					if (check) {
						check.splice(0, 1);
						delete check.index;
						
						//console.log("Disabler (Line "+i+" in patch)");
						//console.log(i+": "+line);
						//console.log(check);
						disablers[directory+check[1].toLowerCase()] = true;
						//console.log(disablers);
						return;
					}
					//Convert variables to value
					var newLine = line.replace(/\{([a-z_0-9]*)\}/ig,
						function($0,$1) { 
							return variables[$1.toLowerCase()];
						}
					);
					//Convert pointers to value
					newLine = newLine.replace(/\[([-()\d/*+.&<>|~x%a-f]*)\]/ig,
						function($0,$1) { 
							var pointer = eval($1);
							try {
								var address = $ROM.getUint32(pointer);
								return address;
							} catch (error) {
								popup("Attempted to read from 0x"+pad(pointer.toString(16),6).toUpperCase()+" in file "+fname+" at line "+i+": "+line,10000,"error");
								aborted = true;
								return false;
							}
						}
					);
					//Check if condition
					var check = newLine.match(/^(con),([a-z_0-9]*),([^,\n\r]*)$/im);
					if (check) {
						check.splice(0, 1);
						delete check.index; 
						check[2] = eval(check[2]);
						if (!check[2]) conditions[check[1]] = true;
						//console.log("Condition "+check[1]+" (Line "+i+" in patch)");
						//console.log(i+": "+line);
						//console.log(check);
						return;
					}
					//Check if adder
					var check = newLine.match(/^(add),([a-z_0-9]*),([^,\n\r]*)$/im);
					if (check) {
						check.splice(0, 1);
						delete check.index; 
						check[2] = eval(check[2]);
						adders[check[1]] = check[2];
						//console.log("Adder "+check[1]+" (Line "+i+" in patch)");
						//console.log(i+": "+line);
						//console.log(check);
						return;
					}
					//Check if offset
					var check = newLine.match(/^(ofs),([a-z_0-9\/]*),([^,\n\r]*)$/im);
					if (check) {
						check.splice(0, 1);
						delete check.index; 
						check[2] = eval(check[2]);
						offsets[directory+check[1].toLowerCase()] = check[2];
						//console.log(offsets);
						//console.log("Offset "+check[1]+" (Line "+i+" in patch)");
						//console.log(i+": "+line);
						//console.log(check);
						return;
					}
					//Check if variable
					var check = newLine.match(/^(var),([a-z_0-9]*),([^,\n\r]*)$/im);
					if (check) {
						check.splice(0, 1);
						delete check.index; 
						check[2] = eval(check[2]);
						variables[check[1].toLowerCase()] = check[2];
						//console.log("Variable "+check[1]+" (Line "+i+" in patch)");
						//console.log(i+": "+line);
						//console.log(check);
						return;
					}
					//Check if patch
					var check = newLine.match(/^([^,\n\r]*),([^,\n\r]*)$/im);
					if (check) {
						//Set up address
						var preval = 0;
						$.each(adders, function(i,v){
							preval += parseInt(v);
						});
						check.splice(0, 1);
						delete check.index;
						check[0] = eval(check[0])+preval;
						var address = check[0];
						//Parse math to string
						check[1] = check[1].replace(/\"([^_]*)_([0-9]*)\"/ig,
							function($0,$1,$2) { 
								return pad(eval($1).toString(16).toUpperCase(),eval($2));
							}
						);
						check[1] = check[1].replace(/[^0-9A-F]/g,'');
						//Apply hex string
						var bytes = check[1].match(/.{1,2}/g);
						console.log(fname+" "+pad(i,4)+": 0x"+pad((address).toString(16),6).toUpperCase()+" = "+check[1]);
						$.each(bytes, function(byteID, val){
							var writeAddr = address+parseInt(byteID);
							try {
								$ROM.setUint8(writeAddr,parseInt(val,16));
							} catch (error) {
								popup("Attempted to write to 0x"+pad(writeAddr.toString(16),6).toUpperCase()+" in file "+fname+" at line "+i+": "+line,10000,"error");
								aborted = true;
								return false;
							}
						});
						//console.log("Patch addr 0x"+pad(address.toString(16),8).toUpperCase()+" (Line "+i+" in patch)");
						//console.log(i+": "+line);
						//console.log(check);
						//console.log(bytes);
						return;
					}
					//
					//console.log("Unrecognized format on line "+i+" in patch file.");
					//console.log(i+": "+line);
				});
			}
			
			function combinePack() {
				$ROM = new DataView(loadedFiles.z64);
				aborted = false;
				var zip = new JSZip();
				var pack = zip.load(loadedFiles.zip);
				var initFile = pack.file(/^_init\.txt/);
				var patchFiles = pack.folder("patches").file(/^(.*)\.txt/);
				console.log(patchFiles);
				if ($.isEmptyObject(patchFiles) && $.isEmptyObject(gsFiles)) {
					popup("Could not locate any patches in the zip. Make sure that it is set up properly.",5000,"error");
					loading = false;
					delete $ROM;
					delete $ROMname;
					delete loadedFiles;
					delete aborted;
					return false;
				}
				variables = {};
				offsets = {};
				disablers = {};
				if (!$.isEmptyObject(initFile)) {
					var patch = initFile[0].asText();
					applyPatchFile(patch,"_init");
				}
				$.each(patchFiles, function(i,f) {
					var patch = f.asText();
					var fname = f.name.match(/^patches\/([A-Z0-9_\/]*)\.txt$/i);
					//console.log(fname);
					//console.log(offsets);
					if (disablers[fname[1]]) {
						console.log("Patch "+fname[1]+" is disabled, skipping it.");
						return;
					} else {
						if (offsets[fname[1]]) {
							applyPatchFile(patch,fname[1],offsets[fname[1]]);
						} else {
							applyPatchFile(patch,fname[1]);
						}
					}
				});
				if (!aborted) {
					var blob = new Blob([$ROM.buffer]);
					saveAs(blob, $ROMname[0].slice(0, -4)+"_Patched_"+timestamp()+"."+getExtension($ROMname[0]));
				}
				delete $ROM;
				delete $ROMname;
				delete loadedFiles;
				delete variables;
				delete offsets;
				delete disablers;
				delete aborted;
				loading = false;
			}
			
			function combine() {
				$ROM = new DataView(loadedFiles.z64);
				aborted = false;
				variables = {};
				offsets = {};
				disablers = {};
				var patch = loadedFiles.txt;
				applyPatchFile(patch,"patch");
				if (!aborted) {
					var blob = new Blob([$ROM.buffer]);
					saveAs(blob, $ROMname[0].slice(0, -4)+"_Patched_"+timestamp()+"."+getExtension($ROMname[0]));
				}
				delete $ROM;
				delete $ROMname;
				delete loadedFiles;
				delete variables;
				delete offsets;
				delete disablers;
				delete aborted;
				loading = false;
			}
			
			loadedFiles = {};
			
			$.each(files, function(i,file) {
				var extension = getExtension(file.name);
				if (!(extension=="z64"||extension=="n64"||extension=="v64"||extension=="txt"||extension=="zip")) {
					popup("At least one of the provided files was not a ROM or Patch.",5000,"error");
					loading = false;
					return;
				}
				var reader = new FileReader();
				reader.onload = (function(theFile) {
					return function(e) {
						var extension = getExtension(file.name);
						console.log(extension);
						if (extension=="z64"||extension=="n64"||extension=="v64") {
							if (typeof $ROMname === 'undefined') $ROMname = [];
							if (loadedFiles.z64) {
								loadedFiles.compare = e.target.result;
								$ROMname[1] = file.name;
							} else {
								loadedFiles.z64 = e.target.result;
								$ROMname[0] = file.name;
							}
						} else if (extension=="txt") {
							if (loadedFiles.txt || loadedFiles.zip) {
								popup("You provided 2 patches. You must provide a ROM and a Patch.",5000,"error");
								loading = false;
							} else {
								loadedFiles.txt = e.target.result;
							}
						} else if (extension=="zip") {
							if (loadedFiles.zip || loadedFiles.txt) {
								popup("You provided 2 patches. You must provide a ROM and a Patch.",5000,"error");
								loading = false;
							} else {
								loadedFiles.zip = e.target.result;
							}
						}
					}
				})(file);
				var blob = file;
				if (extension=="txt") {
					reader.readAsText(blob);
				} else {
					reader.readAsArrayBuffer(blob);
				}
			});
			
			function clearData() {
				delete $ROM;
				delete $ROMname;
				delete loadedFiles;
				delete aborted;
				delete variables;
				delete offsets;
				loading = false;
			}
			
			function updateTimeout() {
				//Stop loop
				if (!loading) return false;
				//Check if stuff has loaded
				if (loadedFiles.z64 && loadedFiles.txt) {
					try {
						combine();
					} catch (err) {
						popup(err,5000,"error");
						delete $ROM;
						delete $ROMname;
						delete loadedFiles;
						delete aborted;
						loading = false;
					}
					return false;
				} else if (loadedFiles.z64 && loadedFiles.zip) {
					try {
						combinePack();
					} catch (err) {
						popup(err,5000,"error");
						delete $ROM;
						delete $ROMname;
						delete loadedFiles;
						delete aborted;
						loading = false;
					}
					return false;
				} else if (loadedFiles.z64 && loadedFiles.compare) {
					try {
						compare();
					} catch (err) {
						popup(err,5000,"error");
						delete $ROMname;
						delete loadedFiles;
						loading = false;
					}
					return false;
				
				}
				//Loop
				setTimeout(updateTimeout, 100);
			}
			updateTimeout();
		}
		return false;
	});
});

function base64ArrayBuffer(arrayBuffer) {
  var base64    = ''
  var encodings = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'
 
  var bytes         = new Uint8Array(arrayBuffer)
  var byteLength    = bytes.byteLength
  var byteRemainder = byteLength % 3
  var mainLength    = byteLength - byteRemainder
 
  var a, b, c, d
  var chunk
 
  // Main loop deals with bytes in chunks of 3
  for (var i = 0; i < mainLength; i = i + 3) {
    // Combine the three bytes into a single integer
    chunk = (bytes[i] << 16) | (bytes[i + 1] << 8) | bytes[i + 2]
 
    // Use bitmasks to extract 6-bit segments from the triplet
    a = (chunk & 16515072) >> 18 // 16515072 = (2^6 - 1) << 18
    b = (chunk & 258048)   >> 12 // 258048   = (2^6 - 1) << 12
    c = (chunk & 4032)     >>  6 // 4032     = (2^6 - 1) << 6
    d = chunk & 63               // 63       = 2^6 - 1
 
    // Convert the raw binary segments to the appropriate ASCII encoding
    base64 += encodings[a] + encodings[b] + encodings[c] + encodings[d]
  }
 
  // Deal with the remaining bytes and padding
  if (byteRemainder == 1) {
    chunk = bytes[mainLength]
 
    a = (chunk & 252) >> 2 // 252 = (2^6 - 1) << 2
 
    // Set the 4 least significant bits to zero
    b = (chunk & 3)   << 4 // 3   = 2^2 - 1
 
    base64 += encodings[a] + encodings[b] + '=='
  } else if (byteRemainder == 2) {
    chunk = (bytes[mainLength] << 8) | bytes[mainLength + 1]
 
    a = (chunk & 64512) >> 10 // 64512 = (2^6 - 1) << 10
    b = (chunk & 1008)  >>  4 // 1008  = (2^6 - 1) << 4
 
    // Set the 2 least significant bits to zero
    c = (chunk & 15)    <<  2 // 15    = 2^4 - 1
 
    base64 += encodings[a] + encodings[b] + encodings[c] + '='
  }
  
  return base64
}