function pad(n, width, z) {
  z = z || '0';
  n = n + '';
  return n.length >= width ? n : new Array(width - n.length + 1).join(z) + n;
}

function waitForFile() {
	$differences = [];
	for (var index = 0;index < $ROM[0].byteLength;index++) {
		if ($ROM[0].getUint8(index) != $ROM[1].getUint8(index)) {
			var lastEntry = $differences.length-1;
			if ($differences[lastEntry] && $differences[lastEntry].end == index-1) {
				$differences[lastEntry].data[0].push($ROM[0].getUint8(index));
				$differences[lastEntry].data[1].push($ROM[1].getUint8(index));
				$differences[lastEntry].end = index;
			} else {
				$differences.push({
					start:index,
					end:index,
					data:[
						[$ROM[0].getUint8(index)],
						[$ROM[1].getUint8(index)]
					]
				});
			}
		}
		if (index%0x1000==0 || index+1 == $ROM[0].byteLength) {
			self.postMessage({
				type:'loading',
				current:index+1,
				total:$ROM[0].byteLength
			});
		}
	}
	var patchString = ['',''];
	for (var i = 0; i < $differences.length; i++) {
		var obj = $differences[i];
		var patchLine = ['',''];
		for (var di = 0; di < obj.data[0].length; di++) {
			patchLine[0] += pad(obj.data[0][di].toString(16),2).toUpperCase();
			patchLine[1] += pad(obj.data[1][di].toString(16),2).toUpperCase();
		}
		var addr = '0x'+pad(obj.start.toString(16),7).toUpperCase()+',';
		patchString[0] += addr+patchLine[0]+'\r\n';
		patchString[1] += addr+patchLine[1]+'\r\n';
	}
	self.postMessage({
		type:'done',
		patch: patchString
	});
	delete $ROM;
	delete $differences;
}

self.addEventListener('message', function(e) {
	if (e.data.type == 'start') {
		$ROM = [
			new DataView(e.data.ROM.z64),
			new DataView(e.data.ROM.compare)
		]
		waitForFile();
	}
}, false);	