/************************************************************
This file is what tells the tool where all textures are
located for the OoT Debug ROM.

Format:
generators["<name of this file>"] = [
	"<folder name>":{
		type:<address or pointer>,
		address:<address of the folder>,
		textures:{
			<texture address relative to folder>:{size:[<texture width>,<texture height>],format:"<texture format>",name:"<texture name>"},
			...
		}
	},
	...
];

Example:
generators["oot_debug_gen"] = {
	"icon_item_static":{
		type:pointer,
		address:0x12FE0,
		textures:{
			0x5A000:{size:[48,48],format:"ia8",name:"Heart Piece 1"}
		}
	}
};
this would generate a texture pack which contains:
pack/P_00012FE0_icon_item_static/0005A000_ia8_Heart_Piece_1.png

Note that if the texture or folder name contains symbols
which are not supported, they'll be replaced with a hyphen.
Spaces will turn into underscores.
************************************************************/

generators["oot_debug_gen"] = {
	"icon_item_static":{
		type:pointer,
		address:0x12FE0,
		textures:{
			0x5A000:{size:[48,48],format:"ia8",name:"Heart Piece 1"},
			0x5A900:{size:[48,48],format:"ia8",name:"Heart Piece 2"},
			0x5B200:{size:[48,48],format:"ia8",name:"Heart Piece 3"},
			0x875C0:{size:[24,16],format:"ia8",name:"A Btn Symbol"},
			0x878C0:{size:[48,16],format:"ia8",name:"C Btn Symbols"},
			0x87BC0:{size:[72,24],format:"ia8",name:"Name Panel Left"},
			0x88280:{size:[72,24],format:"ia8",name:"Name Panel Right"},
			0x88940:{size:[24,32],format:"ia8",name:"L Button"},
			0x88C40:{size:[24,32],format:"ia8",name:"R Button"},
			0x89440:{size:[16,24],format:"ia8",name:"Song Note"},
			0x86BC0:{size:[80,32],format:"ia8",name:"Game Over 1,0"},
			//0x5C3C0:{size:[80,2208],format:"ia8",name:"backgroundtextures"},
			//0x00000:{size:[16,((0x89CA0-0x00000)/16)/2],format:"ia16",name:"title_static"},
		}
	},
	"icon_item_24_static":{//COMPLETE
		type:pointer,
		address:0x12FF0,
		textures:{
			0x0000:{size:[24,24],format:"rgba32",name:"Forest Medallion"},
			0x0900:{size:[24,24],format:"rgba32",name:"Fire Medallion"},
			0x1200:{size:[24,24],format:"rgba32",name:"Water Medallion"},
			0x1B00:{size:[24,24],format:"rgba32",name:"Spirit Medallion"},
			0x2400:{size:[24,24],format:"rgba32",name:"Shadow Medallion"},
			0x2D00:{size:[24,24],format:"rgba32",name:"Light Medallion"},
			0x3600:{size:[24,24],format:"rgba32",name:"Kokiri's Emerald"},
			0x3F00:{size:[24,24],format:"rgba32",name:"Goron's Ruby"},
			0x4800:{size:[24,24],format:"rgba32",name:"Zora's Sapphire"},
			0x5100:{size:[24,24],format:"rgba32",name:"Stone of Agony"},
			0x5A00:{size:[24,24],format:"rgba32",name:"Gerudo's Card"},
			0x6300:{size:[24,24],format:"rgba32",name:"Gold Skulltula"},
			0x6C00:{size:[24,24],format:"rgba32",name:"Heart Container"},
			0x7500:{size:[24,24],format:"rgba32",name:"Piece of Heart"},
			0x7E00:{size:[24,24],format:"rgba32",name:"Boss Key"},
			0x8700:{size:[24,24],format:"rgba32",name:"Compass"},
			0x9000:{size:[24,24],format:"rgba32",name:"Dungeon Map"},
			0x9900:{size:[24,24],format:"rgba32",name:"Small Key"},
			0xA200:{size:[24,24],format:"rgba32",name:"Small Magic Jar"},
			0xAB00:{size:[24,24],format:"rgba32",name:"Big Magic Jar"},
		}
	},
	"icon_item_dungeon_static":{
		type:pointer,
		address:0x13010,
		textures:{
			0x0000:{size:[24,16],format:"ia8",name:"Blank Floor Button"},
			0x0180:{size:[24,16],format:"ia8",name:"1F Button"},
			0x0300:{size:[24,16],format:"ia8",name:"2F Button"},
			0x0480:{size:[24,16],format:"ia8",name:"3F Button"},
			0x0600:{size:[24,16],format:"ia8",name:"4F Button"},
			0x0780:{size:[24,16],format:"ia8",name:"5F Button"},
			0x0900:{size:[24,16],format:"ia8",name:"6F Button"},
			0x0A80:{size:[24,16],format:"ia8",name:"7F Button"},
			0x0C00:{size:[24,16],format:"ia8",name:"8F Button"},
			0x0D80:{size:[24,16],format:"ia8",name:"B1 Button"},
			0x0F00:{size:[24,16],format:"ia8",name:"B2 Button"},
			0x1080:{size:[24,16],format:"ia8",name:"B3 Button"},
			0x1200:{size:[24,16],format:"ia8",name:"B4 Button"},
			0x1380:{size:[24,16],format:"ia8",name:"B5 Button"},
			0x1500:{size:[24,16],format:"ia8",name:"B6 Button"},
			0x1680:{size:[24,16],format:"ia8",name:"B7 Button"},
			0x1800:{size:[24,16],format:"ia8",name:"B8 Button"},
		}
	},
	"icon_item_nes_static":{
		type:pointer,
		address:0x13030,
		textures:{
		}
	},
	"item_name_static":{//COMPLETE
		type:pointer,
		address:0x13060,
		textures:{
		}
	},
	"map_name_static":{//COMPLETE
		type:pointer,
		address:0x13070,
		textures:{
		}
	},
	"do_action_static":{//COMPLETE 
		type:pointer,
		address:0x13080,
		textures:{
		}
	},
	"message_static":{//COMPLETE
		type:pointer,
		address:0x13090,
		textures:{
		//not i8, ia8
			0x00000:{size:[128,64],format:"i4",name:"Default Background"},
			0x01000:{size:[128,64],format:"ia4",name:"Sign Background"},
			0x02000:{size:[128,64],format:"ia4",name:"Ocarina Background"},
			0x03000:{size:[128,64],format:"i4",name:"Fading Background"},
			0x04000:{size:[16,16],format:"i4",name:"Triangle"},
			0x04080:{size:[16,16],format:"i4",name:"Square"},
			0x04100:{size:[16,16],format:"i4",name:"Arrow"},
		}
	},
	/*
	"message_texture_static":{//
		type:pointer,
		address:0x130A0,
		textures:{
		}
	},
	*/
	"nes_font_static":{//COMPLETE
		type:pointer,
		address:0x130B0,
		textures:{
			/*
			The entire file contains 140 characters. size16x16 format: i4
			Added by a loop below.
			*/
		}
	},
	"map_grand_static":{//
		type:pointer,
		address:0x13100,
		textures:{
			0x00000:{size:[80,73],format:"ia4",name:"Hyrule Field"},
			0x00B68:{size:[80,64],format:"ia4",name:"Kakariko Village"},
			0x01568:{size:[80,39],format:"ia4",name:"Graveyard"},
			0x01B80:{size:[80,1000],format:"ia4",name:"Testing (this is not supposed to be in a released version)"},
		}
		/*
		graveyard: 39
		lonlon: 68
		crater: 78
		colossus: 59
		
		minimap is located at 80274F00 in graveyard
		801684B4 RAM Location to load too
		800014B0 get location
		
		0097F918 (A0), where does it get the value from?
		800014BC A3 is file offset in ROM, T2 is offset in file
		800014B8 T1 is file offset in ROM, S0 is map offset (97F918)
		80168448 contains 0x0097F918
		80001618 jump to start the whole thing, 80168448 is set to 0x0097F918 before this
		80001604 this function call sets 80168448 
		800016F0 this sets 80168448, it is loaded from 80168400
		80001678 this sets 80168400, it is set in a function which starts at 80001664, A2 is the argument which contains 0x0097F918
		0x80001AA4 is the function that calls the function above, A1 is the argument which contains 0x0097F918
		0x80080C74 this command loads the offset for the minimap
		
		0x80124D40 minimap data
		
		0x80080AB4 start of function
		0x80080AD4 get which minimap to load
		
		0x80000BFC ROM TO RAM
		*/
	},
	"map_48x85_static":{//
		type:pointer,
		address:0x13110,
		textures:{
			0x00000:{size:[80,1000],format:"ia4",name:"maps"},
		}
	},
	"map_i_static":{//
		type:pointer,
		address:0x13120,
		textures:{
			0x00000:{size:[80,1000],format:"ia4",name:"maps"},
		}
	},
	"object_mag":{
		type:pointer,
		address:0x161C0,
		textures:{
			0x00000:{size:[160,160],format:"rgba32",name:"Title Screen Logo"},
			0x19A00:{size:[160,16],format:"ia8",name:"Copyright"},
			0x1A400:{size:[128,32],format:"rgba32",name:"Master Quest Title"},
			/*
			0x20000-0x24800 Logo mask
			*/
			0x24C00:{size:[72,8],format:"i8",name:"The Legend of"},
			0x24E40:{size:[96,8],format:"i8",name:"Ocarina of Time"},
		}
	},
	"title_static":{//COMPLETE? (Not sure if 0x46E00-0x46EFF is a texture or not)
		type:pointer,
		address:0x16A20,
		textures:{
			0x00000:{size:[24,16],format:"ia8",name:"File Attachment"},
			0x00180:{size:[16,16],format:"ia8",name:"Forest Medallion"},
			0x00280:{size:[16,16],format:"ia8",name:"Fire Medallion"},
			0x00380:{size:[16,16],format:"ia8",name:"Water Medallion"},
			0x00480:{size:[16,16],format:"ia8",name:"Spirit Medallion"},
			0x00580:{size:[16,16],format:"ia8",name:"Shadow Medallion"},
			0x00680:{size:[16,16],format:"ia8",name:"Light Medallion"},
			0x00780:{size:[64,32],format:"ia16",name:"FS Background 0,0"},
			0x01780:{size:[64,32],format:"ia16",name:"FS Background 1,0"},
			0x02780:{size:[64,32],format:"ia16",name:"FS Background 2,0"},
			0x03780:{size:[48,32],format:"ia16",name:"FS Background 3,0"},
			0x04380:{size:[64,32],format:"ia16",name:"FS Background 0,1"},
			0x05380:{size:[64,32],format:"ia16",name:"FS Background 1,1"},
			0x06380:{size:[64,32],format:"ia16",name:"FS Background 2,1"},
			0x07380:{size:[48,32],format:"ia16",name:"FS Background 3,1"},
			0x07F80:{size:[64,32],format:"ia16",name:"FS Background 0,2"},
			0x08F80:{size:[64,32],format:"ia16",name:"FS Background 1,2"},
			0x09F80:{size:[64,32],format:"ia16",name:"FS Background 2,2"},
			0x0AF80:{size:[48,32],format:"ia16",name:"FS Background 3,2"},
			0x0BB80:{size:[64,32],format:"ia16",name:"FS Background 0,3"},
			0x0CB80:{size:[64,32],format:"ia16",name:"FS Background 1,3"},
			0x0DB80:{size:[64,32],format:"ia16",name:"FS Background 2,3"},
			0x0EB80:{size:[48,32],format:"ia16",name:"FS Background 3,3"},
			0x0F780:{size:[64,32],format:"ia16",name:"FS Background 0,4"},
			0x10780:{size:[64,32],format:"ia16",name:"FS Background 1,4"},
			0x11780:{size:[64,32],format:"ia16",name:"FS Background 2,4"},
			0x12780:{size:[48,32],format:"ia16",name:"FS Background 3,4"},
			0x13380:{size:[28,16],format:"ia16",name:"Kanji Button (Unused)"},
			0x13700:{size:[44,16],format:"ia16",name:"Hiragana Button (Unused)"},
			0x13C80:{size:[44,16],format:"ia16",name:"Katakana Button (Unused)"},
			0x14200:{size:[44,16],format:"ia16",name:"END Button"},
			0x14780:{size:[44,16],format:"ia16",name:"ENDE Button"},
			0x14D00:{size:[44,16],format:"ia16",name:"FIN Button"},
			0x15280:{size:[28,16],format:"ia16",name:"Backspace Button"},
			0x15600:{size:[108,16],format:"ia16",name:"File Name Background"},
			0x16380:{size:[36,56],format:"ia16",name:"FS File Background 1"},
			0x17340:{size:[36,56],format:"ia16",name:"FS File Background 2"},
			0x18300:{size:[36,56],format:"ia16",name:"FS File Background 3"},
			0x192C0:{size:[36,56],format:"ia16",name:"FS File Background 4"},
			0x1A280:{size:[24,56],format:"ia16",name:"FS File Background 5"},
			0x1AD00:{size:[44,16],format:"ia16",name:"DISK Button"},
			0x1B280:{size:[256,2],format:"ia4",name:"Options Separator"},
			0x1B380:{size:[96,16],format:"ia4",name:"Brightness Check"},
			0x1B680:{size:[72,24],format:"i8",name:"Big Button Highlight"},
			0x1BD40:{size:[24,24],format:"i8",name:"Name Select Letter Highlight"},
			0x1BF80:{size:[56,24],format:"i8",name:"Medium Button Highlight"},
			0x1C4C0:{size:[40,24],format:"i8",name:"Small Button Highlight"},
			0x1C880:{size:[16,16],format:"rgba32",name:"Kokiri's Emerald"},
			0x1CC80:{size:[16,16],format:"rgba32",name:"Goron's Ruby"},
			0x1D080:{size:[16,16],format:"rgba32",name:"Zora's Sapphire"},
			0x1D480:{size:[128,16],format:"ia8",name:"no file to copy"},
			0x1DC80:{size:[128,16],format:"ia8",name:"no file to erase."},
			0x1E480:{size:[128,16],format:"ia8",name:"There is no empty file."},
			0x1EC80:{size:[128,16],format:"ia8",name:"This is an empty file."},
			0x1F480:{size:[128,16],format:"ia8",name:"This file is in use."},
			0x1FC80:{size:[128,16],format:"ia8",name:"Keine Datei vorhanden."},
			0x20480:{size:[128,16],format:"ia8",name:"Keine Datei vorhanden."},
			0x20C80:{size:[128,16],format:"ia8",name:"Keine leere Datei!"},
			0x21480:{size:[128,16],format:"ia8",name:"Datei ist leer!"},
			0x21C80:{size:[128,16],format:"ia8",name:"Datei ist belegt!"},
			0x22480:{size:[128,16],format:"ia8",name:"Aucun fichier à copier"},
			0x22C80:{size:[128,16],format:"ia8",name:"Aucun fichier à effacer"},
			0x23480:{size:[128,16],format:"ia8",name:"Aucun fichier vide"},
			0x23C80:{size:[128,16],format:"ia8",name:"Ce fichier est vide"},
			0x24480:{size:[128,16],format:"ia8",name:"Ce fichier est utilisé"},
			0x24C80:{size:[128,16],format:"ia8",name:"Copy which file?"},
			0x25480:{size:[128,16],format:"ia8",name:"Copy to which file?"},
			0x25C80:{size:[128,16],format:"ia8",name:"Are you sure?"},
			0x26480:{size:[128,16],format:"ia8",name:"File copied."},
			0x26C80:{size:[128,16],format:"ia8",name:"Welche Datei?"},
			0x27480:{size:[128,16],format:"ia8",name:"Wohin kopieren?"},
			0x27C80:{size:[128,16],format:"ia8",name:"Sicher?"},
			0x28480:{size:[128,16],format:"ia8",name:"Datei kopiert."},
			0x28C80:{size:[128,16],format:"ia8",name:"Copier quel fichier?"},
			0x29480:{size:[128,16],format:"ia8",name:"Copier sur quel fichier?"},
			0x29C80:{size:[128,16],format:"ia8",name:"Etes-vous sûr?"},
			0x2A480:{size:[128,16],format:"ia8",name:"Fichier copié"},
			0x2AC80:{size:[128,16],format:"ia8",name:"Please select a file"},
			0x2B480:{size:[128,16],format:"ia8",name:"Open this file?"},
			0x2BC80:{size:[128,16],format:"ia8",name:"Datei wählen."},
			0x2C480:{size:[128,16],format:"ia8",name:"Datei öffnen?"},
			0x2CC80:{size:[128,16],format:"ia8",name:"Veuillez choisir un fichier"},
			0x2D480:{size:[128,16],format:"ia8",name:"Ouvrir ce fichier?"},
			0x2DC80:{size:[128,16],format:"ia8",name:"Erase which file?"},
			0x2E480:{size:[128,16],format:"ia8",name:"Are you sure?"},
			0x2EC80:{size:[128,16],format:"ia8",name:"File erased."},
			0x2F480:{size:[128,16],format:"ia8",name:"Welche Datei?"},
			0x2FC80:{size:[128,16],format:"ia8",name:"Sicher?"},
			0x30480:{size:[128,16],format:"ia8",name:"Datei gelöscht."},
			0x30C80:{size:[128,16],format:"ia8",name:"Effacer quel fichier?"},
			0x31480:{size:[128,16],format:"ia8",name:"Etes-vous sûr?"},
			0x31C80:{size:[128,16],format:"ia8",name:"Fichier effacé"},
			0x32480:{size:[128,16],format:"ia8",name:"Options"},
			0x32C80:{size:[128,16],format:"ia8",name:"Optionen"},
			0x33480:{size:[56,16],format:"ia8",name:"Name?"},
			0x33800:{size:[56,16],format:"ia8",name:"Name? (Unused)"},
			0x33B80:{size:[56,16],format:"ia8",name:"Nom?"},
			0x33F00:{size:[144,16],format:"ia8",name:"A-Decide B-Cancel"},
			0x34800:{size:[144,16],format:"ia8",name:"A-Eingabe B-Zurück"},
			0x35100:{size:[144,16],format:"ia8",name:"A-Valider B-Annuler"},
			0x35A00:{size:[64,16],format:"ia16",name:"Copy Button"},
			0x36200:{size:[64,16],format:"ia16",name:"Kopieren Button"},
			0x36A00:{size:[64,16],format:"ia16",name:"Copier Button"},
			0x37200:{size:[64,16],format:"ia16",name:"File 1 Button"},
			0x37A00:{size:[64,16],format:"ia16",name:"File 2 Button"},
			0x38200:{size:[64,16],format:"ia16",name:"File 3 Button"},
			0x38A00:{size:[64,16],format:"ia16",name:"Datei 1 Button"},
			0x39200:{size:[64,16],format:"ia16",name:"Datei 2 Button"},
			0x39A00:{size:[64,16],format:"ia16",name:"Datei 3 Button"},
			0x3A200:{size:[64,16],format:"ia16",name:"Fichier 1 Button"},
			0x3AA00:{size:[64,16],format:"ia16",name:"Fichier 2 Button"},
			0x3B200:{size:[64,16],format:"ia16",name:"Fichier 3 Button"},
			0x3BA00:{size:[64,16],format:"ia16",name:"Yes Button"},
			0x3C200:{size:[64,16],format:"ia16",name:"Ja Button"},
			0x3CA00:{size:[64,16],format:"ia16",name:"Oui Button"},
			0x3D200:{size:[64,16],format:"ia16",name:"Erase Button"},
			0x3DA00:{size:[64,16],format:"ia16",name:"Löschen Button"},
			0x3E200:{size:[64,16],format:"ia16",name:"Effacer Button"},
			0x3EA00:{size:[64,16],format:"ia16",name:"Quit Button"},
			0x3F200:{size:[64,16],format:"ia16",name:"Zurück Button"},
			0x3FA00:{size:[64,16],format:"ia16",name:"Retour Button"},
			0x40200:{size:[48,16],format:"ia8",name:"Surround"},
			0x40500:{size:[48,16],format:"ia8",name:"Headset"},
			0x40800:{size:[48,16],format:"ia8",name:"Kopfhörer"},
			0x40B00:{size:[48,16],format:"ia8",name:"Casque"},
			0x40E00:{size:[48,16],format:"ia8",name:"Mono"},
			0x41100:{size:[64,16],format:"ia8",name:"SOUND"},
			0x41500:{size:[64,16],format:"ia8",name:"SON"},
			0x41900:{size:[48,16],format:"ia8",name:"Stereo"},
			0x41C00:{size:[48,16],format:"ia8",name:"Stéréo"},
			0x41F00:{size:[64,16],format:"ia8",name:"L TARGETING"},
			0x42300:{size:[144,16],format:"ia8",name:"ZIELERFASSUNG (L-TRIGGER)"},
			0x42C00:{size:[64,16],format:"ia8",name:"VISEE L"},
			0x43000:{size:[48,16],format:"ia8",name:"Switch"},
			0x43300:{size:[80,16],format:"ia8",name:"Einmal drücken"},
			0x43800:{size:[48,16],format:"ia8",name:"Fixe"},
			0x43B00:{size:[48,16],format:"ia8",name:"Hold"},
			0x43E00:{size:[80,16],format:"ia8",name:"L-Trigger halten"},
			0x44300:{size:[48,16],format:"ia8",name:"Maintenue"},
			0x44600:{size:[128,16],format:"ia8",name:"CHECK BRIGHTNESS"},
			0x44E00:{size:[128,16],format:"ia8",name:"KONTRAST ÜBERPRÜFEN"},
			0x45600:{size:[128,16],format:"ia8",name:"CONTROLE LUMIERE"},
			0x45E00:{size:[64,16],format:"ia16",name:"Options Button"},
			0x46600:{size:[64,16],format:"ia16",name:"Optionen Button"},
			/*
			0x46E00-0x46F00 (0x100 bytes) is unknown. Either a texture which I couldn't figure out, or some other data.
			*/
			/*
			0x46F00 to 0x47440 is file select background data
			*/
		}
	},
	"parameter_static":{
		type:pointer,
		address:0x16A30,
		textures:{
			0x0000:{size:[16,16],format:"ia8",name:"0/4 Heart"},
			0x0100:{size:[16,16],format:"ia8",name:"1/4 Heart"},
			0x0200:{size:[16,16],format:"ia8",name:"2/4 Heart"},
			0x0300:{size:[16,16],format:"ia8",name:"3/4 Heart"},
			0x0400:{size:[16,16],format:"ia8",name:"4/4 Heart"},
			0x0500:{size:[16,16],format:"ia8",name:"0/4 Heart (Double Defense)"},
			0x0600:{size:[16,16],format:"ia8",name:"1/4 Heart (Double Defense)"},
			0x0700:{size:[16,16],format:"ia8",name:"2/4 Heart (Double Defense)"},
			0x0800:{size:[16,16],format:"ia8",name:"3/4 Heart (Double Defense)"},
			0x0900:{size:[16,16],format:"ia8",name:"4/4 Heart (Double Defense)"},
			0x0A00:{size:[32,32],format:"ia8",name:"Action Button"},
			0x0E00:{size:[32,32],format:"ia8",name:"Equipped Item Border"},
			0x1200:{size:[32,32],format:"ia8",name:"Empty C-Left Button Arrow"},
			0x1600:{size:[32,32],format:"ia8",name:"Empty C-Down Button Arrow"},
			0x1A00:{size:[32,32],format:"ia8",name:"Empty C-Right Button Arrow"},
			0x1E00:{size:[16,16],format:"ia8",name:"Small Key"},
			0x1F00:{size:[16,16],format:"ia8",name:"Rupee"},
			0x2000:{size:[16,16],format:"ia8",name:"Clock"},
			0x2100:{size:[16,16],format:"rgba32",name:"Carrot"},
			0x2500:{size:[8,8],format:"rgb5a1",name:"Minimap Dungeon Entrance"},
			0x2580:{size:[8,8],format:"rgb5a1",name:"Minimap Chest"},
			//0x2680 to 0x2900 (0x280 bytes) are unknown
			0x2900:{size:[8,8],format:"ia8",name:"Minimap Boss Skull"},
			0x2940:{size:[16,16],format:"ia8",name:"Ocarina A Button"},
			0x2A40:{size:[16,16],format:"ia8",name:"Ocarina C-Down Button"},
			0x2B40:{size:[16,16],format:"ia8",name:"Ocarina C-Right Button"},
			0x2C40:{size:[16,16],format:"ia8",name:"Ocarina C-Left Button"},
			0x2D40:{size:[16,16],format:"ia8",name:"Ocarina C-Up Button"},
			0x2E40:{size:[16,32],format:"i4",name:"Ocarina Clef"},
			//0x2F40 to 0x3040 (0x100 bytes) are unknown
			//Counter basically means that the texture is used for value displays such as rupee, clock and skulltula amount.
			0x3040:{size:[8,16],format:"i8",name:"Counter Digit 0"},
			0x30C0:{size:[8,16],format:"i8",name:"Counter Digit 1"},
			0x3140:{size:[8,16],format:"i8",name:"Counter Digit 2"},
			0x31C0:{size:[8,16],format:"i8",name:"Counter Digit 3"},
			0x3240:{size:[8,16],format:"i8",name:"Counter Digit 4"},
			0x32C0:{size:[8,16],format:"i8",name:"Counter Digit 5"},
			0x3340:{size:[8,16],format:"i8",name:"Counter Digit 6"},
			0x33C0:{size:[8,16],format:"i8",name:"Counter Digit 7"},
			0x3440:{size:[8,16],format:"i8",name:"Counter Digit 8"},
			0x34C0:{size:[8,16],format:"i8",name:"Counter Digit 9"},
			0x3540:{size:[8,16],format:"i8",name:"Counter Colon"},
			0x35C0:{size:[8,8],format:"ia8",name:"Item Amount Digit 0"},
			0x3600:{size:[8,8],format:"ia8",name:"Item Amount Digit 1"},
			0x3640:{size:[8,8],format:"ia8",name:"Item Amount Digit 2"},
			0x3680:{size:[8,8],format:"ia8",name:"Item Amount Digit 3"},
			0x36C0:{size:[8,8],format:"ia8",name:"Item Amount Digit 4"},
			0x3700:{size:[8,8],format:"ia8",name:"Item Amount Digit 5"},
			0x3740:{size:[8,8],format:"ia8",name:"Item Amount Digit 6"},
			0x3780:{size:[8,8],format:"ia8",name:"Item Amount Digit 7"},
			0x37C0:{size:[8,8],format:"ia8",name:"Item Amount Digit 8"},
			0x3800:{size:[8,8],format:"ia8",name:"Item Amount Digit 9"},
			0x3840:{size:[16,8],format:"ia8",name:"1/2 (Beta Double Magic Meter?)"},
			0x38C0:{size:[8,16],format:"ia8",name:"Magic Meter Side"},
			0x3940:{size:[24,16],format:"ia8",name:"Magic Meter Middle"},
			0x3AC0:{size:[8,8],format:"ia8",name:"Magic Meter Fill"},
			//0x2940:{size:[16,((0x3B00-0x2940)/16)],format:"ia8",name:"Unknown"},
			//0x0200:{size:[16,((0x3B00-0x0200)/16)],format:"ia8",name:"parameter_static"},
		}
	},
	/*
	"":{
		type:pointer,
		address:,
		textures:{
		}
	},
	*/
};

var backgroundTiles = [
	"Equipment 0,0",
	"Equipment 2,0",
	"Map 0,0",
	"Map 2,0",
	"UNUSED Quest Status 0,0",
	"UNUSED Quest Status 2,0",
	"Save 0,0",
	"Save 2,0",
	"Equipment 0,1",
	"Equipment 1,1",
	"Equipment 2,1",
	"Select Item 0,1",
	"Select Item 1,1",
	"Select Item 2,1",
	"Map 0,1",
	"Map 1,1",
	"Map 2,1",
	"Quest Status 0,1",
	"Quest Status 1,1",
	"Quest Status 2,1",
	"Save 0,1",
	"Save 1,1",
	"Save 2,1",
	"Equipment 0,2",
	"Equipment 1,2",
	"Equipment 2,2",
	"Select Item 0,2",
	"Select Item 1,2",
	"Select Item 2,2",
	"Map 0,2",
	"Map 1,2",
	"Map 2,2",
	"Quest Status 0,2",
	"Quest Status 1,2",
	"Quest Status 2,2",
	"Save 0,2",
	"Save 1,2",
	"Save 2,2",
	"Equipment 0,3",
	"Equipment 1,3",
	"Equipment 2,3",
	"Select Item 0,3",
	"Select Item 1,3",
	"Select Item 2,3",
	"Map 0,3",
	"Map 1,3",
	"Map 2,3",
	"Quest Status 0,3",
	"Quest Status 1,3",
	"Quest Status 2,3",
	"Save 0,3",
	"Save 1,3",
	"Save 2,3",
	"Equipment 0,4",
	"Equipment 1,4",
	"Equipment 2,4",
	"Select Item 0,4",
	"Select Item 1,4",
	"Select Item 2,4",
	"Map 0,4",
	"Map 1,4",
	"Map 2,4",
	"Quest Status 0,4",
	"Quest Status 1,4",
	"Quest Status 2,4",
	"Save 0,4",
	"Save 1,4",
	"Save 2,4",
];

var backgroundTilesLoc = [
	"Equipment 1,0",
	"Select Item 0,0",
	"Select Item 1,0",
	"Select Item 2,0",
	"Map 1,0",
	"Quest Status 0,0",
	"Quest Status 1,0",
	"Quest Status 2,0",
	"Save 1,0",
];

var itemNames = [
	"Deku Stick",
	"Deku Nut",
	"Bomb",
	"Fairy Bow",
	"Fire Arrow",
	"Din's Fire",
	"Fairy Slingshot",
	"Fairy Ocarina",
	"Ocarina of Time",
	"Bombchu",
	"Hookshot",
	"Longshot",
	"Ice Arrow",
	"Farore's Wind",
	"Boomerang",
	"Lens of Truth",
	"Magic Beans",
	"Megaton Hammer",
	"Light Arrow",
	"Nayru's Love",
	"Empty Bottle",
	"Red Potion",
	"Green Potion",
	"Blue Potion",
	"Bottled Fairy",
	"Fish",
	"Milk (full)",
	"Ruto's Letter",
	"Blue Fire",
	"Bug",
	"Big Poe",
	"Milk (half)",
	"Poe",
	"Weird Egg",
	"Cucco",
	"Zelda's Letter",
	"Keaton Mask",
	"Skull Mask",
	"Spooky Mask",
	"Bunny Hood",
	"Goron Mask",
	"Zora Mask",
	"Gerudo Mask",
	"Mask of Truth",
	"SOLD OUT",
	"Pocket Egg",
	"Pocket Cucco",
	"Cojiro",
	"Odd Mushroom",
	"Odd Potion",
	"Poacher's Saw",
	"Goron's Sword (broken)",
	"Prescription",
	"Eye Ball Frog",
	"Eye Drops",
	"Claim Check",
	"Fairy Bow + Fire Arrow",
	"Fairy Bow + Ice Arrow",
	"Fairy Bow + Light Arrow",
	"Kokiri Sword",
	"Master Sword",
	"Biggoron Sword",
	"Deku Shield",
	"Hylian Shield",
	"Mirror Shield",
	"Kokiri Tunic",
	"Goron Tunic",
	"Zora Tunic",
	"Kokiri Boots",
	"Iron Boots",
	"Hover Boots",
	"Bullet Bag (30)",
	"Bullet Bag (40)",
	"Bullet Bag (50)",
	"Quiver (30)",
	"Quiver (40)",
	"Quiver (50)",
	"Bomb Bag (20)",
	"Bomb Bag (30)",
	"Bomb Bag (40)",
	"Goron's Bracelet",
	"Silver Gauntlets",
	"Golden Gauntlets",
	"Silver Scale",
	"Golden Scale",
	"Giant's Knife (broken)",
	"Adult's Wallet",
	"Giant's Wallet",
	"Deku Seeds",
	"Fishing Pole",
	"Minuet of Forest",
	"Bolero of Fire",
	"Serenade of Water",
	"Requiem of Spirit",
	"Nocturne of Shadow",
	"Prelude of Light",
	"Zelda's Lullaby",
	"Epona's Song",
	"Saria's Song",
	"Sun's Song",
	"Song of Time",
	"Song of Storms",
	"Forest Medallion",
	"Fire Medallion",
	"Water Medallion",
	"Spirit Medallion",
	"Shadow Medallion",
	"Light Medallion",
	"Kokiri Emerald",
	"Goron's Ruby",
	"Zora's Sapphire",
	"Stone of Agony",
	"Gerudo's Card",
	"Gold Skulltula",
	"Piece of Heart",
	"JAP TEXT: Dungeon Boss's Key (?)",
	"Boss Key",
	"Compass",
	"Dungeon Map",
	"JAP TEXT: Dungeon Boss's Key",
	"JAP TEXT: Dungeon Boss's Key",
	"JAP TEXT: Dungeon Boss's Key",
	"Biggoron's Sword"
];
var doActionNames = [
	"Attack",
	"Check",
	"Enter",
	"Return",
	"Open",
	"Jump",
	"Decide",
	"Dive",
	"Faster",
	"Throw",
	"Navi (Unused)",
	"Climb",
	"Drop",
	"Down",
	"Save",
	"Speak",
	"Next",
	"Grab",
	"Stop",
	"PutAway",
	"Reel",
	"1",
	"2",
	"3",
	"4",
	"5",
	"6",
	"7",
	"8",
]

var worldMapNames = [
	"Haunted Wasteland",
	"Gerudo's Fortress",
	"Gerudo Valley",
	"Hylia Lakeside",
	"Lon Lon Ranch",
	"Market",
	"Hyrule Field",
	"Death Mountain",
	"Kakariko Village",
	"Lost Woods",
	"Kokiri Forest",
	"Zora's Domain",
];

var overworldSceneNames = [
	"Hyrule Field",
	"Kakariko Village",
	"Graveyard",
	"Zora's River",
	"Kokiri Forest",
	"Sacred Forest Meadow",
	"Lake Hylia",
	"Zora's Domain",
	"Zora's Fountain",
	"Gerudo Valley",
	"Lost Woods",
	"Desert Colossus",
	"Gerudo's Fortress",
	"Haunted Wasteland",
	"Market",
	"Hyrule Castle",
	"Death Mountain Trail",
	"Death Mountain Crater",
	"Goron City",
	"Lon Lon Ranch",
	"Question Mark",
	"Ganon's Castle",
]

for (var i=0;i<90;i++) {
	generators["oot_debug_gen"]["icon_item_static"].textures[0x1000*i] = {size:[32,32],format:"rgba32",name:itemNames[i]};
}
for (var i=0;i<backgroundTiles.length;i++) {
	generators["oot_debug_gen"]["icon_item_static"].textures[0x5C3C0+0xA00*i] = {size:[80,32],format:"ia8",name:backgroundTiles[i]};
}

for (var i=0;i<backgroundTilesLoc.length;i++) {
	generators["oot_debug_gen"]["icon_item_nes_static"].textures[0x8280+0xA00*i] = {size:[80,32],format:"ia8",name:backgroundTilesLoc[i]};
}

for (var i=0;i<140;i++) {
	generators["oot_debug_gen"]["nes_font_static"].textures[128*i] = {size:[16,16],format:"i4",name:"Character "+i};
}

for (var i=0;i<9;i++) {
	generators["oot_debug_gen"]["object_mag"].textures[0x20000+0x800*i] = {size:[64,64],format:"i4",name:"Logo Mask "+i};
}

for (var i=0;i<87;i++) {
	generators["oot_debug_gen"]["do_action_static"].textures[0x180*i] = {size:[48,16],format:"ia4",name:doActionNames[i%29]+" Action"};
}

for (var i=0;i<369;i++) {
	generators["oot_debug_gen"]["item_name_static"].textures[0x400*i] = {size:[128,16],format:"ia4",name:itemNames[i%123]+" Name"};
}

for (var i=0;i<36;i++) {
	generators["oot_debug_gen"]["map_name_static"].textures[0x400*i] = {size:[128,16],format:"ia4",name:worldMapNames[i%12]+" World Map Name"};
}

for (var i=0;i<66;i++) {
	generators["oot_debug_gen"]["map_name_static"].textures[0x9000+0xA00*i] = {size:[80,32],format:"ia8",name:overworldSceneNames[i%22]+" Title Card"};
}

delete backgroundTiles;
delete backgroundTilesLoc;
delete itemNames;
delete doActionNames;
delete worldMapNames;
delete overworldSceneNames;