version = "2.3";
loading = false;

function parseHex(str,padding) {
	var padding = padding||8;
	return "0x"+pad(parseInt(str).toString(16).toUpperCase(),8);
}

function pad(n, width, z) {
  z = z || '0';
  n = n + '';
  return n.length >= width ? n : new Array(width - n.length + 1).join(z) + n;
}

loadingBar = {
	running: false,
	total: 0,
	current: 0
};

function updateLoadingBar() {
	var percentage = (loadingBar.current/Math.max(loadingBar.total,1))*100;
	$("#combineBar > .bar").css("width",percentage.toFixed(0)+"%");
	$("#combineBar > .barAmount").text(loadingBar.current+"/"+loadingBar.total);
	$("#combineBar > .barPercentage").text(percentage.toFixed(0)+"%");
	if (percentage >= 100) {
		$("#combineBar > .barText").text("Done");
		loadingBar.running = false;
	} else {
		$("#combineBar > .barText").text("Importing "+loadingBar.file);
	}
}

function setLoadingBar(current,total,file,hide) {
	loadingBar.total = total;
	loadingBar.current = current;
	loadingBar.file = file;
	if (!loadingBar.running && !hide) {
		$('#combineBar').slideDown(100);
		loadingBar.running = true;
	}
	updateLoadingBar();
}

function popup(message,time,type) {
	$(".popup > p").text(message);
	$(".popup").attr("class","popup "+type).slideDown(250,function(){
		setTimeout(function(){
			$(".popup").slideUp(250);
		},time);
	});
}

function toggleChangelog(forward) {
	var changelog = $("#changelog");
	var logs = changelog.children("div");
	var currentLog = logs.filter(":visible");
	if (forward && currentLog[0] != logs.first()[0]) {
		currentLog.hide().prev("div").show();
	} else if (!forward && currentLog[0] != logs.last()[0]) {
		currentLog.hide().next("div").show();
	}
}
		
function getExtension(name) {
	return name.split('.').pop().toLowerCase();
}
		
function timestamp() {
	var time = new Date();
	var stamp = "";
	stamp += time.getFullYear();
	stamp += pad(time.getMonth()+1,2);
	stamp += pad(time.getDate(),2);
	stamp += pad(time.getHours(),2);
	stamp += pad(time.getMinutes(),2);
	stamp += pad(time.getSeconds(),2);
	return stamp;
}
	
$(document).ready(function(){

	$("#menuButtons > a").click(function(){
		$("#centerPanel").show();
		$("#centerPanel > :eq("+$(this).index()+")").slideToggle(250).siblings().slideUp(250);
	});
	
	offline = (window.location.protocol=="file:"?true:false);

	$files = {
		"loaded":{}
	};

	var ignoreDrag = function(e) {
		var event = typeof e.originalEvent != 'undefined' ? e.originalEvent : e;
		if (event.stopPropagation) {
			event.stopPropagation();
		}
		if (event.preventDefault) {
			event.preventDefault();
		}
	};
	$('html').bind('dragover', ignoreDrag).bind('dragenter', ignoreDrag).bind('drop', function(e){
		e = (e&&e.originalEvent?e.originalEvent:window.event) || e;
		ignoreDrag(e);
		// And that for the fix to work we accept `e.files`
		var files = (e.files||e.dataTransfer.files);
		if (files.length == 1 && !loading) { //GENERATE TEXTURE PACK
			loading = true;
			$.each(files, function(i, f){
				var extension = getExtension(f.name);
				if (!(extension=="z64"||extension=="n64"||extension=="v64")){
					popup("The provided file is not a N64 ROM. Make sure that the extension is z64, n64 or v64.",5000,"error");
					loading = false;
					return false;
				}
				var reader = new FileReader();
				reader.onload = (function(theFile) {
					return function(e) {
						loadFile(e.target.result);
					}
				})(f);
				var blob = f;
				reader.readAsArrayBuffer(blob);
			});
		} else if (files.length == 2 && !loading) { //IMPORT TEXTURE PACK
			loading = true;
			function combine() {
				$ROM = new DataView(loadedFiles.z64);
				loadTexturesFromTableData();
			
				var zip = new JSZip();
				var pack = zip.load(loadedFiles.zip);
				var files = pack.folder("pack").file(/^([AP]_[0-9A-F]{1,8}_[^\/]*)\/([0-9A-F]{1,8}_[^\/]*)\.(png|jpg|jpeg|bmp|dib)$/i);
				if ($.isEmptyObject(files)) {
					popup("Could not locate any textures in the pack. Make sure that it is set up properly.",5000,"error");
					loading = false;
					delete $ROM;
					return false;
				}
				//console.log(files);
				function waitForFile(index) {
					index = parseInt(index);
					//console.log(files[index]);
					var result = files[index].name.match(/^pack\/([^\/]*)\/([^\/]*).(png|jpg|jpeg|bmp|dib)$/i);
					var folderName = result[1];
					var folderParams = folderName.split("_");
					if (folderParams[0] == "A") {
						if (folderParams[1] < $ROM.byteLength) { //Make sure that the folder offset is within bounds
							var fileOffset = parseInt(folderParams[1],16);
						} else {
							console.error("Folder pack/"+folderName+"/ address is outside the bounds of the ROM. Skip.");
							var fileOffset = false;
						}
					} else if (folderParams[0] == "P") {
						var pointer = parseInt(folderParams[1],16);
						try { //Make sure that the pointer is within bounds
							var fileOffset = $ROM.getUint32(pointer);
						} catch (error) {
							console.error("Folder pack/"+folderName+"/ pointer is outside the bounds of the ROM. Skip.");
							var fileOffset = false;
						}
					}
					if (fileOffset) {
						var fileName = result[2];
						var fileExtension = result[3];
						var fileParams = fileName.split("_");
						var textureOffset = parseInt(fileParams[0],16);
						var textureFormat = fileParams[1];
						var texture = "data:image/png;base64,"+base64ArrayBuffer(files[index].asArrayBuffer());
						var textureData = imgToX(texture,textureFormat);
						if (typeof textureData !== 'boolean') {	//If the texture was properly converted
							if (fileOffset+textureOffset+textureData.byteLength < $ROM.byteLength) {
								for (var i = 0;i < textureData.byteLength;i++) {
									$ROM.setUint8(fileOffset+textureOffset+i, textureData.getUint8(i));
								}
								console.log("File "+result[0]+" has been imported.");
							} else {
								console.error("File "+result[0]+" offset is outside the bounds of the ROM (0x"+pad((fileOffset+textureOffset).toString(16).toUpperCase(),8)+" to 0x"+pad((fileOffset+textureOffset+textureData.byteLength).toString(16).toUpperCase(),8)+"). Skip.");
							}
						} else if (textureData == false) { //If the texture hasn't loaded yet
							console.warn("File "+result[0]+" has not been loaded yet. Retry.");
							index -= 1;
						} else { //If the texture format wasn't recognized
							console.error("File "+result[0]+" has an unrecognized format. Skip.");
						}
					}
					setLoadingBar(index+1,files.length,folderName+"/"+fileName+"."+fileExtension);
					if (files.length == index+1) {
						setTimeout(function(){
							var blob = new Blob([$ROM.buffer]);
							saveAs(blob, "combined_"+timestamp()+".Z64");
							delete $ROM;
							delete loadedFiles;
							loading = false;
							$('#combineBar').slideUp(1000, function(){
								setLoadingBar(0,1,"",true);
							});
						},200);
					} else {
						setTimeout(waitForFile, 10, [(index+1)]);//wait 50 millisecnds then recheck
					}
				}
				waitForFile(0);
			}
			
			loadedFiles = {};
			
			$.each(files, function(i,file) {
				var extension = getExtension(file.name);
				if (!(extension=="z64"||extension=="n64"||extension=="v64"||extension=="zip")) {
					popup("At least one of the provided files was not a ROM or Texture Pack.",5000,"error");
					loading = false;
					return;
				}
				var reader = new FileReader();
				reader.onload = (function(theFile) {
					return function(e) {
						var extension = getExtension(file.name);
						if (extension=="z64"||extension=="n64"||extension=="v64") {
							if (loadedFiles.z64) {
								popup("You provided 2 ROM files. You must provide either a ROM, or a ROM and a Texture Pack.",5000,"error");
								loading = false;
							} else {
								loadedFiles.z64 = e.target.result;
							}
						} else if (extension=="zip") {
							if (loadedFiles.zip) {
								popup("You provided 2 Texture Packs. You must provide a ROM and a Texture Pack.",5000,"error");
								loading = false;
							} else {
								loadedFiles.zip = e.target.result;
							}
						}
					}
				})(file);
				var blob = file;
				reader.readAsArrayBuffer(blob);
			});
			
			function updateTimeout() {
				//Stop loop
				if (!loading) return false;
				//Check if stuff has loaded
				if (loadedFiles.z64 && loadedFiles.zip) {
					combine();
					return false;
				}
				//Loop
				setTimeout(updateTimeout, 100);
			}
			updateTimeout();
		}
		return false;
	});

	function loadFile(e, name) {
		var $filebuffer = e;
		//LOAD ROM FILE
		if ($filebuffer) {
			var $filedata = new DataView($filebuffer);
			$ROM = $filedata;
			if ($filebuffer.byteLength < 0x02000000) {
				popup("The size of the provided ROM file was less than 32MB, could not generate a pack.",5000,"error");
				return false;
			}
			var ID = "";
			for (var i = 0; i < 4; i++) {
				ID += String.fromCharCode($filedata.getUint8(0x3B+i));
			}
			var Ver = $filedata.getUint8(0x3F);
			//console.log("ID: "+ID+", Ver: "+Ver);
			generateTextures(ID+Ver);
		}
	};
	function generateTextures(ID) {
		if (generators[generatorEntries[ID]]) {
			$.each(generators[generatorEntries[ID]], function(foldername, data){
				if (data.type == 1) {
					folderOffset = data.address;
				} else if (data.type == 2) {
					folderOffset = $ROM.getUint32(data.address);
				} else {
					return;
				}
				$.each(data.textures, function(fileOffset, file){
					var texture = baseToImg(file.format, {"data":$ROM,"offset":folderOffset+parseInt(fileOffset)}, file.size);
					file.texture = texture;
				});
			});
		}
		downloadPack(ID);
	}
});

function base64ArrayBuffer(arrayBuffer) {
  var base64    = ''
  var encodings = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'
 
  var bytes         = new Uint8Array(arrayBuffer)
  var byteLength    = bytes.byteLength
  var byteRemainder = byteLength % 3
  var mainLength    = byteLength - byteRemainder
 
  var a, b, c, d
  var chunk
 
  // Main loop deals with bytes in chunks of 3
  for (var i = 0; i < mainLength; i = i + 3) {
    // Combine the three bytes into a single integer
    chunk = (bytes[i] << 16) | (bytes[i + 1] << 8) | bytes[i + 2]
 
    // Use bitmasks to extract 6-bit segments from the triplet
    a = (chunk & 16515072) >> 18 // 16515072 = (2^6 - 1) << 18
    b = (chunk & 258048)   >> 12 // 258048   = (2^6 - 1) << 12
    c = (chunk & 4032)     >>  6 // 4032     = (2^6 - 1) << 6
    d = chunk & 63               // 63       = 2^6 - 1
 
    // Convert the raw binary segments to the appropriate ASCII encoding
    base64 += encodings[a] + encodings[b] + encodings[c] + encodings[d]
  }
 
  // Deal with the remaining bytes and padding
  if (byteRemainder == 1) {
    chunk = bytes[mainLength]
 
    a = (chunk & 252) >> 2 // 252 = (2^6 - 1) << 2
 
    // Set the 4 least significant bits to zero
    b = (chunk & 3)   << 4 // 3   = 2^2 - 1
 
    base64 += encodings[a] + encodings[b] + '=='
  } else if (byteRemainder == 2) {
    chunk = (bytes[mainLength] << 8) | bytes[mainLength + 1]
 
    a = (chunk & 64512) >> 10 // 64512 = (2^6 - 1) << 10
    b = (chunk & 1008)  >>  4 // 1008  = (2^6 - 1) << 4
 
    // Set the 2 least significant bits to zero
    c = (chunk & 15)    <<  2 // 15    = 2^4 - 1
 
    base64 += encodings[a] + encodings[b] + encodings[c] + '='
  }
  
  return base64
}

function downloadPack(ID) {
	var zip = new JSZip();
	var helptxt = "\
This texture pack is to be used with CloudMax's N64 Texture Packer version "+version+" or higher.\r\n\
\r\n\
If CloudMax's N64 Texture Packer wasn't provided together with the texture pack, you can access it online at cloudmodding.com/n64/texturepacker.\r\n\
Alternatively you can download it at the-gcn.com or cloudmodding.com/n64/\r\n\
\r\n\
Further instructions on how to use the texture packer is available in the tool.\
";
	var pack = zip.folder("pack");
	if (generators[generatorEntries[ID]]) {
		$.each(generators[generatorEntries[ID]], function(folderName, data){
			if (data.type == 1) {
				var type = "A";
			} else if (data.type == 2) {
				var type = "P";
			} else {
				return;
			}
			var folder = pack.folder(type+"_"+pad(data.address.toString(16).toUpperCase(),8)+"_"+folderName.replace(/\ /g,"_").replace(/\:/g,"-").replace(/\//g,"-").replace(/\*/g,"-").replace(/\?/g,"-"));
			$.each(data.textures, function(textureFile, textureData){
				if (textureData.name) {
					var textureName = "_"+textureData.name.replace(/\ /g,"_").replace(/\:/g,"-").replace(/\//g,"-").replace(/\*/g,"-").replace(/\?/g,"-");
				} else {
					var textureName = "";
				}
				folder.file(pad(parseInt(textureFile).toString(16).toUpperCase(),8)+"_"+textureData.format+textureName+".png", textureData.texture.replace("data:image/png;base64,",""), {base64: true});
			});
		});
	} else {
		pack.folder("A_00000000_default");
	}
	
	zip.file("instructions.txt", helptxt);
	var blob = zip.generate({type:"blob"});
	//console.log(zip);
	saveAs(blob, "texture_pack_"+timestamp()+".zip");
	delete $ROM;
	loading = false;
}

function loadTexturesFromTableData() {

}

/********************************
GAME TO IMAGE
********************************/

function baseToImg(format, file, size) {
	if (file.name) {
		var fileData = $files.loaded[file.name];
		var textureOffset = file.offset;
	} else if (file.data) {
		var fileData = file.data;
		var textureOffset = file.offset||0;
	}
	var canvas = document.createElement('canvas');
	var ctx = canvas.getContext('2d');
	canvas.width = size[0];
	canvas.height = size[1];
	var imgPixels = ctx.getImageData(0, 0, canvas.width, canvas.height);
	if (format == "rgba32") {
		for (var i=0;i<size[0]*size[1]*4;i++) {
			var pixel = fileData.getUint8(textureOffset+i);
			imgPixels.data[i] = pixel;
		}
		//console.log(imgPixels.data);
	} else if (format == "i4") {
		for ( var i=0;i<(size[0]*size[1]);i++) {
			var pixel = fileData.getUint8(textureOffset+Math.floor(i/2));
			if (Math.floor(i/2) == i/2) {
				var color = ((pixel&0xF0)>>4)*0x11;
			} else {
				var color = (pixel&0x0F)*0x11;
			}
			imgPixels.data[i*4+0] = color;
			imgPixels.data[i*4+1] = color;
			imgPixels.data[i*4+2] = color;
			imgPixels.data[i*4+3] = color;
		}
	} else if (format == "i8") {
		for (var i=0;i<size[0]*size[1];i++) {
			var pixel = fileData.getUint8(textureOffset+i);
			imgPixels.data[i*4+0] = pixel;
			imgPixels.data[i*4+1] = pixel;
			imgPixels.data[i*4+2] = pixel;
			imgPixels.data[i*4+3] = pixel;
		}
	} else if (format == "ia4") {
		for (var i=0;i<size[0]*size[1];i++) {
			var pixel = fileData.getUint8(textureOffset+Math.floor(i/2));
			if (Math.floor(i/2) == i/2) {
				var data = ((pixel&0xF0)>>4);
			} else {
				var data = (pixel&0x0F);
			}
			var color = Math.round((data&0x0E)*(255/0xE));
			var alpha = (data&0x01)*0xFF;	
			imgPixels.data[i*4+0] = color;
			imgPixels.data[i*4+1] = color;
			imgPixels.data[i*4+2] = color;
			imgPixels.data[i*4+3] = alpha;
		}
	} else if (format == "ia8") {
		for (var i=0;i<size[0]*size[1];i++) {
			var pixel = fileData.getUint8(textureOffset+i);
			var color = ((pixel&0xF0)>>4)*0x11;
			var alpha = (pixel&0x0F)*0x11;
			imgPixels.data[i*4+0] = color;
			imgPixels.data[i*4+1] = color;
			imgPixels.data[i*4+2] = color;
			imgPixels.data[i*4+3] = alpha;
		}
	} else if (format == "ia16") {
		for (var i=0;i<(size[0]*size[1]);i++) {
			var alpha = fileData.getUint8(textureOffset+i*2+1);
			var color = fileData.getUint8(textureOffset+i*2);
			imgPixels.data[i*4+0] = color;
			imgPixels.data[i*4+1] = color;
			imgPixels.data[i*4+2] = color;
			imgPixels.data[i*4+3] = alpha;
		}
	} else if (format == "rgb5a1") {
		for (var i=0;i<(size[0]*size[1]);i++) {
			var pixel = fileData.getUint16(textureOffset+i*2);
			var red = ((pixel>>11)&0x1F)*0x8;
			var green = ((pixel>>6)&0x1F)*0x8;
			var blue = ((pixel>>1)&0x1F)*0x8;
			imgPixels.data[i*4+0] = red;
			imgPixels.data[i*4+1] = green;
			imgPixels.data[i*4+2] = blue;
			imgPixels.data[i*4+3] = ((pixel&0x01)==0x01?0xFF:0x00);
		}
	}
	ctx.putImageData(imgPixels, 0, 0, 0, 0, imgPixels.width, imgPixels.height);
	return canvas.toDataURL();
}



/********************************
IMAGE TO GAME
********************************/

function imgToX(src,format) {
	if (format == "rgba32") {
		return imgToRGBA32(src);
	} else if (format == "i8") {
		return imgToI8(src);
	} else if (format == "i4") {
		return imgToI4(src);
	} else if (format == "ia4") {
		return imgToIA4(src);
	} else if (format == "ia8") {
		return imgToIA8(src);
	} else if (format == "ia16") {
		return imgToIA16(src);
	} else if (format == "rgb5a1") {
		return imgToRGB5A1(src);
	} else { //If format doesn't exist, return true. It will return false if the image it is trying to convert isn't loaded yet.
		return true;
	}
}

function imgToBase(src) {
	var canvas = document.createElement('canvas');
	var ctx = canvas.getContext('2d');
	var imgObj = new Image();
	imgObj.src = src;
	if (!imgObj.width || !imgObj.height) {
		return false;
	}
	canvas.width = imgObj.width;
	canvas.height = imgObj.height; 
	ctx.drawImage(imgObj, 0, 0); 
	var imgPixels = ctx.getImageData(0, 0, canvas.width, canvas.height);
	//console.log(imgPixels);
	return imgPixels;
}

function imgToRGBA32(src){
	var imgPixels = imgToBase(src);
	if (imgPixels == false) {
		return false;
	}
	
	var imgBuffer = new ArrayBuffer(imgPixels.data.length);
	var imgView = new DataView(imgBuffer);
	
	$.each(imgPixels.data, function(i,v) {
		imgView.setUint8(i,v);
	});
	
	return imgView;
}

function imgToI4(src, alpha){
	var imgPixels = imgToBase(src);
	if (imgPixels == false) {
		return false;
	}
	
	var imgBuffer = new ArrayBuffer(imgPixels.data.length/8);
	var imgView = new DataView(imgBuffer);
	
	for ( var i=0; i< imgPixels.data.length; i+=8) {
		var val = ((Math.floor(imgPixels.data[i] / 0x11)<<4)) + (Math.floor(imgPixels.data[i+4] / 0x11)&0x0F);

		imgView.setUint8(i/8,val);
		
	}
	return imgView;
}

function imgToI8(src, alpha){
	var imgPixels = imgToBase(src);
	if (imgPixels == false) {
		return false;
	}
	
	var imgBuffer = new ArrayBuffer(imgPixels.data.length/4);
	var imgView = new DataView(imgBuffer);
	
	for ( var i=0; i< imgPixels.data.length; i+=4) {
		imgView.setUint8(i/4,imgPixels.data[i]);
	}
	return imgView;
}


//Letters and Numbers
//Navi Text
function imgToIA4(src, alpha){
	var imgPixels = imgToBase(src);
	if (imgPixels == false) {
		return false;
	}
	
	var imgBuffer = new ArrayBuffer(imgPixels.data.length/8);
	var imgView = new DataView(imgBuffer);
	
	for ( var i=0; i< imgPixels.data.length; i+=8) {
		//Divide by 2, then round, then multiply by 2. This is done so that it properly locates the closest color.
		var pixelOne = ((Math.round((imgPixels.data[i]/(255/0xE))/2))*2)&0x0E;
		if (imgPixels.data[i+3] == 255) pixelOne += 0x01;
		//Divide by 2, then round, then multiply by 2. This is done so that it properly locates the closest color.
		var pixelTwo = ((Math.round((imgPixels.data[i+4]/(255/0xE))/2))*2)&0x0E;
		if (imgPixels.data[i+4+3] == 255) pixelTwo += 0x01;
		
		var data = (pixelOne<<4)+pixelTwo;
		//console.log(pad(data.toString(16).toUpperCase(),2));
		
		imgView.setUint8(i/8,data);
		
	}
	//console.log(result);
	return imgView;
}

function imgToIA8(src){
	var imgPixels = imgToBase(src);
	if (imgPixels == false) {
		return false;
	}
	
	var imgBuffer = new ArrayBuffer(imgPixels.data.length/4);
	var imgView = new DataView(imgBuffer);

	for ( var i=0; i < imgPixels.data.length; i+=4) {
		var val = (Math.floor(imgPixels.data[i] / 0x11)<<4)+Math.floor(imgPixels.data[i+3] / 0x11);
		imgView.setUint8(i/4,val);
	}
	return imgView;
}

function imgToIA16(src){
	var imgPixels = imgToBase(src);
	if (imgPixels == false) {
		return false;
	}
	
	var imgBuffer = new ArrayBuffer(imgPixels.data.length/2);
	var imgView = new DataView(imgBuffer);
	
	for ( var i=0; i < imgPixels.data.length; i+=4) {
		var alpha = imgPixels.data[i+3];
		var color = imgPixels.data[i];
		imgView.setUint8(i/2,color);
		imgView.setUint8((i/2)+1,alpha);
	}
	return imgView;
}

function imgToRGB5A1(src){
	var imgPixels = imgToBase(src);
	if (imgPixels == false) {
		return false;
	}
	
	var imgBuffer = new ArrayBuffer(imgPixels.data.length/2);
	var imgView = new DataView(imgBuffer);

	for ( var i=0; i < imgPixels.data.length; i+=4) {
		var alpha = Math.floor(imgPixels.data[i+3] / 0xFF);
		var blue = Math.floor(imgPixels.data[i+2] / 0x8) << 1;
		var green = Math.floor(imgPixels.data[i+1] / 0x8) << 6;
		var red = Math.floor(imgPixels.data[i] / 0x8) << 11;
		var color = alpha + red + green + blue;
		imgView.setUint16(i/2,color);
	}
	return imgView;
}

/*
//Generate rgb5a1 color table for photoshop

colorFile = new DataView(new ArrayBuffer((0x8000*3)+4));
var i = 0;
var multiplier = 255/(Math.pow(2,5)-1);
for ( var ri=0; ri<32; ri++) {
	for ( var gi=0; gi<32; gi++) {
		for ( var bi=0; bi<32; bi++) {
			colorFile.setUint8(i, ri*multiplier);
			colorFile.setUint8(i+1, gi*multiplier);
			colorFile.setUint8(i+2, bi*multiplier);
			i += 3;
		}
	}
}
colorFile.setUint16(i, 0x8000);
colorFile.setUint16(i+2, 0xFFFF);
var blob = new Blob([colorFile.buffer]);
saveAs(blob, "colorTable.act");
*/