/********************************
EDITOR PANELS SETUP
********************************/

$home = "\
Welcome to CloudMax's z64editor!<br>\
The editor has undergone yet another major rewrite, and has many new features.<br>\
This version does not support Majora's Mask.<br>\
The editor now load textures directly from the ROM, and because of that the editor now require a few additional files.<br>\
It is now possible to replace textures within the editor in the new Textures tab, instead of just being able to provide menu background placeholders.<br>\
You'll no longer be able save to the browser, this is because the files take up to much space.<br>\
To prevent users from being required to provide the files every time they use the editor a new autoload feature has been added for those who use the editor offline.<br>\
You can read more about the Auto Load feature in the Help tab.<br>\
Various new options has been added to the Pause Menus, such as Heart Container and Cursor colors.<br>\
<span class='warning'>The Improved Inventory ASM Extension has been removed as there was an issue with it.</span>";

$lefttabmenupanel = {
	"element":"div",
	"data":{
		"id":"objectSettings",
		"class":"paneltabs",
		"attr":{
			"tabGroup":"leftpanelmenutabgroup",
			"data-req":"data,loaded"
		}
	},
	"children":[
		{
			"element":"div",
			"data":{
				"class":"panelclose",
				"title":"Close current tab"
			}
		},
		{
			"element":"div",
			"data":{
				"class":"paneltab",
				"text":"Selected Objects"
			}
		},
		{
			"element":"div",
			"data":{
				"class":"paneltab",
				"text":"Selected Cursors",
				"attr":{
					"data-req":"data,game/1"
				}
			}
		},
		{
			"element":"div",
			"data":{
				"class":"paneltab",
				"text":"Panel",
				"attr":{
					"data-req":"settings,menu$enable"
				}
			}
		}
	]
};

$objectpanel = {
	"element":"div",
	"data":{
		"id":"objectSettings",
		"class":"sidetabpanel"
	},
	"children":[
		{
			"element":"div",
			"data":{
				"class":"panelgroup",
				"attr":{
					"name":"Info"
				}
			},
			"children":[
				{
					"element":"span",
					"data":{
						"id":"objectName",
						"class":"grouptext"
					}
				},
				{
					"element":"span",
					"data":{
						"data-req":"currentmenu,selection,object,0",
						"class":"grouptitle",
						"html":"ID"
					}
				},
				{
					"element":"input",
					"data":{
						"data-req":"currentmenu,selection,object,0",
						"type":"number",
						"id":"objectID",
						"attr":{
							"static":""
						}
					}
				}
			]
		},
		{
			"element":"div",
			"data":{
				"class":"panelgroup",
				"attr":{
					"data-req":"currentmenu,object,crntobject,position",
					"name":"Coordinates"
				}
			},
			"children":[
				{
					"element":"span",
					"data":{
						"class":"grouptitle",
						"text":"X Position"
					}
				},
				{
					"element":"input",
					"data":{
						"type":"number",
						"attr":{
							"change":"setobj,object,crntobject,move,x"
						}
					}
				},
				{
					"element":"span",
					"data":{
						"class":"grouptitle",
						"text":"Y Position"
					}
				},
				{
					"element":"input",
					"data":{
						"type":"number",
						"attr":{
							"change":"setobj,object,crntobject,move,y"
						}
					}
				}
			]
		},
		{
			"element":"div",
			"data":{
				"class":"panelgroup",
				"attr":{
					"data-req":"currentmenu,object,crntobject,size",
					"name":"Size"
				}
			},
			"children":[
				{
					"element":"span",
					"data":{
						"class":"grouptitle",
						"text":"Width",
						"attr":{
							"data-req":"data,game/1"
						}
					}
				},
				{
					"element":"input",
					"data":{
						"type":"number",
						"attr":{
							"data-req":"data,game/1",
							"change":"currentmenu,object,crntobject,size,0"
						}
					}
				},
				{
					"element":"span",
					"data":{
						"class":"grouptitle",
						"text":"Height",
						"attr":{
							"data-req":"data,game/1"
						}
					}
				},
				{
					"element":"input",
					"data":{
						"type":"number",
						"attr":{
							"data-req":"data,game/1",
							"change":"currentmenu,object,crntobject,size,1"
						}
					}
				},
				{
					"element":"span",
					"data":{
						"class":"grouptitle",
						"text":"Size",
						"attr":{
							"data-req":"data,game/0"
						}
					}
				},
				{
					"element":"input",
					"data":{
						"type":"number",
						"attr":{
							"data-req":"data,game/0",
							"change":"currentmenu,object,crntobject,size"
						}
					}
				},
				{
					"element":"span",
					"data":{
						"class":"grouptext centered",
						"text":"I do not recommend changing size. The game resize objects differently."
					}
				}
			]
		},
		{
			"element":"div",
			"data":{
				"class":"panelgroup",
				"attr":{
					"data-req":"currentmenu,object,crntobject,direction",
					"name":"Direction IDs"
				}
			},
			"children":[
				{
					"element":"span",
					"data":{
						"class":"grouptitle",
						"text":"Up"
					}
				},
				{
					"element":"input",
					"data":{
						"type":"number",
						"attr":{
							"change":"currentmenu,object,crntobject,direction,0"
						}
					}
				},
				{
					"element":"span",
					"data":{
						"class":"grouptitle",
						"text":"Down"
					}
				},
				{
					"element":"input",
					"data":{
						"type":"number",
						"attr":{
							"change":"currentmenu,object,crntobject,direction,1"
						}
					}
				},
				{
					"element":"span",
					"data":{
						"class":"grouptitle",
						"text":"Left"
					}
				},
				{
					"element":"input",
					"data":{
						"type":"number",
						"attr":{
							"change":"currentmenu,object,crntobject,direction,2"
						}
					}
				},
				{
					"element":"span",
					"data":{
						"class":"grouptitle",
						"text":"Right"
					}
				},
				{
					"element":"input",
					"data":{
						"type":"number",
						"attr":{
							"change":"currentmenu,object,crntobject,direction,3"
						}
					}
				},
				{
					"element":"span",
					"data":{
						"class":"grouptext centered",
						"text":"-1 disables the direction"
					}
				},
				{
					"element":"span",
					"data":{
						"class":"grouptext centered",
						"text":"-2 is the R button (Right)"
					}
				},
				{
					"element":"span",
					"data":{
						"class":"grouptext centered",
						"text":"-3 is the Z button (Left)"
					}
				}
			]
		},
		{
			"element":"div",
			"data":{
				"class":"panelgroup",
				"attr":{
					"name":"Color",
					"data-req":"currentmenu,object,crntobject,color",
					"hidden":""
				}
			},
			"children":[
				{
					"element":"span",
					"data":{
						"class":"grouptitle",
						"text":"Tint Color"
					}
				},
				{
					"element":"input",
					"data":{
						"type":"text",
						"class":"colorpick",
						"attr":{
							"change":"currentmenu,object,crntobject,color",
							"spectrum":"object"
						}
					}
				},
			]
		},
		{
			"element":"div",
			"data":{
				"class":"panelgroup",
				"attr":{
					"name":"Color",
					"data-req":"currentmenu,object,crntobject,fadeColor",
					"hidden":""
				}
			},
			"children":[
				{
					"element":"span",
					"data":{
						"class":"grouptitle",
						"text":"Color Steps"
					}
				},
				{
					"element":"input",
					"data":{
						"type":"text",
						"class":"colorpick",
						"attr":{
							"change":"currentmenu,object,crntobject,fadeColor,3",
							"spectrum":"hp"
						}
					}
				},
				{
					"element":"input",
					"data":{
						"type":"text",
						"class":"colorpick",
						"attr":{
							"change":"currentmenu,object,crntobject,fadeColor,2",
							"spectrum":"hp"
						}
					}
				},
				{
					"element":"input",
					"data":{
						"type":"text",
						"class":"colorpick",
						"attr":{
							"change":"currentmenu,object,crntobject,fadeColor,1",
							"spectrum":"hp"
						}
					}
				},
				{
					"element":"input",
					"data":{
						"type":"text",
						"class":"colorpick",
						"attr":{
							"change":"currentmenu,object,crntobject,fadeColor,0",
							"spectrum":"hp"
						}
					}
				},
			]
		},
		{
			"element":"input",
			"data":{
				"type":"button",
				"attr":{
					"reset":"object",
					"value":"Reset Selected Objects",
					"disabled":""
				}
			}
		},
		{
			"element":"span",
			"data":{
				"class":"grouptext centered",
				"text":"This will reload the selected objects from the file."
			}
		}
	]
}


$cursorpanel = {
	"element":"div",
	"data":{
		"id":"cursorSettings",
		"class":"sidetabpanel"
	},
	"children":[
		{
			"element":"div",
			"data":{
				"class":"panelgroup",
				"attr":{
					"name":"Info"
				}
			},
			"children":[
				{
					"element":"span",
					"data":{
						"id":"cursorName",
						"class":"grouptext"
					}
				},
				{
					"element":"span",
					"data":{
						"data-req":"currentmenu,selection,cursor,0",
						"class":"grouptitle",
						"text":"ID"
					}
				},
				{
					"element":"input",
					"data":{
						"type":"number",
						"id":"cursorID",
						"data-req":"currentmenu,selection,cursor,0",
						"attr":{
							"static":""
						}
					}
				}
			]
		},
		{
			"element":"div",
			"data":{
				"class":"panelgroup",
				"attr":{
					"data-req":"currentmenu,cursor,crntcursor,position",
					"name":"Coordinates"
				}
			},
			"children":[
				{
					"element":"span",
					"data":{
						"class":"grouptitle",
						"text":"X Position"
					}
				},
				{
					"element":"input",
					"data":{
						"type":"number",
						"attr":{
							"change":"setobj,cursor,crntcursor,move,x"
						}
					}
				},
				{
					"element":"span",
					"data":{
						"class":"grouptitle",
						"text":"Y Position"
					}
				},
				{
					"element":"input",
					"data":{
						"type":"number",
						"attr":{
							"change":"setobj,cursor,crntcursor,move,y"
						}
					}
				}
			]
		},
		{
			"element":"div",
			"data":{
				"class":"panelgroup",
				"attr":{
					"data-req":"currentmenu,cursor,crntcursor,direction",
					"name":"Direction IDs"
				}
			},
			"children":[
				{
					"element":"span",
					"data":{
						"class":"grouptitle",
						"text":"Up"
					}
				},
				{
					"element":"input",
					"data":{
						"type":"number",
						"attr":{
							"change":"currentmenu,cursor,crntcursor,direction,0"
						}
					}
				},
				{
					"element":"span",
					"data":{
						"class":"grouptitle",
						"text":"Down"
					}
				},
				{
					"element":"input",
					"data":{
						"type":"number",
						"attr":{
							"change":"currentmenu,cursor,crntcursor,direction,1"
						}
					}
				},
				{
					"element":"span",
					"data":{
						"class":"grouptitle",
						"text":"Left"
					}
				},
				{
					"element":"input",
					"data":{
						"type":"number",
						"attr":{
							"change":"currentmenu,cursor,crntcursor,direction,2"
						}
					}
				},
				{
					"element":"span",
					"data":{
						"class":"grouptitle",
						"text":"Right"
					}
				},
				{
					"element":"input",
					"data":{
						"type":"number",
						"attr":{
							"change":"currentmenu,cursor,crntcursor,direction,3"
						}
					}
				},
				{
					"element":"span",
					"data":{
						"class":"grouptext centered",
						"text":"-1 disables the direction"
					}
				},
				{
					"element":"span",
					"data":{
						"class":"grouptext centered",
						"text":"-2 is the R button (Right)"
					}
				},
				{
					"element":"span",
					"data":{
						"class":"grouptext centered",
						"text":"-3 is the Z button (Left)"
					}
				}
			]
		},
		{
			"element":"input",
			"data":{
				"type":"button",
				"attr":{
					"reset":"cursor",
					"value":"Reset Selected Cursors",
					"disabled":""
				}
			}
		},
		{
			"element":"span",
			"data":{
				"class":"grouptext centered",
				"text":"This will reload the selected cursor from the current .zdata file."
			}
		}
	]
}


$menupanel = {
	"element":"div",
	"data":{
		"id":"panelSettings",
		"class":"sidetabpanel"
	},
	"children":[
		{
			"element":"div",
			"data":{
				"class":"panelgroup",
				"attr":{
					"data-req":"data,game/1",
					"name":"Background Color"
				}
			},
			"children":[
				{
					"element":"span",
					"data":{
						"class":"grouptitle",
						"text":"Color"
					}
				},
				{
					"element":"input",
					"data":{
						"type":"text",
						"attr":{
							"class":"colorpick",
							"change":"currentmenu,data,backgroundcolor",
							"spectrum":"bg"
						}
					}
				}
			]
		},
		{
			"element":"div",
			"data":{
				"class":"panelgroup",
				"attr":{
					"data-req":"data,game/0",
					"name":"Background Gradient"
				}
			},
			"children":[
				{
					"element":"span",
					"data":{
						"class":"grouptitle",
						"text":"Color 1"
					}
				},
				{
					"element":"input",
					"data":{
						"type":"text",
						"attr":{
							"class":"colorpick",
							"change":"currentmenu,data,backgroundcolor,0",
							"spectrum":"bg"
						}
					}
				},
				{
					"element":"span",
					"data":{
						"class":"grouptitle",
						"text":"Color 2"
					}
				},
				{
					"element":"input",
					"data":{
						"type":"text",
						"attr":{
							"class":"colorpick",
							"change":"currentmenu,data,backgroundcolor,1",
							"spectrum":"bg"
						}
					}
				},
				{
					"element":"span",
					"data":{
						"class":"grouptitle",
						"text":"Color 3"
					}
				},
				{
					"element":"input",
					"data":{
						"type":"text",
						"attr":{
							"class":"colorpick",
							"change":"currentmenu,data,backgroundcolor,2",
							"spectrum":"bg"
						}
					}
				},
				{
					"element":"span",
					"data":{
						"class":"grouptitle",
						"text":"Color 4"
					}
				},
				{
					"element":"input",
					"data":{
						"type":"text",
						"attr":{
							"class":"colorpick",
							"change":"currentmenu,data,backgroundcolor,3",
							"spectrum":"bg"
						}
					}
				}
			]
		},
		{
			"element":"div",
			"data":{
				"class":"panelgroup",
				"attr":{
					"data-req":"currentmenu,data,zdirection",
					"name":"Z and R Buttons"
				}
			},
			"children":[
				{
					"element":"span",
					"data":{
						"class":"grouptitle",
						"text":"Z Direction ID"
					}
				},
				{
					"element":"input",
					"data":{
						"type":"number",
						"attr":{
							"change":"currentmenu,data,zdirection"
						}
					}
				},
				{
					"element":"span",
					"data":{
						"class":"grouptitle",
						"text":"R Direction ID"
					}
				},
				{
					"element":"input",
					"data":{
						"type":"number",
						"attr":{
							"change":"currentmenu,data,rdirection"
						}
					}
				}
			]
		},
		{
			"element":"div",
			"data":{
				"class":"panelgroup",
				"attr":{
					"data-req":"currentmenu,data,noteColor",
					"name":"Ocarina Note Colors"
				}
			},
			"children":[
				{
					"element":"span",
					"data":{
						"class":"grouptitle",
						"text":"A Button Notes"
					}
				},
				{
					"element":"input",
					"data":{
						"type":"text",
						"class":"colorpick",
						"attr":{
							"change":"currentmenu,data,noteColor,0",
							"spectrum":"note"
						}
					}
				},
				{
					"element":"span",
					"data":{
						"class":"grouptitle",
						"text":"C Button Notes"
					}
				},
				{
					"element":"input",
					"data":{
						"type":"text",
						"class":"colorpick",
						"attr":{
							"change":"currentmenu,data,noteColor,1",
							"spectrum":"note"
						}
					}
				},
				{
					"element":"span",
					"data":{
						"class":"grouptitle",
						"text":"Replay notes"
					}
				},
				{
					"element":"input",
					"data":{
						"type":"text",
						"class":"colorpick",
						"attr":{
							"change":"currentmenu,data,noteColor,2",
							"spectrum":"note"
						}
					}
				}
			]
		},
		{
			"element":"input",
			"data":{
				"type":"button",
				"attr":{
					"reset":"panel",
					"value":"Reset Panel",
					"disabled":""
				}
			}
		},
		{
			"element":"span",
			"data":{
				"class":"grouptext centered",
				"text":"This will reload the current panel from the loaded file."
			}
		}
	]
}

$(document).ready(function(){
	//Set updateCalls
	updateCalls = function() {
		update();
	}
	//Open Home Tab
	$("[tabGroup=bottompaneltabgroup] > .paneltab:first").trigger({type: 'click',which: 1});
	//Refresh
	refreshEditorObject();
	//Setup Editor Panels
	$(".leftpanel").append("<div id='leftpanelmenu'/>");
	$("#leftpanelmenu").append(createElements($lefttabmenupanel));
	$("#leftpanelmenu").append('<div id="leftpanelmenutabgroup" class="tabgroup"/>');
	$("#leftpanelmenutabgroup").append(createElements($objectpanel));
	$("#leftpanelmenutabgroup").append(createElements($cursorpanel));
	$("#leftpanelmenutabgroup").append(createElements($menupanel));
	$("#home").html($home);
	//
	spectrumDefault = {
		className: "right",
		preferredFormat: "rgb",
		showInitial: true,
		showInput: true,
		showButtons: false,
		showPalette: true,
		showSelectionPalette: false,
		clickoutFiresChange: true,
		show: function(color) {
			$(this).addClass('active');
		},
		hide: function(color) {
			$(this).removeClass('active');
		}
	}
	//Set up Spectrums
	spectrums = {
		"object":new $.extend({}, spectrumDefault, {
			palette: [
				["#96FF64"],
				["#FF5028"],
				["#6496FF"],
				["#FFA000"],
				["#FF64FF"],
				["#FFF064"],
				["#FFFFFF"]
			]
		}),
		"note":new $.extend({}, spectrumDefault, {
			palette: [
				["rgba(80, 255, 150, 0.78)"],
				["rgba(255, 255, 50, 0.78)"],
				["rgba(150, 150, 150, 0.59)"]
			],
			showAlpha: true
		}),
		"hp":new $.extend({}, spectrumDefault, {
			palette: [
				["rgba(255, 0, 0, 1)"],
				["rgba(255, 70, 0, 0.59)"]
			],
			showAlpha: true
		}),
		"bg":new $.extend({}, spectrumDefault, {
			palette: [
				["rgb(10, 50, 40)","rgb(90, 100, 60)"],
				["rgb(10, 50, 80)","rgb(70, 100, 130)"],
				["rgb(80, 40, 30)","rgb(140, 60, 60)"],
				["rgb(80, 80, 50)","rgb(120, 120, 70)"],
				["rgb(50, 50, 50)","rgb(110, 110, 110)"],
				["#B4B478","#FFFFFF"]
			]
		}),
		"cursor":new $.extend({}, spectrumDefault, {
			palette: [
				["rgb(255, 255, 255)"],
				["rgb(0, 0, 0)"],
				["rgb(255, 255, 0)"],
				["rgb(0, 255, 50)"]
			]
		})
	};
	//Initialize Addons
	//fileselectInit();
	//Set Version Number
	$(".toolbar").append("<span class='version'>Version "+$version.text+"</span>");
	//Wrap all urls
	var content = $(".editor").html(),
		 urlrgx = /([^'"])((?:http|ftp|https):\/\/[\w\-_]+(?:\.[\w\-_]+)+(?:[\w\-\.,@?^=%&:/~\+#]*[\w\-\@?^=%&/~\+#])?)/gi;
	$(".editor").html(content.replace(urlrgx, '$1<a href="$2" target="_blank">$2</a>'));
	//Apply Spectrums
	$(".colorpick").each(function() {
		$(this).spectrum(spectrums[$(this).attr("spectrum")]);
	});
	//Apply heapbox
	$("select").heapbox({
		'effect': {
			'type': 'fade',
			'speed': 0
		}
	});
	/*
	$.each($("select[change]"), function () {
		$(this).prev().attr("change", $(this).attr("change"));
	});
	*/
	//Generate required files list
	$.each($requiredfiles,function(i,v){
		$("#loadMsg").append("<p id='load_"+v+"' class='fileLoad'>"+v+"</p>");
	});

	//Initialize Filedrop
	var ignoreDrag = function(e) {
		var event = typeof e.originalEvent != 'undefined' ? e.originalEvent : e;
		if (event.stopPropagation) {
			event.stopPropagation();
		}
		if (event.preventDefault) {
			event.preventDefault();
		}
	};
	$('.providefile,.workspace,.workspacedrop').bind('dragover', ignoreDrag).bind('dragenter', ignoreDrag).bind('drop', function(e){
		e = (e&&e.originalEvent?e.originalEvent:window.event) || e;
		ignoreDrag(e);
		// And that for the fix to work we accept `e.files`
		var files = (e.files||e.dataTransfer.files);
		$.each(files, function(i, f){
			var reader = new FileReader();
			reader.onload = (function(theFile) {
				return function(e) {
					var filename = theFile.name.replace(/\..*/,"");
					console.log(filename);
					if ($.inArray(filename, $requiredfiles) > -1) {
						loadFile(e.target.result,filename);
					} else {
						loadFile(e.target.result);
					}
				}
			})(f);
			var blob = f;
			reader.readAsArrayBuffer(blob);
		});
		return false;
	});
	//Initialize Texture Filedrop
	$('.texturegroup:gt(0)').bind('dragover', ignoreDrag).bind('dragenter', ignoreDrag).bind('drop', function(e){
		e = (e&&e.originalEvent?e.originalEvent:window.event) || e;
		ignoreDrag(e);
		// And that for the fix to work we accept `e.files`
		var backgroundid = $(this).index('.texturegroup:gt(0)');
		var files = (e.files||e.dataTransfer.files);
		$.each(files, function(i, f){
			var reader = new FileReader();
			reader.onload = (function(theFile) {
				return function(e) {
					var img = e.target.result || e.srcElement.result;
					$editor.settings.backgroundpaths[backgroundid] = img;
				};
			})(f);
			var blob = f;
			reader.readAsDataURL(blob);
		});
		return false;
	});

	$(".editor").show();

	if (typeof $autoload !== 'undefined') {
		$.each($autoload, function(key, val){
			if (key == "data") return true;
			str = window.atob(val);
			var buf = new ArrayBuffer(str.length); // 2 bytes for each char
			var bufView = new DataView(buf);
			for (var i=0; i<str.length; i++) {
				bufView.setUint8(i, str.charCodeAt(i));
			}
			//console.log(buf);
			loadFile(buf, key);
			//return buf;
		});
	}

	init();

	function init() {
		//Create Background Tiles
		for (var x=0;x<3;x++) {
			for (var y=0;y<5;y++) {
				$('<div/>', {
					"class": 'bgTile',
					"xy": x.toString()+y.toString(),
					"css": {
						"left":80*x+"px",
						"top":32*y+"px"
					}
				}).appendTo('.pausescreen');
			}
		}
		//Create Global Menu Objects
		/*
		$('<div/>', {
			"class": 'menuTitle',
			"css": {
				"left":80+"px",
				"top":32+"px"
			}
		}).appendTo('.pausescreen');
		*/
		var filterStrength = 10;
		var frameTime = 0, lastLoop = new Date, thisLoop;
		//Initialize Global Update
		function updateTimeout() {
			updateCalls();
			var thisFrameTime = (thisLoop=new Date) - lastLoop;
			frameTime+= (thisFrameTime - frameTime) / filterStrength;
			lastLoop = thisLoop;
			$editor.data.fps = frameTime;
			//Loop
			setTimeout(updateTimeout, 0);
		}
		updateTimeout();
		setInterval(function(){
			  $("#fps").html("FPS: "+(1000/$editor.data.fps).toFixed(1));
		},100);
		if ($editor.menufile) {
			loadTableData();
		}
	}
});