
/********************************
TEXTURES
********************************/

$imageresources = {
	//,"unavailable":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAMAAABEpIrGAAAAh1BMVEX///8AAADu7u6qqqqIiIh3d3cRERFVVVUAAAAiIiLd3d0zMzPu7u4AAAC7u7tmZmYAAABmZmbu7u5EREQAAAB3d3eZmZlmZmaIiIj///8RERERERGIiIgAAAAREREiIiLMzMz///9EREQzMzN3d3dmZmaZmZmqqqq7u7uIiIhVVVXd3d3u7u47AK/MAAAAHXRSTlMAABFVd4juqu7dIswAzEQiu6oiZneZZpmIEXdmItJkPNEAAAE+SURBVHheldPnkoMgFAVgArb0bK/nUqwl7/9864oIo5nN7PnlwAeD9wLb3AnbsD8TAi7SPQDsU8FvAB4DIJKSCEDEl0AkoLzq9ZC+zQnb0wzc8k7pOY0BohDEoNbOFEUzkmIQHgiQHdYAyH5VyE4O7Lao9BLoAls+gRd0egoBcgJXg1cLHkHKgRweN5TwETzBaBcDlNpr8Qv4BdUMCqCdQYt0BJnsgzHUM+hpPwLkQYUArzVhBRTo6oFcAw3S/weZDHft9OqQR6o9MA743zw8IxhslF4Wip1BvhDKA+VKzR5QBpUsfNkj1+7kVrtb324WzRcmh+tcTRD+yqUgu4cqS2XXE+Lw0r4B04x1Hey8A4xHgOzqsWJ9ZQiJWD6c3QNAMh8iAbzv1k/v4/x5zAAgu3x933yb7MCnHFgI7uQHNftPdNHxcM4AAAAASUVORK5CYII="
	"letters":{
		45:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAKElEQVQ4y2NgGAXDBQiiAZI1nwGCu1AAYrsAAUmGGKMBkl0xCgYYAABKJxMhfN8JpgAAAABJRU5ErkJggg=="
		,46:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAJklEQVQ4y2NgGAWjgFpAEAiUgIBsA3YDwTsgMAaCgTGAYi8MbQAAayIQeVpV7kcAAAAASUVORK5CYII="
		,47:""
		,48:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAmElEQVQ4y92SSw2AMBBEawELWMACFmoBC1jAAhZqAQtYwAIWYF7STRoO/RBOvAubSTu7O8W5L5nEGvGi6XIQl5jFIqj5VnfmAp1N2wTaIKq7p2MzSdUUnTjEsxtmaExSNDgj1KZjhsEuUj1r0AvTR2EGxQw49HoFIH0O8xrNIab7WjcLlrWqntFG5lKIUDf/jYToI9nk/8UNCNWr3YFN17EAAAAASUVORK5CYII="
		,49:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAPklEQVQ4y2NgoBZQAoI0IADRJGvuAIJ3QPAfCEKBgCzbVwEByAAXICDLCzOBYNSAIW8ALDGRbYAgFDCMPAAA/FZRjQp7dlQAAAAASUVORK5CYII="
		,50:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAh0lEQVQ4y93SSw2AMBBF0VqoBSxgAQtYwAIWagEtWMACFmoB3k3aZFbQTlhxdizm10cIXxlkla2Ypbl4lF2SLHLIJXw3NWCyncg2NMgSpfscinLhajAJG3CK60HrG9Cou5gEKO5KwRZzt2sykbE6kbqKWZt/gUiT8dqQmE6psV1G8znxQfi/G/SVgikgtEGXAAAAAElFTkSuQmCC"
		,51:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAkUlEQVQ4y9WSQRGAMAwEawELWMACFrCABSxgAQtYwAIWsIAF2J2hM/wgHT7sL49sc0lT+ooaBphghh5CzTaNYOMCB1i/FjRwrxVsUEE4TgcKnKpoDzsYwzokMPMKWeAkRRdxH+Y3RrHEKAo8a5HARgWKws3+hXzG14v03i34cl7i/W885vXmNilQFBq5uki/5ARjwXuFuNPp7AAAAABJRU5ErkJggg=="
		,52:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAfklEQVQ4y2NgoAUQBII0IHABArIMWAUE/4FgNxCQrLkcCEAayTIgFAhmAgHI6SQbYAwEIKcrQQFJBoACDaQZFmgkGwBydgcQCEIBshdAfIK2vwOC/zgASA7kPYIh34EEQC4Cab4LBDCXkRQbJIcBNgNAtoMClqLkTLLThyYAAH4Wi3W1Ii+BAAAAAElFTkSuQmCC"
		,53:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAg0lEQVQ4y82SQQ2AQAwEzwJasIAFLGABC1jAwllACxawADsJTfpsGx7M55JL2t1u29qXjGIWk7A3XDyIU9yOQ4QboEjB4kg52ARFpdnN/iVwsYv0/KvABQ0sAxqVt2GBppx4UKdBORcbpeSAPNJ3QJCodWEB8hdW7C9sghDTdxBW+x0PlnF8lfVNM0oAAAAASUVORK5CYII="
		,54:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAnElEQVQ4y9WRUQ2AQAxDZwELWMACFrCABSxgAQtYwAIWsIAF6EtYciEhbPzxfkZI1vVaswcq0QimZWjFJBbBRCS8PIpdzCK1CFw7xCAsSydYRsS+gGUEECIDZi1Cy6S8CQQ8uFWQRS9CAvuFB8d1F30NsxQoO6cRBEIusH6/RhthAW+Bq/6PHEJPKC3zbiat8I1wqk6uYTlV4/85Adtwl2kpzwrRAAAAAElFTkSuQmCC"
		,55:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAcUlEQVQ4y2NgoAYwBoJQIHBBAyAxJSDAq1kQCM4AwX8cAGQQQReUA0EHEgDxz0AB2d5aBQRpQECWZpCzQbaDvEeWATOBAOQVsjSDQh1kO8HQxwVANoNcQJZmWJQSFXW4onM3EFAUdaDUR7YBZEfb0AYATdRYuRcED8UAAAAASUVORK5CYII="
		,56:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAmklEQVQ4y9WRUQ2AMBBDZwELWMACFrCABSxgAQtYwMIsYAELoy/ZJQshcEv44f0QlrW99UL4ilbMmUUMokq8iyh6MYkkMHMZcBFBmYrZIRrhNrBEREzkNugEAkzWDP9VPYwiFWzClQ4UR6K1z/urTK6F8TUTJnsUc9nSyvOqVdoElGlnGGLA81wdxAyJtoXX8e/WSYkYujfwf06z7LClrWHH5AAAAABJRU5ErkJggg=="
		,57:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAnUlEQVQ4y9WSUQ2AMAxEZwELWMACFrCABSxgAQtYwAIWsDALcC+hycIH6xZ+eD8M0ru1V0L4ik7MYhE8eXeLexHFJjiv4hSDcBmYwG5tRLzh/Cqm4BDP4qIudpF2AOTAt1FkDSiimAxagZGZugxgEogwYRNm4A4yzQQwIBc6Kv4nbCRyqBYzSnaFBm0yK6ujbTJwi21liAiyauZ/cwGpAZdpjTF3pQAAAABJRU5ErkJggg=="
		,65:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAn0lEQVQ4y92SQRGAIBBFqUAFK1jBClagghWsYAUrWMEKVrCC/jfjznAAgYMX30WZYd8uH5z7glEsohPNxV6c4hKTaBYEsQsEh0DYJNgER+CLhP/q4kFQaJMgsHUVq6DQsuAISBAXi0mc8GYRHiwLxEUBhYwbIrgFBIh78Xp1dEttsjBpkBXQKReWhckU2YcVh5fKhukQ5Pa40mPxEe5/3MJbkl0ZkCHbAAAAAElFTkSuQmCC"
		,66:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAkklEQVQ4y92SQQ2AMBAEawELWMACFrCABSxgAQtYwAIWsICFdifpJX2Q9Bp4MZ/22u7m9tIQvmASc8Eo3OJO3CKKRWyCPWuTAdjZKTAZxCsDV5QyAgJisN9F8wzIjZCalbumCCagEwyJUjV5MoBDuOZQM+CPVA1ixgwQUV/CFYGHdLAKBklNB65/YCbQZ1zT/w8JOsS1seIXxosAAAAASUVORK5CYII="
		,67:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAlUlEQVQ4y9WSYQ2AIBBGqWAFK1jBClSwAhWsYAUrWMEKVrCCfm+DzTk91Lk5368DxruDO+fexot2QxDsZS9WYhCjaATrWiBgn/Xp5VJMEeL9eSHM7J1YBNluvxk7mRGYZVqCWXwnAH4eAb//SEC/EfTikYBnpCqOOsEgMROmhP7TTjpCJSFCjPzSNCYR2XyEODtI/2YF4e18DV99BEwAAAAASUVORK5CYII="
		,68:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAlklEQVQ4y92SSw2AMBAFawELWMACFrCABSxgAQtYwAIWsICF8ibpJoTQUj4n5gKhu0P7us59QSPaA7XIai7EKrzoBM2DWMQskGcJgHf7XgoEiJHeFkAlEJytZQlgEkiiR7kSkIfl80gwilcCCzJ6rSkB56YZSTJEH7AinjSbODlUFDM0FPYBkuevBMhVZk0jlDuiW/4fGzA7vFVOLy53AAAAAElFTkSuQmCC"
		,69:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAc0lEQVQ4y2NgoAYIBYI0JNABBYJAQFAzSNE7IPgPBOVAADIARIMMUAICog0AAaJspKkBxkAA4oOcTrRhyGGwGwm4AAHJLoDZTJJXBkcg/ocCZC8Q7RWQortAAHLBKigABeIZIAAlKKJdAYs+ZECWl4YeAADaJYAJ3oyROQAAAABJRU5ErkJggg=="
		,70:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAYklEQVQ4y2NgoAYIBYI0JNABBYJAQFAzSNE7IPgPBOVAADIARIMMUAICog0AAaJspKkBxkAA4hPldGxhsAoIdkMByDCSXQCyWRAKBiYMyDbgPxSQbcBdKCDLAJghZGse+gAA+q1uPWqgK7oAAAAASUVORK5CYII="
		,71:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAo0lEQVQ4y9WSSw2AMBBEsYAFLGABC1jAQi1gAQtYwAIWsIAFmJe0SUO6bUO48E7Qzc7sr2m+pBWjmCOcGEQxuRe72MQk+CcRAd46YSYTPDxUkaos676IS+D8qm+cEaDsVwKnSAmMHmZhziAnwBYYILFVmFWEFnB7xpgLMYRMAZwslyoB2uAGUpuoEgi3wDpph0qch0Te+K7aCkJMPd5A8ZD+zQ2Ry6MZvVWpcgAAAABJRU5ErkJggg=="
		,72:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAaUlEQVQ4y2NgoAYIhQJs4mlAIAgEODWDJN9BAbJCEPsuEPwHAhcgoL8BIHAGCEgyQAkIyHYBSOEqNPAfCog2AKTQGApAbPqHAXosEG0AzK9kR+NdKED3wm4gALkMrwEwQ7AlV1ziwwwAAIeJunntxh17AAAAAElFTkSuQmCC"
		,73:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAANElEQVQ4y2NgoAYIBYI0IBAEApI1gzS9A4L/QGAMBKMGjBpAtgF3oUAJCMhKyoJQwDAyAQCwaVpRtWT/vgAAAABJRU5ErkJggg=="
		,74:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAWElEQVQ4y2NgoDYQBII0IHABArIMAGn8DwS7gWDUgJFrACgRgQxYBQRkGVAOBCADQDRZBpwBgndAoAQERGsKBQKQ32cCAUgziE+SrR1AANIMcjZJNlMDAAD+dGrJ/IQ7CQAAAABJRU5ErkJggg=="
		,75:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAj0lEQVQ4y92SUQ2AMAwFsTALWMACFrCABSygBQtYwAIWsADvki4pCwmF8MX9bGnSS1+3qvqCzijrrbiqn0hiM7h76SJeCXpBMxPcjl8KBjGLWoTye8EkaPZRwoLdYPTXApo5meSxABqRJaN4LODO8laBhIWGBDl/zs7z5VroH6yGXx5/gamIdPukyYjWf8YBHNSksXeIJtkAAAAASUVORK5CYII="
		,76:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAARklEQVQ4y2NgoAYIBYI0IBAEApI1gzS9A4L/QGAMBKMGjBoAM0AQCRBlwF0gABmyCgp2A8EZICgHAqJdAQJKaICspD30AABxgGqFrZ9hMAAAAABJRU5ErkJggg=="
		,77:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAtUlEQVQ4y9WSUQ2AMAxEsYAFLGABC1jAAhawgAUsYAELWMDCuJdwyUI22Ac/vB/S9Xq0W6vqCwYxi1ak8pyjSeZrsYsgMEkZbCKbx8ACjIjjfCfCRdZgvUBEq3GeoscOMVgEhYgwcq4RxJN4NUDsUXxZFI7C5o8j8EWMkC85zjHuRZEB4kPQCSYuKO6AmHH8IrxAkQFi/k7sdukiXrTXPfDFuaP4OTFlNC41ucr35clpSnQ/5ASgT+KVbzOXiwAAAABJRU5ErkJggg=="
		,78:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAnUlEQVQ4y92SUQ2DMBRFawELs4AFLMzCLGABC1jAwizMwizMQndP0ps0BGgL+9r5acrLO9y+NoRf8BCzGMS6xrde7DZ34i2iYL2JvL6IURwKnsISGvI6yYoCmohqCUdqEpCA9S4QfITPPYlqgf+I5CXYj4miwMNjTzOSKdEk8NXFBHPJZ1IlcHRLigIibz0WxJcEpKJ2KLDkTO1P+AKplaT188OY+QAAAABJRU5ErkJggg=="
		,79:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAr0lEQVQ4y93SQRUCMQyE4bWABSxgAQtYwAIWsIAFLGABC1jAAszHoxdoujweJ/5Ld5t0Mmk6Tb9kGXZh/+QQtmERZg9vwjWcgu9VIGbvEvyXhwVv4RxeqxETI8JhV4BVSZJ7ca7EOXoLqkhdQmXTQfFj6ArocyTQ2tDiVwLrUApAYHQHRlm2ADMfJdgfFXi00Vyo1uvfJGZfoUruw1jdvNWErB+9xiakKifW8vH8D3dyMb/JRIw69QAAAABJRU5ErkJggg=="
		,80:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAf0lEQVQ4y2NgoAYIBYI0NKAEBERpFgSCd0DwHwjKoeAuEIDEQAYRbQAIgNggMWMgABkIEiPoEmwGgMAZIAAZAvIeyQYge8sFCIg2wBgKVgEBSDOIJikQQRpmAsFuIAAFJrKXiHIB0VFHTCCSZMB/KCDbgLtQQJYBMEPI1jz0AQAZx5R9L1uiPQAAAABJRU5ErkJggg=="
		,81:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAuklEQVQ4y63SURHCMBCE4VrAAhawgAUsYKEWsIAFLGABC1jAQtmPaV4gSTsd/pc2uWRv7y7D8E/2YQyXmWs4h11YvHwKr3AP/g+BmL1nsG5eFpzCI3xnIyZGhMOqAKsOOVyLcyXO0U9QRuoOtGy6KH4LVQF19gRKGUrcJHAMTQEI9HpglM0SYOa9A/Z7CT5lFBey1eo3icVXKJN+GKvO+5b1qtdYhGQto6u5Wo3uK624sN4sNM40n/NW3pO92ME8g5ENAAAAAElFTkSuQmCC"
		,82:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAkklEQVQ4y9XSUQ2AMAwE0FmYBSygBQtYwAIWsIAFLGBhFrAw7pJesiwjdAk/vC8g261dCeELE8yVEVybI1yQYTEJ9O4OID7zG0/P5rWSVgCdwAC21x0wgNpyV8DFvDyeqNNX6LpEbTygewrEChTk/gfqO9jAPUIFaGTRuCeggGTKKeygtsrxPoa0FrECtuSq5L9ueFq/QU99uuwAAAAASUVORK5CYII="
		,83:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAmUlEQVQ4y9WSUQ2AMBBDZwELWMACFrCABSxgAQtYwAIWsDAL0JfskoUQuBF+eF9A1q69I4SvaMR4ohUucSeimEWbwGAVtXg04OAuKpF/d4lzg1686k/cPUENKp3T3MJhTJiDGW2iOJFtArEZDaK4EomoYkmK6uQmMfFocPXT8E6CRbi2wCqJzfMkiI6YubgjcyuTZ41u4f85AOPOkuVFZjCqAAAAAElFTkSuQmCC"
		,84:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAASUlEQVQ4y2NgoAYoh4I0NAATFwQCnJpBkh1AAFP8HwpgYiBaCQiIcgnIsHdAADKAaE24DDAGglEDhqwBd6GArHQAMwRv0h1+AAC92nDlTPpK7QAAAABJRU5ErkJggg=="
		,85:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAcklEQVQ4y2NgoAYIhQJccoJAgFMzSPIdFKArBPHPAIExEJBtwG4goNgAJSAYKQagKyTagLtA8B8IXIAAWQ6kEWQA3nQAAh1AADJgFRAgK54JBQRTIkgTSCHIGyAbQezdUIDX+egApBiUdNOAAN07wxgAAFvziAHzjYxOAAAAAElFTkSuQmCC"
		,86:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAmElEQVQ4y+WSSw2AMBAFawELaMECFrCAhWrBAhawgAUswJukmzSl6Sfhxly3ne7brXNfMItFjCKtDYJ6UbCLW2wirSGmXhRwCMEl0i6QrqIooM1TIIkPIztELtoLLxBwIe4sFysLrxABySSsfSTN2+ACArpByPCI1yzgZQTMwwe6/wQzsI1YlC5spfEwuyA7Eaq7r/0L9x8eSDN+cZfXhO4AAAAASUVORK5CYII="
		,87:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAyklEQVQ4y92SUQ2DQBBEz0It1EItYAELtVALtYAFLNRCLWABC3RespPsHUcakn71/QDD3s7sQim/YBR3cRNZ55l3WbuIVitvsYlJWLuKVaDnxhx+iarBQ1C4CBzQSLQFvHftMyhtVBfbjSIaomVH7gex24PHsNssiLsGJGMs6pyyAkcacJAUXCnEEX0M8p4qiOU90MxJvJ8pYDfdBrh5Zq6eM++H+Ixx+D/gQKFnbvez+3y9H6pX6P3kz3k4Bm5tIePksb42OaP/AR9LV+QtRl+KeAAAAABJRU5ErkJggg=="
		,88:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAmklEQVQ4y92SUQ2AMAxEZwELWMACFrCABSygBQtYwAIWsAD3Ei5ZyGAs4Yv306zZbu21IXxBK3pBjPOV6ATxUYDHu9hEI5wfxCyyAsBFRCbBuRaLuFZ1Cz/vJ5SN0CiKvOCBW3ElRdDrKhAp/t19W4AqOBcJuG9ibOgrGCWTSBn6agKUHo/MhpLP7kFqZN4DvGChsu7f5U34LwfZxY9xnXVXqwAAAABJRU5ErkJggg=="
		,89:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAiUlEQVQ4y+XSSw2AMBBF0VrAAhawgAUsYAELWMACFrCABSxgobybMMmETTsJCQvOjja8+UBKbxhklFb8eSPcFQNWybKJP5+Eu2JAJ/nWi1XfxZ6LFiHAKjJSVXXD/KcQwtyMU13dzEIAQXQU/hq+i3B1w+IIYLHhl9n8Id8FgO0T8vwrQ10g/ccF/N1yOeWl1UsAAAAASUVORK5CYII="
		,90:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAkElEQVQ4y9XSSw2AMBBF0VqohVrAAhawgAUsYAELWMBCLWABC+XdpE1IQ1KGsOGs2Mynb3DuC70sMst4w4u5wS5JNjFv1EnKaG5uwFSK2cpcPAjFh7CJqZiwytvJwzx9Eopp0ky+FoS1acAVzNMJjOIor36kcjZCLHmAzR5NZ33ezvcqnDJmzSb+IlTMYf7PCdAoi7l638qDAAAAAElFTkSuQmCC"
		,91:""
		,92:""
		,93:""
		,94:""
		,95:""
		,96:""
		,97:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAf0lEQVQ4y+2SQQ2AMBAEawELWMACFrCAFixgAQtYwAIWsAAzSe/Bi5YfCfPqJd3t3l1T+rnRQgcNVAkHWGGGBXYYodjAy5p49vUjU53EFjSrNlBodNuYoNpAoQKNrDcoNoieFUUa6xPC8BGnr8gkthIJeigeoPt3E23m1X/4JhfSymrJoLOJbAAAAABJRU5ErkJggg=="
		,98:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAhUlEQVQ4y+WSURGAIBAFqWAFs1jBCmaxAhWsYAUqWMEK+nYGZu5Lj/PT/eFgmIV7kNJXBrFVwoJLHII6JDgFgvANEBRBPVa6BZAFWVAzulpqAnKYBPNVMEcYyoAW3MFaQdts2+oSPElf/4E9bRaskYUrg1IhtEVQ78L9sdpGwuN0XiP9hxuHGZUFZi89XgAAAABJRU5ErkJggg=="
		,99:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAcklEQVQ4y2NgGAUoQBAIjIFACQhI1lwOBLuBoAMIZgLBKiAg2qA0IPgPBCBDkA0EuYYoA84AAcgAspwO8vc7KCDLAGQXuAABWQaA/AsyABSIIBeBxEKBABQ2RBsCCn2QN0CuWQUFJHsJpAFkM9leGZoAAN5jThmB9d5nAAAAAElFTkSuQmCC"
		,100:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAiElEQVQ4y9WTSxGAMAwFawELWMACFtCCBSxgAQtYwAIWsABvZ5qZnpgknNhzs/m2lBc6UbKs4hC9CAeT+RS3GESqgpSAzARQdlgwC3peBP3fFZdgEjxGYpUgcwvscbu2XbgEBF2VtMAG1u7cLbCjaWcQ3gIBZKSNrcJckIQucRRsxII+/YX/8ADMHZlF0xKNoAAAAABJRU5ErkJggg=="
		,101:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAd0lEQVQ4y2NgGAUoQBAIjIEARJOsuRwIdgNBBxCcAQIQTZLm/0CQBgTY+AQByEaQhlAgAHkBZgDIRUT5+x0QgDSAnA2yFWQAjE2SC1yAgKzQR3YyLAZA3iHaBSAAcjLIKyDXrIICJSAgySUgDSCbQV4hKy0MTQAAg5xmAVUeeOwAAAAASUVORK5CYII="
		,102:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAdklEQVQ4y2NgQAPGQBAKBCCagVTQAQRngABE7wYCkgxJA4L/QACyHcRXAgKSbAfZCDJAEAhIdjrItrtA8A4IQM4myRCQ4plAANIMcgGIDfIOSS4AGQJzAcl+hwGYAWSFAbILBtYAsqMRlg5AhpBtgCAUMIw8AACDH2HBH+uSvQAAAABJRU5ErkJggg=="
		,103:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAkElEQVQ4y+3SUQ2AMAxFUSzMAhawgAUsYAELWJiFWcACFrAwC/BusiVAQmj55vzAlvWla9Y0v4tWOgniKqRgllX4RkmFKWySXUapnWRhzxSwyf0we4S8BnAgF58CwN3pgAHWUFfAIAQQxD+DZG0OQC+xYKiuDp7mQkfmAjoIBV1wBa5jfoHpZJH6JtxPGZ6aA3JAkU3RIDXKAAAAAElFTkSuQmCC"
		,104:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAZ0lEQVQ4y2NgoBQIAsEqKCDbgP9AcBcIQGyyDHgHBCADyHYByIAzQABiK0EByQaAwEwg2A0EMDbJBrgAAYgPcg0oXEB8ssIAZPsQMwCWDsg2AKQZFPowsQ4ggAUq0TGBnArR+cMcAAAXR4xBZv2a4wAAAABJRU5ErkJggg=="
		,105:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAQUlEQVQ4y2NgoAYQhAKyNd+FArIMAWk6AwVku8IYCsj2Asj23UBAtgH/gYCiMHgHBEPcAIrDAKSZ7FigOCkPfQAA/q1FEb+F1DsAAAAASUVORK5CYII="
		,106:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAY0lEQVQ4y2NgoCZQAgJBICBLszEQvAOC3UBAkQGrgIBsL4AMAXmDbP+fAQKyXQCy/T8QUBQGI90AFyAAGTATCMgyoAMIQAaADCJZcygQgFIhyBCynA5KPGlAQJbTBaGA3OQPAEEfWUGAckJsAAAAAElFTkSuQmCC"
		,107:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAeUlEQVQ4y2NgoBQIAsEqKCDbgP9AcBcIQGyyDHgHBFQ3gGjDkA2AiXUAQTkQkGTAGSBQAgKQ5plAQLILQGA3EIAMICsM/kMBydGJHAYgzSBDSHIFcjoAhQHIGyB+GhAQbQBIM0gjiA8y5C4UGAMB0YagpwGyEtXQBACZaYFdPId3ZAAAAABJRU5ErkJggg=="
		,108:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAANklEQVQ4y2NggAJBIGAgB4A0rgKCM0BAliEgTf+hgGwD3kHBqAFD2gCK08FdKKAoOZOteegDAEtdV2UF8TaZAAAAAElFTkSuQmCC"
		,109:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAdElEQVQ4y2NgGAVgIIgElIAARMPEjYEAxsepeTcQ3AWCVUBwBghA7A4gmAkEd6EgFAhwGvAfClygAMQGaQLZDuODLMFpwDsgAGlA5oNcAuKDvESWATA+fQyA+RkbHxQOBA0AKYYpQOeDXACLIYLpgFj+MAMARKKpecWuNd8AAAAASUVORK5CYII="
		,110:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAWElEQVQ4y2NgGAVgIAgFILYSFJCk+QwQ3AWCVUCwGwjeAcFMICDagP9Q4AIEMANhfKIMANkIcgFMDGT7EDMApJgiA0CaQaEPE+sAApCriDIAPR1g4w9zAACqfHBde9tU6QAAAABJRU5ErkJggg=="
		,111:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAhElEQVQ4y+3RQQ2AMBBE0VrAAhawgAUsYAELWMACFrCABSzUAsxPIFl6YJcr4V1KSTt0Skq/m0oaYXy9eZBFRmGcJBzE5l06Yd4Kc4JCx94ki/3iKoRQyQ1gISH2PRXsqR4D8qmWMoA6bo1rcS+2FjXCv28WNnChPHOBbv8SFegcOvZ3HDyYa9m4UE8CAAAAAElFTkSuQmCC"
		,112:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAgUlEQVQ4y2NgGAVgIIgElKCAJM27geAMEKwCAhD7HRDMBAKQHFEG/IcCFyAA8TuAAMQH0UQZALLxLhDAxEBeABkAEiPoCmQDYIphYiBAkgHo3kIWI8kFoUBAchjANJQDAcgwUGwQHQswFxgDgQsUkJQO0MOA5FSIHgYkg1AoIEcvAAe3kl3eLoGgAAAAAElFTkSuQmCC"
		,113:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAh0lEQVQ4y2NgGAUoQBAIjIEARJOsuQMIzgABiJ4JBKuggCjD0oDgPxCUAwGIrwQE74AAJEaUASCbQYpBGmFid4EAZAhBA0AK3kEBTDGIJskAkGKyXQACoEBDDgNQTKC7Ci8A2bwbCEAaYKEPMpBoA2DABQpALiDJC9gARQaQFAu4QCgUEFIHADZakIHE+0GQAAAAAElFTkSuQmCC"
		,114:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAT0lEQVQ4y2NgGAVgIAgFILYSEMDYRGs+AwR3gWAVEJyBAqINASl8BwT/gSAUCEB8GE2SASAXkO1/qhlAUuAhGwDyP0UGgDTvBgKqpIMRCADee0JpCI59gAAAAABJRU5ErkJggg=="
		,115:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAdklEQVQ4y2NgGAUoQAkKBIGAJI3GQLAbCGYCQQcQgNhpQEC0AauA4D8QgGwH8V2AAGQQyQacAQKQzTCDSPbCfyh4BwTlQEByIIIMAjkdZhDIK0RpDAUCZGfDvES0AaDQB3mhAwruAgFIjKToBLkgFApIDsShDQBut16RaXHJ7QAAAABJRU5ErkJggg=="
		,116:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAZElEQVQ4y2NgGDSgHAhmAoEgEJBlwF0g+A8EZBmgBAQgA94BgTEQkKQZZCPI6SDNIBesAoJQICDZEJgLQK4hOwxABpAVBsguGBgDkKOR7DDoAAKQAbuBIA0IyDLEBQrI9sbQBACTlVbdxrVUbgAAAABJRU5ErkJggg=="
		,117:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAY0lEQVQ4y2NgGAVgIAgF6GJEaz4DBLuBACZWDgTvgMAFCIgy4D8Q3AUCmNgqIACJEW0AyDZkA2YCwRAzAKQZpEEJCEB8UIASbQByqINiA2Q7iCY6FmDAGAhCgQDkCpLSwdAHAGvRcF1v+DXsAAAAAElFTkSuQmCC"
		,118:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAa0lEQVQ4y2NgGAVgIAgEFBmwCgjOAIELEMDEQoGgAwiIMqAcCP4DAcggZEPTgIBoL9wFgndAoAQFu4GAJK+BnAtyBcg1IJuJdj4MgGwFuQDkEpDtxkBAcmDCXIEcFiS7AuQCUAwMXJoYegAAViJIhezwankAAAAASUVORK5CYII="
		,119:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAiElEQVQ4y+3QQQ2AMAyFYSzMAhawMAtYwAIWsDALWMACFrCAhfF+0iZcxkg4wncZzbb2sab5nYK8ajDLKp1Q97JIK9RRJik2YDOLH6Ih9SC+f9uAyVwgBVNZqUnB77F6uiIOcSkJ0zzFKHxX34G4XNglmmxoUm1A9N0EswkNqvFdMtfHfRT/4w5Ps4BNm9Z0+AAAAABJRU5ErkJggg=="
		,120:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAcklEQVQ4y2NgGAVgIAgF6GJEG1AOBHeBAESD+C5AMBMIiDbEGAj+A8E7IAgFgt1AAKJJ8gbIdpghMJeQHA4gb4AMIdl2mL/PAAHIABBNUiAqAQHM36uAAGRIBxAQbQBIMczfoAC9CwUgg4n2P6F0MYwBAB6vVHkRCRh6AAAAAElFTkSuQmCC"
		,121:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAf0lEQVQ4y+2SQQ2AMBAEawELWMACFrCABSxgAQtYwAIWsICFskO4pD96F57Mfyfb7aX0c9M8hAWzOMQoSukqWvEqGEQWSKwJMgTVLTaBxFoQRlwt6AWCXRBE4N6FkD2l3KOaTiA4RfhX2GIR4XtAQBNXkAFtuEmEDonarm/7igvEs1vpYu/SWgAAAABJRU5ErkJggg=="
		,122:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAZklEQVQ4y2NgGAVwIIgFEK05FAhWAcFMIADRZ6DABQhIth1kyH8g2A0EJHvDGAjeQQGITXIYgJwNsj0NCEi2vRwIKHI6SDOy00mKBVDIgzSDvABySQcQgMRAsUNyLCghAZJcMXQBAPRFVHl3aB+dAAAAAElFTkSuQmCC"
	}
}

$imageresources.fileselect = {
	"background":"data:image/png;base64,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"
	,"buttonhelp":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAJAAAAAQCAYAAAD59vZgAAAE+klEQVRo3u1Z7ZGrMAxMC26BFmiBFmiBFmiBFmiBFmiBFmiBFnisR+vZKHZC7o7L/Xie0STxh9DHShbK7fZ//B9/ZISDKqPwhTPVF86ffX74Ju+rZCeP+qDGPn9Sxp/212WCQPHuoMGos7lno5IzoxB+t3b+HSDCAb2d7+V8Zfx6o9bmzvBUekf2M/wpF85MQoPpUl3oM/VXb8/7GIgqE2Q5aDNaTLDqiXM6d4a02vzgItI7MziAjHZWz7f2nFnWZpurCuDIga5zgCTPkuz9iwCqbA/l2qqqUh6TPDOnfyjIH14Qs11vctIm44mAvyz7wNAzDLDbMENMBWQHAV06w7Esy940DUE4ihPpyNb4thJFeNZa13XkcXzy/ERHr+u6g0S2QXg24pDa1mYHyFGePZCnDvwW2btCACUAhhAeeMzzTBlnyWqUs3P2UPkbB3pm29ado27R9tM0Ud72E1mIkbRCcY6u63YXibUoSUUnKoGzbdtCmcTjAOQuDlRHzgIMzsMI8QwcYmc1M+wCoF0ifRWgdQKOFUCAXAD0MAy7ywwjAUTZsQdj2zbyH53OD7oTPNBb9Tf7bU7O1WUNb5M5s74U5qNN+GwB/K8DqKYxYDgYk58S6aM4fJa7fpEooGOj8yUS4298h7Gx74jayBufnKcTMUfC2XEc0zrkIoCwl2exx0X8otmUw2RcRZ+NMlF2AkD4TRndZwOo8k1gN/Dc6Y1P7Mc8gAqZuWbgjmexR8/QDjpv+u5/AUCpjqExoDwj0YRXxOfqhd0BKEYGHc51fIfivCYwjzkCjZEsV9jOjMgswrOQi1cl9wg4onM1E+qQoJj0WsR+fZ7pUtI7Ep8hmXaWmjABHvvwnfagrqoXbM7Awz6eIfCou5fx0wBiHZOuL6KdStFY/p4/MsCWSaMPxu37PhkZfDXFG5+7zKUAcs5MDoFcvOZwHt/l2ln0+WcARL7UEb+ZJcHf10gMFMlWPrOtzJLgA3kZLASQ6kX7ETTMOszEDEbqq776NIAarWNyxTCNhXoCoCGheHyWgdTZ3gHg64yfyANIrxc6mZlMecqVG2sFAjRT3D69wnzwQE/V2wrsSNRN6p1F6xM6mtlHAeT1YgYUgN6t52z4aQCl64vGhmOAcEU5I9EVek9rIDoYfJmBNKpYcPoMhP1nMxCvAzpdsiXlWzXyrZ7gev8KQFZn+AL3TnfWWT5rgCf1Y72iWaMEIAaV8mLto/rShp8G0N3blwi4WU/DG1JfgR/ewuhcdZimaL3X+axXNRANquuMUPKkY2x+lSbo5HpU2j9q9C3MX2HmRAVb7i1sJEhVfw7qoXULM1sJQKzt/MuM1kaa1f5CBorNKPQRjujXBlgsRA/wIE2XeiKpfsJ5RhBI0nxqsDFFA5DyFrbxbQTrMBSji1EIg3OdBT4zhfKU7MMucuM669rBTsED/VR2k883UkOhax4znb4R0uHMqJQde5jhoYNl3nQVMhPjbM5WhXnyVt1/FUCMRKZn7fz6+SbTMWUkLo60gTa6fs/qXodzfQ9PpbVcH6h68l9XyOiee950ohPt9S/psBb6Pr73U9JrPmGn+YS8l/4H1rr/rqrCfO4a1I5yJ53m2vHpMp3oxnVYPY82s16af/e/p+Bk65xs1Zs8XnWPn3XjPZX25ezwyke/BqTwxvyrPy3DyfXwg/Rd3b/DK1xMtwv1v/0Di1HHIX2ZSlsAAAAASUVORK5CYII="
	,"namepanel":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGwAAAAQCAYAAADzhpp3AAAF30lEQVRYw+1YsY4URxB91d2LOBBCdxE6bXT+BRApgcOTfTGydL8BOEHyBfaJv7DIMQEfgGSJlIzAFmhFRobgTquZ7nJwVe03tbNwmR0wUmtmp6d7p+vVe/V6BACOjo6enpyc3B+GAaqK1hpSShARAMBisUCtdXJPVTeuW2sbfQB6H9/LOfffPm8pBbXW3qeqUNU+p6oipYSUUr9fSun/kXNGSqk/z/OUUvq13/f/j+/qx9wauX9uTLwXY3GZ4+3bt3j06NHDZ8+e/Rr78tHR0dPT09P7qophGCbB5Zfc1gB0oHxcBIfB5oWklJBzniyQn/PkqbVCRPrZ5/fxPJYB8TMnGj8/BxqvjRPDE8HvRRDm4rINzC8dnz9/xqtXr3BwcPC9iJy/efPmT+4vx8fH98/OznDt2jXs7+//VUrRUormnDXnjJyzppSaLVq9WdD9QK1VW2ut1opaq9ZadRxHjOPo1zqOow7DgHEc2ziOWK/XOgyD1lp1GAa01tSf5zG1Vvi1zeFjdBxH1FqbP+fjWmtoF4e21tQYqgC8IaWkIqIpJTXwm59zzvA4hDMWi4V6fymllVLg8SqltJQSFouFWsNisWhXrlyZNL9n41sppeac297eXjs/P/8FAK5evfobgFMGLJ2dnWG1WuH69et/u9xwswWJZZzIRcoIyZRYcNBam7v2QKLWCgtgv+8MUlX14NIcvVEi9N+tNR8n/N8un/5u/r5MCGayrVXtWnn9JrOSUpKcs7jsWiJ7H6xf7dzHG6jwZiQAP+PjnI3Hx8c/v3jxAqvVaoOBqV/8+6Jqi+kvYtTmRSvXFstgjWAZ6yQEXyz4woH3+/a80vXkmTkgCbgOlgPP9S9IlwLQIGVCAHQpTSkpAbStqVwcmlJSAkiMnTAGTkDzhIiE+PTp06xkJjYBBpbwy5ImK7PK64tLIjcLuM4wBBEUn8dlywLdATdgfb4NdgagwSyLYNlvofoikWUhBhO2GHA9sB5wniOAIQaSzPQxy9Rqtk7YMHMUYhhyzvLkyZM2jiOWy6Uul0scHh567YKq9jMBp6oqLHczTOHfyr8j+1SVx0QAvSb6c9IMaQc/NseJQPI6LKQmDNqG2gTWKQHXzQ1JJUopnVVU9zbYRYZIUkrsC3ApwFJKePfunazXa93b2+MFismHBOnRIEnMGrXsVzIEmGFIlDiJwNdaG88d5oIB2KgeAoCoavP65UaJgqQBJAZGSWWEAaK6hgCckFEDGRFx0CKz4vbC3rm77ksBtrOzg1u3buHOnTvY399XW3AL6HdmkVmIJoMZ1IGutQqbDJbFKKMkryBpZBnl50BuEGQ2mqtMsPFCEthrFUmb0pnBFappIiKNzIp6zXKmuYsk9oHZ6dsFju+lAHO0l8sldnd3sbu7K+M4uoUXkxXxxTvDLGBz8qaBBZEVUQIZ/OgsWR4ZKGa7BEPk2eV+SclYdHCsXznrHRRilJjlj8ZDCUCXQrf5nVnmFicyGH2C11df21cBs4W0Bw8esJ2f7PrJaHDQxJkxF+AYeHKTLKcMqmyx9hrrIkusjwm1S0L9mgSIjUAEiWw6gzax4OQgwVLodt4lkaUymJjJhwRPvFrr1t12tPUT12QLFgqCcla7jIVaxrVnW43aAMoBcTMx4wIxZ1I8afzlKDuFvjQo1QkFoDNZrjN7UHbPGtyicmI7mA4ayaCyDEZWBTL0jwaXAcz3EIiLixMHhjErtmX/RMaiDSeQwWD5Zjnu3XguHnthYvs3SI2fjmb2TcpMi0bCgi45ZwmbaonMIwfoUihWw2QbuxA2trbOLzNsvV7j9evXePz48Xe2SVbOUAYrbEzn5CoGGxHAGWnkPp2RSM+8ybYgWndnGeu/s4uVwzeo9PVCZ1ziBrDR2juAbNUNIHxNBuljRI+tAaW1Vj08PDz5+PHjLGBy9+7d32/fvv3TjRs38PLlS3w7/j/H+/fvf1ytVs8ngAHAzZs3f7h3794fc9+uvh3/HVgfPnx4Hu//Az3zc26DOCQEAAAAAElFTkSuQmCC"
	,"fileconnection":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAQCAYAAAAMJL+VAAAAwklEQVQ4y+2TUQ3EIBBEa+Es1AIWsIAFLGABC1jAQi1gAQu1wPFI9tI7Dj64j/vpJJOUMrOzu0237cYKHj9gWlgptR8VZRHOuWMYUi+dCFNKS4wxNmqtbReUcy7neZbrADyHEF7GT4oWHzrR1oDCpt8C6ADD1eS9b+JRAE3JxNZaVtRYV03A3gVA6QQhxRGPAiBaY0zTTQMQ0gVdi4EADKPiMqFoqSHnLoAX9SJTnKAVSvH6fd3sH7CIFpm/dX7jv3gCiGyf91LETRsAAAAASUVORK5CYII="
	,"titles":{
		"selectfile":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAIAAAAAQCAYAAADeWHeIAAAE/klEQVRo3u1Zi62kMAzcFmiBFmiBFmiBFmiBFmiBFmiBFtJCWtjb4Txo8DnA7p5OOulFit6CE38ntsl7PH6P+jWH11xec3UT70ajz+5d8/g/B/SexF7Y1X7Iq7K9vc3G3n0zWtMvvWa2mQqxGSx+X40ODJumebZte5iv908qUVXV9g7rTKH+Lxj7r0dleifa+LIrm8PrD3mtEqRvwERwgkeGn/u+331uuj4LcfhqgEFeluUZjXEcNyBAKAbWGTAmM7aTyRNQ2W9Pq41Wu72tozUBrRQEru0DHSI50Hu3z4C+CN3bUpKDv0td15uPECwDwhgcDNWjd/aqLTjRGfzU/4wNQXsRh4j36RgUACmljfm6rgcnBYKZhpLM2RwwBrQ1KCdKm402ub2rveucUVq6VM5yIScFAEhSEjyfriBnS9EFv7QS1M70XwNfqU2NydgDjuDjpF8AYL3B+z4AeOIx53ne3wWCn0D/MAz7CUB6YslQGg2RmratJ63rukO54akSWpZTyuAjOEnl4C+eIzlCewYA2CZkUa7wSSyBXg7fYeDAGK9sPmV/AL2z8hZfrRKogamfh49ytATciYMA4xYIigBgKgLNC4ZSOedDuYDiUBLGRoOBjsrNNE1PBqxA01rdsm/xOlAO9NAshoG1DLgHgF+r+pbkMPg6zHejBjWyF/KcTWPkm6sScBYHA1/zFgDgbAhBIMgYhnrBKBVKwz4qDERiL5sYDy4OKI+1yDSgQWkGCs7HXgbGArVKvUsEKPbzBEMv8CGN9jBYoHsAkEagE4RcS1shh3TKucgAm2+hg+7lsCwzW5CKGeAMAKU44Plusz6cNYFEkwrWQMHRMI5KKzJB05NFAFBp7Mdepi3KwB4in2ttb5ImbNVMwz1M8wo6OAXPBLQHgILfr6UMPEuJ27PkSQ+wAwD7YCN40x7XgDZRD8DsVAIAbCVQ6S8Xhyz9QPET9QAA/GWtAorM6INgBFcHG0cYCEM1LUEhnwGgONZq6uJJjfiyBxEAtOboLUAevBpUDjyTVwkA0VqeWEvZh/6iAIBFOvHti4OnEvbyd5DV9vV3AVDyF+Mg+ibpoaq7PUA+63bdqdh7Bp585eWfoaA1hQcjCCxtcMAf601Oks+dRFlcp00rf1sq3PsLOkaD4NLmvpYHIGoYuVazlviNn2azyuJ3vOOX5UJnfAcA5M1y5OPA35YZi/cdEQC4uDd68oIZVIDAp2rS8I6B0JKhJ40pCzRtxohmZgkL3Co3b4mB82u1ZynJ0SBoRovWep1pK7KP3ytpvfcAgC+0BAhopk8BcBaHwn1HHV4EsYaIozv5lFn5Peq/Euh0BpcpXms/6yoDCccpHb+JWJ548oVBdtr++Arwa5lieRq8HASAcpjmNROV1tJW7V1UjvrBehCWge1wQX+1hzpbk8nLo1ovglQ3fb6KA/sB0pydcwSA/VtVUtgsnw+sTTkqDdoQXdB8Dc3BvkWuVj1tluaK17BLQQe9pMo3ZacTuWdyIn1HudGcL3yhh61z/PLF3qs46PtUuKXcT/kgN2i+Y2zM4aT3kopHmXpNOhpwRjcHmfqOnWrraORbF66B+4B/K1e3Xk7v9vTSV0Q61QU59AH9MNn0/6BpAnu8jMrdHA7OV6W93t+lOJR8GN6tf0KvAlpVmFf77tAeJ7Le4VV9ILe62Ffd1PFdX1cXMq5k/4yfcRy/AD9jC24c5S6QAAAAAElFTkSuQmCC"
	}
	,"buttons":{
		"file1":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEAAAAAQCAYAAACm53kpAAADO0lEQVRYw+WXWyisURTHP2ZGZqYkmXKevFBePHjwgAcv82CmPClRCiMRUZR7Dc0kcpvIpWPKcSvNuEWUEc4LeXJJk8vLIOUyeJFC1P/MWp1PpnPijDHnaM6u1Td7f3uvvf+/vfb+1giBgYGCaIuLi7aHhwfc3d35tTkcDhQUFAyHhYV9cROPn+Xq6sqvbXBwkC03N/crix8ZGRkWxc/NzaG8vByVlZWora1FfX09jEYjmpub0d7ejs7OTvT29sJsNrOT0dFRWCwWTE1NYXZ2FgsLC2zkZ2ZmBpOTk7BarRgbG+O+Q0NDGBgYQH9/P/r6+tDd3c0+Ozo60NrayvM0NjbCYDBAr9ejrq4O1dXVqKioQFlZGUpLS1FcXIzCwkLk5+dDp9MhOzsbWVlZyMzM5N+u3eV+pIF8kM+uri6ed2JigtdBa8/JyYHbzm9sbKCkpMQjAAqFAoIgQKlUskkkEl4AAWhqauI2EiMCiImJ4f5LS0tc9xRAamoqIiMjER0d/W4ANpsN6enpSExMhHB8fIybmxsWX1RU9G4AVJ6envD4+MhPCrW8vDx+19LSgt3dXTcAVNbW1jwG4IpYHk8AyJ/XAHZ2dkBG4r0FYLfb3Y4A9aEjcHR0hIuLizcBkAgK7beOAI1PTk7G3t7e5wFgMplQVVXFfUQAYgQ0NDT8cgReAqCzSDsbHh6OoKAgREREfBiApKQkxMfH81po7T4DQAtKSEhATU0Ntre33QAQnNciICQkBDKZDPf39yyU3tP8FBXeAiCg1D8tLc23AKjc3t7i+voaJycnHgGgekBAAEJDQyGXy9lo7OnpqdcAVCoVYmNjMT4+zvfQX70D/hQAhb9UKuU2ioKDgwMsLy9/CAC1Ws1HbH19nSPzUwKIioriNnqSkODgYGg0Gs4ffH4JuvIA/kyRyH8FgHxqtVoGQBdgRkYGzs7OcHh46HsAKSkp38gxWU9Pj8cASNTW1hYuLy+xurr620zQ6XRic3PzOROcn5/n8J6ennb7DK6srOD8/Jzz9f39/VczQSofAoBSYVfluwihra3N71Nh16az+GcALyGQc/Glv1tcXJxdePl3mCD8L+Jdd5GVNP8AWbsI+XYmU48AAAAASUVORK5CYII="
		,"file2":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEAAAAAQCAYAAACm53kpAAADn0lEQVRYw+WXWShtYRTHtzFDSTIdz5IXD5SEB8oQXiglSpkSEUWZC5HIGJku5ZpKjimiHOGmyIMM6WR4MaTMXqTM/Z21ulvnXOe49xy5bud+tdpn77322t//t9da33cEQ0NDQbSZmRnZ/f09bm9v9dr29vaQkpLSa2NjI1ERj5/j8vJSr627u5stISHhG4vv6+vrFcVPTk4iOzsbubm5KCwsRElJCcrLy1FVVYW6ujo0NjaitbUVnZ2dHKS/vx+Dg4MYHR3FxMQEpqen2SjO+Pg4RkZGIJVKMTAwwL49PT3o6upCR0cH2tra0NzczDHr6+tRU1PD76moqEBZWRmKi4tRVFSE/Px85OTkICsrC5mZmUhPT0dqaiqSk5ORmJiIuLg4xMbGIiYmhn8rvi77kQaKQTGbmpr4vcPDwzwPmnt8fDxUvvzq6ioyMjK0AmBhYQFBEGBpaclmZGTEEyAAlZWVfI3EiABcXV3Zf3Z2ls91AeDl5QVPT0+dAchkMkRFRcHHxwfC4eEhrq+vWXxaWprOAGg8PT3h8fGRj5RqSUlJfK+6uhpbW1sqAGgsLS1pBSAiIgLGxsawt7dn0AYGBh8HsLm5CTIS/1EAcrlcpQTIh0rg4OAAZ2dnvwVAIii1NQFwcnJCeHg4np+fuewojkQiwenp6dcDaGhoQF5eHvuIAMQMKC0tfVMCygCoFhW9CLa2tjA1NYWjo6PGEiDh7e3tiIyM5DjkS0MTAF9fXy4XmgvN/dMA+Pn5wdvbGwUFBdjY2FABQHDeywArKyuYmJjg7u6OhdJ9ej9lhaYm6ODgwH4EnUpOEwACSn4E7FMB0Li5ucHV1RWOjo60AkDnVM/W1tYwNzdno2ePj4/VAnBxceFn/P39Oc7CwoJGAHZ2dnBzc8PQ0BD3ob/aA/4UAKU/NTcalAW7u7uYm5tTCyAgIICfDw4OZv+VlZV3m2BgYCCX2PLyMmfmPwnA2dmZr9GRhJiZmSE0NJT3D8oAgoKC2I++KsWkUvDw8PjYKqDYB/AyRSK/CgDFDAsLYwDU1KKjo3FycoL9/X0VAPTcr0bL4fb2Ni+hOgEICQn5TqlF1tLSojUAErW+vo6LiwssLi6q3Qmen59jbW3tdSc4NTXF6T02NqayDM7Pz/OSRvv1nZ2dN6sAZcTDwwPUDWq+OgGgrbDi5IcIoba2Vu+3woqPzuJfAShDoODiTX03d3d3uaD8d5gg/C/iFb1ISppfAJUqDU+z/HE2AAAAAElFTkSuQmCC"
		,"file3":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEAAAAAQCAYAAACm53kpAAADwUlEQVRYw+WXWSitURTHj3kqU5TrFaXkQZLwQJEML0oJKVMioihzIRIZI0OXco3hmCLKEe4D8mRIJ8OLIWX2IjLW31mr+8nXPee458i9cnetzjfsb+39/+21115HoqurKxFsZmZGdn9/j9vb2y9tu7u7SE5O7ra2tv4mEo9f7eLi4ktbZ2cnW3x8/HcW39PT0y2In5ycRFZWFnJyclBQUIDi4mKUlZWhsrIStbW1aGhoQEtLC9rb29lJb28vBgcHMTo6iomJCUxPT7ORn/HxcYyMjEAqlaK/v5/7dnV1oaOjA21tbWhtbUVTUxP7rKurQ3V1NY9TXl6O0tJSFBUVobCwEHl5ecjOzkZmZiYyMjIQGhoKDw8PBAYGIiEhAbGxsYiJiUFUVBRfK1aX+5EG8kE+Gxsbedzh4WGeB809Li4OopVfWVlBenq6RgBMTU0hkUhgZmbGpqenxxMgABUVFfyMxAgAnJ2duf/s7CzfawrA0NAQ5ubmsLKyYj8ODg4aA5DJZIiIiIC3tzckBwcHuLq6YvGpqalaA6D29PSEx8dH/qVQS0xM5HdVVVXY3NwUAaC2tLSkEYCwsDCeOOWpra0t6Ovrw8LCguerNYCNjQ2Qkfj3ApDL5aItQH1cXFywv7+P09PTNwGQiJSUFLURsLCwwNdOTk7sh6D09fX9ewD19fXIzc3lPgIAIQJKSkpYrCoAtBcVuQg2NjYc4nZ2dmpzAG0z8kERQEDUbQEfHx/OFzQXmvuHAfD19YWXlxfy8/Oxvr4uAkBw1EUA7WkDAwPc3d2xUHpP41NUKAPQ3NyMgYEBmJiYQEdHB+Hh4SoBEFDyR30+FAC16+trXF5e4vDwUCMAdE9CLC0tWRQZfXt0dKQUACVXmqO7uzt/S9BVAbC1tYWrqyuGhoY4D/3VHPCnACj8KZypURTs7Oxgbm5OJYC0tDTOFbS6BI4SoioAAQEBvMWWl5c5Mj8lAEdHR35GvyTE2NgYwcHBXD8oA+Dp6fkS2jSGOgBvJkFFHcDHFInUBoCfnx/vfWUAKFTpFKBEJQCIjo6Gm5vbb6dASEgIA6AEGBkZiePjY+zt7YkA2Nvbc6QYGRnB39+f/d7c3LyvDggKCvpBZMkouWgKgEStra3h/Pwci4uLSivBs7MzrK6uvlSCU1NTHN5jY2OiY3B+fh4nJydcr29vbys9BR4eHlg09aPKU5tKUASASmHFzU8BQk1NzacvhYUckJSUpBUAxaKz+BcAryGQc+HlVzfFVpRLXv8dJgj/i3hFMpaS5mc+9wdn3pODQQAAAABJRU5ErkJggg=="
		,"options":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEAAAAAQCAYAAACm53kpAAAEiklEQVRYw+WXaSimaxjHX9sY+5IlazKRponwQRlqJEvmgyWJmsIgMlHWRMgMZazZ1xh7hJAP+ODEpymhOFLKvmTNnozlOu//6jxPdDrN++HozHGeuup97ue+r+V3X9d1369EXl5eIsjY2Njo9fU1XV1dPWtZWVmh6OjoVl1dXaNHwdOfz+Hh4bOWb9++sYSHh9dx8G1tba1C8MPDw5SYmEipqamUnp5O2dnZ9OXLF8rPz6fi4mIqKyuj6upqamhoYCXt7e3U3d1N/f39NDQ0RCMjIyzQMzg4SH19fdTT00NdXV08t6WlhZqamqi+vp5qamqosrKSdZaUlFBhYSHbycvLo8+fP1NWVhZlZGRQWloapaSkUEJCAsXHx9OnT58oJiaGoqKi6OPHjxQaGkofPnygkJAQ/i3dXZ6HGKADOsvLy9lub28v+wHfw8LC6NHOT09PU1xcnEwA8NvR0ZH09PTI0tKSkpKS/jMARkdHKSgoiJydnUmyvr5OZ2dnHHxsbKxMALy8vEhOTo4VbGxsUGZmJr8bGxvLBMDExIRev34tApBmIRkYGPw7AObm5giC4GUBUFBQwMG+evWKs2ZtbY1LIDAwkCQSCRv/GQAFBQUyNDSkm5sbMQNmZmbo6Ojo1wfg6enJgcLB4+PjRz0A49ra2oSsMjU15V21sLCgFy9ekK+vL89F8A8FAJAR7969o+/fv7NefX19MjMzIzU1NfLz8xMBSLs2qaqqctlhLUoQAAICAkhdXZ00NTVJQ0OD3N3dnw6AlZUVB9rZ2Umzs7OPACCVlZSUeGcVFRXZoR8/fpCbmxuvWVhYoI6ODnbe3NycMwjlh3cEvLq6SioqKqSjo0MHBwe8o1gH2wAA/QCMNZijrKxMAwMDDAY69vb2SNrTGAoy7UkAuLq6slORkZE0MTHxCABKAztwf3/PALCzeNDwsCY5OVkM2MjIiL8hAwQgp6enPA/pjeyC83j39/en0tJSBoB5l5eXbEeAbWNjw/ME+yiRycnJpwGQm5vLxkB9aWlJBIBvGPfx8REzQABQUVEh7uTd3d1PAaAcpqamRADBwcE0Pz8vAkCvQKCwcXt7y3WP0rGzs2MIGP/69evTAEDDcnJyYseEusYOo85fvnzJQe3v77MTSFM8Dg4O7BhuYXBYaILn5+d/AYCyQWqjuXp4eLCd3d1dLre/A4CGjLovKioiW1tb1odxmQCgZtDZEaSsAHAPaG1t5aMMtYtg4ACMQnAKwDkEgqaJpgVHUBpokO/fvyctLS1O7bq6OrK2tmbbAAA70IUGh2YIm1iXk5PDtjAPAN68eUMuLi5s7+3btwwGwAGmsbGRM00mAN7e3s04XiBVVVUyA8BNEIpOTk7o4uKCZXNzU7wHPCwB7CBqf2trS7wINTc38xgE/QP3CRyFwjG4vLxM29vb3NhwXxCOQZQdeg/6xPj4OC0uLnIJAOTOzg43T2QgslImALgKS19+EyAgjf6Jq3BERATV1tYygF/tJijddA5eBPAQApQLH5+72Nvb/y55+HcYEP4vwUuPzh7E/AfXy+fh5u/QMQAAAABJRU5ErkJggg=="
		,"copy":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEAAAAAQCAYAAACm53kpAAADqklEQVRYw+WXSSitYRjHjyFjMoWUZGFhiIgSyZqFYUVKZpExikQoEplnXcpcIhQp0+JaWEgs6EZSZIFMhZIh/O/5P93v5LjXBkXuV0/Hd773PN/z/73P+39fKl1dXZUS8/Pzc3d3d7i5ufnWsbu7i9TU1AErKyt7LfH4c52dnX3r6Ovrk0hISPgh4gcHBwcU8dPT08jLy0NBQQGKiopQVlaGiooKVFdXo76+Hs3Nzejo6EB3d7ckGRoawsjICCYmJjA1NYXZ2VkJ5pmcnMT4+DhGR0cxPDwsY/v7+9HT04Ouri50dnaira1NcjY0NKC2tlbeU1lZifLycpSWlqK4uBiFhYXIz89Hbm4usrOzkZGRgbS0NKSkpCAxMRFxcXGIiYlBdHS0/K2eXRlHDczBnC0tLfLesbExqYO1x8fHQ2vm19bWkJWV9WYAycnJ8PDwkGBxHPMVAczNzSEyMhIBAQFQ7e/v4+rqSsSnp6e/CQBFGBgYwNTUFFFRUVKso6MjPD09vz6AjY0NMCj+rQAoXE9PD4TJ6/r6Wtba/f29mM63BlBSUgKVSgU3NzcRv7W1peUBi4uLGgCurq6ws7ODra2tBIUqAGJjYyWPmZkZ1L4EIyMjWaMKAENDQ1hYWGgAmJiYIDQ09PMB8MUsPCgoCE9PT6+aIAXq6OhgZmZGukNfXx9+fn7SEcwZEREheTY3N7G6uirP6SXsFAKwtLSU5wQSGBgoAJiLYD8VQGZmphTm7OwsLf8aAM4+iyak9fV18QjO6MXFhRYAXtvb25LP3Nxc/IkAKIoA+b2DgwO8vb3x+PgoS+PTPYDrn8XxgPEcQFVVlQaAr6+vjOHFQgjAxsZG7l8CWFhYgL29PaytreVe8QAnJycZw+7gO46Pj7+GCebk5EhRxsbGCAsLkwIogOaoAGhtbRUAFNrb2yvrnL97CaCxsVHanGNZ5HMASUlJmhycfW6/7wagPgegpqZGRL4VAAtZWVmR4ukFPj4+4tDM/fDwoDHBpqYmhIeHw9/fX/Kfnp7+tQT46eXlhZCQEGl/ZQkoAAiOncbl9iG7QHBwcC+3F0Z7e/u7DkJsXbbl7e2tFEhxe3t7Wtsgjevy8hKHh4c4ODjQmCBNkh3Ei1vn0dERzs/PZWukOBomPcPd3R0nJydYWlr6GAA8CqtvfioQ6urqPvUorHjAv84By8vL2NnZEbjvOQeoJ13EawA8h8A9Vnn43UO9k/xSPf93mBD+F/EuLi6j1PwbeOIh1xfOMYkAAAAASUVORK5CYII="
		,"erase":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEAAAAAQCAYAAACm53kpAAADnElEQVRYw+VXWyisURSe3K+FkkYpxYOUBzwoHrwhD7wpJddERCGXECGRa+TSoRwGyeSSSzGikzyLOCFJeBNS5E7fmW91/mnmHJ2aOXXOxK7V/LP3mrX39+21vn+NysbGRqXYysqK7unpCQ8PDx/ajo+PkZOTo/Hy8lKbgMfPcXl5+aFteHhYLCMj44uAHx0d1SjgFxcXUVxcjLKyMlRWVqK2thYNDQ1obm5Ge3s7urq60NfXh8HBQQkyNjaGyclJzMzMYH5+HsvLy2KMMzc3h+npaWi1WkxMTIjvyMgIhoaGMDAwgP7+fvT09EjMjo4OtLa2yj6NjY2or69HTU0NqqqqUFFRgdLSUhQVFaGwsBD5+fnIzc1FdnY2MjMzkZaWhpSUFCQnJ8uz/nbFjxgYgzG7u7tl36mpKTkHz56eng6Tm9/c3ERBQYHZBPj7+8PV1VXMzc1NrLy83GoJ0Ol0SEpKQmRkJFSnp6e4ubkR8Hl5eRYRQOAqlUrS6+rqCtvb29ja2sLGxob1E7CzswMawf8tARz7+/tiR0dHn4+Azs5O2Zx+xhpga2trYgoB3t7ecHZ2hr29PfRaJPsrBPCAnHNycoKdnR1CQkJMCPD19ZV5xtOruXUQEB0djYCAAMTGxpoQwDUfHx8ptba2Ntzd3QkBfn5+WF1dxe7urvhERUVJbBLg7u4uBLCc1tbWEB8fL9lDYMHBweJfV1cnwsvniIgI6yiBl5cXvL6+ih4YE0ByOL+0tATqDgkg0MTERBMCDw8PZV6tVssczdPTU/a9uLgQYC4uLjLv4eFh+C2fud9/J+C916AC7vz83KABTU1Nkvo0ZoXic3Z2ZtCA1NRUAcY1prpSAgoBJycnODg4EM3huL6+tg4CNBoNWlpa/kgAD8B5giKQXwkICwtDdXW1ZFJoaKis39/fm5RAYGCgiGtCQoKUGEGaTYC+D5DDEqSlBLAP4E3RlD4gJibGQAAJysrK+i0D6Ecgjo6OUu8URIUACpuDg4OIIH2YDRyKCIaHh4s/1/hZUlKCvb098wmIi4v7ylug9fb2WkQAO8Hn52eDBhjrgPIa5DAmgBowOzsr829vb3h8fJTn29tbQwkwptK700fRABLAs1FMOfjJ/SzKALbC+i/fFBJYj/+yFeb39fV1ibGwsCBvBeM+gH6c52/f6wPYH4yPj5v1GtRfuoA3EGBMAoMrix/d9NryXWX8d5gkfBbwQUFBWmL+AQLmEC6e2yoRAAAAAElFTkSuQmCC"
	}
	,"cursors":{
		"large":"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAEgAAAAYCAYAAABZY7uwAAACzElEQVRYw+2ZyaoUMRRAuxye43PECUVxoYKKCi506UoEEXHEhdPSH/AT/BxBUQRBQQRx4c6Fs6CIOIAr56n1HOjbpPNS/ey3ku46m6RSqVTldJKqm65aDX2p+p2c1mHYJbQhTScVNAPmwDjMBY+HWc43+Axf4DukoqqSnIWwEbbDWlBSBf9b5/7AQNMl64PXK+c9PIWH8Aa+QkiqSnJ2wAHYDcsgHUFxk/Rmdfn8uNShvGyyOv9SPy3Pny2Ish/wAe7DTbgDb8HyHkGuNSHnMOyBVTAG2vSGqZz8Znm+JKuus3ka+brzpTTPp4JiLY1nTNfW3/AJXsAtuASPwClnv7sdmAdb4SjshTWgnF9g2awOsyHSPJ+WuYZFGr/UT4g0KJWb9751deuOS7g8zIfxhEWwGJwdy2EfvILbcBEcTR+hK0ibVnZanYFNYEd9SMui08MqaAVYdgMuwwNQUHeKucY4Yk7BCXBqOUQ16ygaBUGWX4Or8AScYj2CfFudhWOwFPaD50ZFkHWugJKeQVHQaXC9WQIHoRFUEHQEvPgQNIIaQYMJOglOMS/2W6gRlL3FjoOCXKR9mzWCOoL8DloJfiA6xVaDr/lzMCqCfG5f8dehKMgLt4HfPpvBRuzgeRgFQbalHOOxl9AjKKaSlY3gd4HRvK97p98FGGZB68Dw4i7cA8MOI/oJwaod0uYW2Aku3Ipzj8SHsc50MFWcedM4TtOoGwGiU7bdIfKRGjDGsflI2wlpeZ5P24hzCo711T7MBPs31sG85+yb2x3PwSD1MXg8IZoPSf7imt0A68GGQpAPkEbCaZrmI4ov7UbGPktE2+nmVGlnr19ZvzZKO6NpJB9bOIo07lLKa3gHEckXN8xiJC0Ah6ENxa846IZWLmgqbUx1+7Tfc+T447txpiinVoy+2i3XsOywHPY96RDq1FRMLrhqNUz9X42GVusvMnuwkfiTOZ4AAAAASUVORK5CYII="
	}
}
$lefttabfileselectpanel = {
	"element":"div",
	"data":{		
		"id":"fileSelectSettings",
		"class":"paneltabs",
		"attr":{
			"tabGroup":"leftpanelfileselecttabgroup",
			"data-req":"fileselect,active/true"
		}
	},
	"children":[
		{
			"element":"div",
			"data":{
				"class":"panelclose",
				"title":"Close current tab"
			}
		},
		{
			"element":"div",
			"data":{
				"class":"paneltab",
				"text":"File Select Settings"
			}
		}
	]
};

$fileselectpanel = {
	"element":"div",
	"data":{		
		"id":"fsSettings",
		"class":"sidetabpanel"
	},
	"children":[
		{
			"element":"div",
			"data":{
				"class":"panelgroup",
				"attr":{
					"name":"Skybox"
				}
			},
			"children":[
				{
					"element":"span",
					"data":{
						"class":"grouptitle",
						"html":"Skybox ID (0-7)"
					}
				},
				{
					"element":"input",
					"data":{
						"type":"number",
						"attr":{
							"change":"fileselect,skybox",
							"max":7,
							"min":0
						}
					}
				}
			]
		},
		{
			"element":"div",
			"data":{
				"class":"panelgroup",
				"attr":{
					"name":"Color"
				}
			},
			"children":[
				{
					"element":"span",
					"data":{
						"class":"grouptitle",
						"html":"Background"
					}
				},
				{
					"element":"input",
					"data":{
						"type":"text",
						"class":"colorpick",
						"attr":{
							"change":"fileselect,maincolor",
							"spectrum":"fileselect"
						}
					}
				},
				{
					"element":"span",
					"data":{
						"class":"grouptitle",
						"html":"Button"
					}
				},
				{
					"element":"input",
					"data":{
						"type":"text",
						"class":"colorpick",
						"attr":{
							"change":"fileselect,buttoncolor",
							"spectrum":"fileselect"
						}
					}
				},
				{
					"element":"span",
					"data":{
						"class":"grouptitle",
						"html":"Title Text"
					}
				},
				{
					"element":"input",
					"data":{
						"type":"text",
						"class":"colorpick",
						"attr":{
							"change":"fileselect,titlecolor",
							"spectrum":"fileselect"
						}
					}
				},
				{
					"element":"span",
					"data":{
						"class":"grouptitle",
						"html":"A*B Help Text"
					}
				},
				{
					"element":"input",
					"data":{
						"type":"text",
						"class":"colorpick",
						"attr":{
							"change":"fileselect,abhelpcolor",
							"spectrum":"fileselect"
						}
					}
				},
				{
					"element":"span",
					"data":{
						"class":"grouptitle",
						"html":"File Name Text"
					}
				},
				{
					"element":"input",
					"data":{
						"type":"text",
						"class":"colorpick",
						"attr":{
							"change":"fileselect,namecolor",
							"spectrum":"fileselect"
						}
					}
				}
			]
		},
		{
			"element":"input",
			"data":{	
				"type":"button",
				"attr":{
					"reset":"object",
					"value":"Reset File Select",
					"disabled":""
				}
			}
		},
		{
			"element":"span",
			"data":{	
				"class":"grouptext centered",
				"text":"This will reload the file select menu from the current .zdata file."
			}
		}
	]
}

$fileselecttools = {
	"element":"span",
	"data":{		
		"id":"fileselecttools",
		"attr":{
			"data-req":"fileselect,active/true"
		}
	},
	"children":[
		{
			"element":"input",
			"data":{
				"class":"panelgroup",
				"type":"checkbox",
				"id":"sbToggle",
				"attr":{
					"change":"fileselect,showSkybox"
				}
			}
		},
		{
			"element":"label",
			"data":{	
				"attr":{
					"for":"sbToggle",
					"title":"Toggle display Skybox"
				}
			},
			"children":[
				{
					"element":"span"
				},
				{
					"element":"span",
					"data":{	
						"text":"Display Skybox"
					}
				}
			]
		},
	]
}

function fileselectInit() {
	//Add fileselectLoop to the global update function
	updateCalls = (function() {
		var cached_function = updateCalls;
		return function() {
			cached_function();
			fileselectLoop();
		};
	}());
	//Add Elements to File Select
	$(".workspacetabs").append('<div class="workspacetab addontab">File Select</div>');
	$(".leftpanel").append("<div id='leftpanelfileselect' data-req='fileselect,active/true'/>");
	$("#leftpanelfileselect").append(createElements($lefttabfileselectpanel));
	$("#leftpanelfileselect").append('<div id="leftpanelfileselecttabgroup" class="tabgroup"/>');
	$("#leftpanelfileselecttabgroup").append(createElements($fileselectpanel));
	$(".screen").append("<div class='fileselect'/>");
	//Texture Test RGBA32
	$("#texturesPanel").append("<div id='fileselecttexturepanel' data-req='fileselect,active/true'/>");
	$("#fileselecttexturepanel").append('<div class="panelgroup inline-block" id="rgba32" name="RGBA32">');
	$("#rgba32").append('<input type="file" imgPath="fileselect,textures,rgba32" imgType="rgba32"/>');
	$("#rgba32").append('<br style="clear:both;">');
	//Texture Test RGB5A3
	$("#texturesPanel").append("<div id='fileselecttexturepanel' data-req='fileselect,active/true'/>");
	$("#fileselecttexturepanel").append('<div class="panelgroup inline-block" id="rgb5a3" name="RGB5A3">');
	$("#rgb5a3").append('<input type="file" imgPath="fileselect,textures,rgb5a3" imgType="rgb5a3"/>');
	$("#rgb5a3").append('<br style="clear:both;">');
	$("#rgb5a3").append('<span class="warning">The Alpha Channel is used to determine the grayscale color.');
	//Texture Test I8
	$("#texturesPanel").append("<div id='fileselecttexturepanel' data-req='fileselect,active/true'/>");
	$("#fileselecttexturepanel").append('<div class="panelgroup inline-block" id="i8" name="I8">');
	$("#i8").append('<input type="file" imgPath="fileselect,textures,i8" imgType="i8"/>');
	$("#i8").append('<br style="clear:both;">');
	$("#i8").append('<span class="warning">The Alpha Channel is used to determine the grayscale color.</span>');
	//Texture Test I4
	$("#texturesPanel").append("<div id='fileselecttexturepanel' data-req='fileselect,active/true'/>");
	$("#fileselecttexturepanel").append('<div class="panelgroup inline-block" id="i4" name="I4">');
	$("#i4").append('<input type="file" imgPath="fileselect,textures,i4" imgType="i4"/>');
	$("#i4").append('<br style="clear:both;">');
	$("#i4").append('<span class="warning">The Alpha Channel is used to determine the grayscale color.</span>');
	//Texture Test IA4
	$("#texturesPanel").append("<div id='fileselecttexturepanel' data-req='fileselect,active/true'/>");
	$("#fileselecttexturepanel").append('<div class="panelgroup inline-block" id="ia4" name="IA4">');
	$("#ia4").append('<input type="file" imgPath="fileselect,textures,ia4" imgType="ia4"/>');
	$("#ia4").append('<br style="clear:both;">');
	$("#ia4").append('<span class="warning">The Alpha Channel is used to determine the grayscale color.</span>');
	//Texture Test IA8
	$("#texturesPanel").append("<div id='fileselecttexturepanel' data-req='fileselect,active/true'/>");
	$("#fileselecttexturepanel").append('<div class="panelgroup inline-block" id="ia8" name="IA8">');
	$("#ia8").append('<input type="file" imgPath="fileselect,textures,ia8" imgType="ia8"/>');
	$("#ia8").append('<br style="clear:both;">');
	$("#ia8").append('<span class="warning">The Alpha Channel is used to determine the grayscale color.</span>');
	//Hide Specific Elements when in File Select
	$("#leftpanelmenu").attr("data-req","fileselect,active/false");
	$("#menutools").attr("data-req","fileselect,active/false");
	//Create File Select Toolbar
	$(".toolbar").append(createElements($fileselecttools));
	//Create File Select Spectrum
	spectrums.fileselect = new $.extend({}, spectrumDefault, {
		palette: [
			["#FFFFFF"],
			["#6496FF"],
			["#64FFFF"],
		]
	});
	//Set Up Default Values for File Select
	$defaultSetup.fileselect = {
		"active":false,
		"showSkybox":true,
		"skybox":3,
		"filename":"CloudMax",
		"maincolor":{"r":0x64,"g":0x96,"b":0xFF},
		"titlecolor":{"r":0xFF,"g":0xFF,"b":0xFF},
		"buttoncolor":{"r":0x64,"g":0x96,"b":0xFF},
		"abhelpcolor":{"r":0x64,"g":0xFF,"b":0xFF},
		"namecolor":{"r":0xFF,"g":0xFF,"b":0xFF},
		"cursorcolor":{"r":0x9B,"g":0xFF,"b":0xFF,"a":0xC8/0xFF}, //0xC8 0x46
		"textures":{
			"background":getObjFromPath($imageresources, "fileselect/background".split("/")),
			"buttonhelp":getObjFromPath($imageresources, "fileselect/buttonhelp".split("/")),
			"namepanel":getObjFromPath($imageresources, "fileselect/namepanel".split("/")),
			"fileconnection":getObjFromPath($imageresources, "fileselect/fileconnection".split("/")),
			"titles":{
				"selectfile":getObjFromPath($imageresources, "fileselect/titles/selectfile".split("/"))
			},
			"buttons":{
				"file1":getObjFromPath($imageresources, "fileselect/buttons/file1".split("/")),
				"file2":getObjFromPath($imageresources, "fileselect/buttons/file2".split("/")),
				"file3":getObjFromPath($imageresources, "fileselect/buttons/file3".split("/")),
				"options":getObjFromPath($imageresources, "fileselect/buttons/options".split("/")),
				"copy":getObjFromPath($imageresources, "fileselect/buttons/copy".split("/")),
				"erase":getObjFromPath($imageresources, "fileselect/buttons/erase".split("/"))
			},
			"cursors":{
				"large":getObjFromPath($imageresources, "fileselect/cursors/large".split("/"))
			},
			"skyboxes":[
				$src.textures[0]+$src.skyboxes+"0.png",
				$src.textures[0]+$src.skyboxes+"1.png",
				$src.textures[0]+$src.skyboxes+"2.png",
				$src.textures[0]+$src.skyboxes+"3.png",
				$src.textures[0]+$src.skyboxes+"4.png",
				$src.textures[0]+$src.skyboxes+"5.png",
				$src.textures[0]+$src.skyboxes+"6.png",
				$src.textures[0]+$src.skyboxes+"7.png"
			]
		}
	};
}
/*

$editor.fileselect.textures.background = "resources/source/File%20Select%20Textures/file%20menu.png"

FFA2

94px align

Scale: 103%

*/
function fileselectLoop() {
	if ($editor.settings.menu==5) {
		if ($editor.fileselect.active != true) {
			$editor.fileselect.active = true;
			$(".pausescreen").hide();
			$(".fileselect").show();
			$("[data-req]").each(function(ie, element) {
				dataReq(ie, element);
			});
		}
		//Update Element
		function updateElement(selector,color,background,size,offset,req) {
			var color = color;
			if (color) {
				var newcolor = color;
				if (!newcolor.a) newcolor.a = 1;
				var newcolorString = (pad(newcolor.r.toString(16),2)+pad(newcolor.g.toString(16),2)+pad(newcolor.b.toString(16),2)+pad(Math.round(newcolor.a*0xFF).toString(16),2)).toUpperCase();
			}
			var background = background;
			var element = $("."+selector+"");
			if (element.length <= 0) {
				$(".fileselect").append("<div class='"+selector+"'/>");
				var element = $("."+selector);
				element.css({
					"left":160+offset[0],
					"top":120+offset[1],
					"width":size[0],
					"height":size[1],
					"position":"absolute",
					"display":"inline-block",
					"background":"no-repeat center",
					"background-size":"100% 100%"
				});
			}
			element.attr("data-req",req);
			if (element.is(":not([bgpath='"+background+"'])")) {
				element.css("background-image","url("+background+")");
				element.attr("bgpath",background);
				element.removeAttr("tint");
			}
			if (newcolor) {
				if (element.is(":not([tint='"+newcolorString+"'])")) {
					if (!$editor.cache.textures[background]) {			
						$editor.cache.textures[background] = {};
					}
					if (!$editor.cache.textures[background][newcolorString]) {
						$editor.cache.textures[background][newcolorString] = [];
					}
					var textureid = 0;
					if (!$editor.cache.textures[background][newcolorString][textureid]) {
						$editor.cache.textures[background][newcolorString][textureid] = multiplyColor(background, newcolor);
					}
					if ($editor.cache.textures[background][newcolorString][textureid]) {
						element.css("background-image","url("+$editor.cache.textures[background][newcolorString][textureid]+")");
						element.attr("tint",newcolorString);
					}			
				}
			}
		
		}

		//Scale
		var scale = ((320*0.78)/240);
		
		//Update File Connection
		var selector = "fileSelectSkybox";
		var color = undefined;
		var background = $editor.fileselect.textures.skyboxes[$editor.fileselect.skybox];
		var size = [320,240];
		var offset = [-160,-120];
		var req = "fileselect,showSkybox/true";
		updateElement(selector,color,background,size,offset,req)
		
		//Update Background
		var selector = "fileSelectBG";
		var color = $editor.fileselect.maincolor;
		var background = $editor.fileselect.textures.background;
		var size = [240*scale,160*scale];
		var offset = [-123,-82]
		updateElement(selector,color,background,size,offset)
		
		//Update Button Help Text
		var selector = "fileSelectButtonHelp";
		var color = $editor.fileselect.abhelpcolor;
		var background = $editor.fileselect.textures.buttonhelp;
		var size = [144,16];
		var offset = [-70,84];
		updateElement(selector,color,background,size,offset)
		
		//Update Title
		var selector = "fileSelectTitle";
		var color = $editor.fileselect.titlecolor;
		var background = $editor.fileselect.textures.titles.selectfile;
		var size = [128*scale,16*scale];
		var offset = [-96,-74];
		updateElement(selector,color,background,size,offset)
		
		//Update File Buttons
		for (var i=0;i<3;i++) { 
			var selector = "fileSelectFile"+(i+1);
			var color = $editor.fileselect.buttoncolor;
			var background = $editor.fileselect.textures.buttons["file"+(i+1)];
			var size = [64*scale,16*scale];
			var offset = [-103,-44+i*16*scale];
			updateElement(selector,color,background,size,offset)
		}
		
		//Update File Name Panel
		var selector = "fileSelectFileName1";
		var color = $editor.fileselect.buttoncolor;
		var background = $editor.fileselect.textures.namepanel;
		var size = [108*scale,16*scale];
		var offset = [-36,-44+0*16*scale];
		updateElement(selector,color,background,size,offset)
		
		//Update File Connection
		var selector = "fileSelectFileConnection1";
		var color = $editor.fileselect.buttoncolor;
		var background = $editor.fileselect.textures.fileconnection;
		var size = [24*scale,16*scale];
		var offset = [-49,-44+0*16*scale];
		updateElement(selector,color,background,size,offset)
		
		//Copy Button
		var selector = "fileSelectCopyButton";
		var color = $editor.fileselect.buttoncolor;
		var background = $editor.fileselect.textures.buttons["copy"];
		var size = [64*scale,16*scale];
		var offset = [-103,13*scale];
		updateElement(selector,color,background,size,offset)
		
		//Erase Button
		var selector = "fileSelectEraseButton";
		var color = $editor.fileselect.buttoncolor;
		var background = $editor.fileselect.textures.buttons["erase"];
		var size = [64*scale,16*scale];
		var offset = [-103,29*scale];
		updateElement(selector,color,background,size,offset)
		
		//Options Button
		var selector = "fileSelectOptionsButton";
		var color = $editor.fileselect.buttoncolor;
		var background = $editor.fileselect.textures.buttons["options"];
		var size = [64*scale,16*scale];
		var offset = [-103,52*scale];
		updateElement(selector,color,background,size,offset)
		
		//File 1 Name
		$editor.fileselect.filename = $editor.fileselect.filename.substring(0, 8);
		for (var i in $editor.fileselect.filename) {
			var selector = "fileSelectFile1Letter"+i;
			var color = $editor.fileselect.namecolor;
			var background = $imageresources.letters[$editor.fileselect.filename.charCodeAt(i)];
			var size = [14,14];
			var offset = [(-24+i*10)*scale,-44+0*16*scale];
			updateElement(selector,color,background,size,offset)
		}
		while (i < 7) {
			i++;
			$(".fileSelectFile1Letter"+i).remove();
		}
		
		//Cursor
		var selector = "fileSelectCursor";
		var color = $editor.fileselect.cursorcolor;
		var background = $editor.fileselect.textures.cursors["large"];
		var size = [72*scale,24*scale];
		var offset = [-107,-48+0*16*scale];
		updateElement(selector,color,background,size,offset)
		
	} else {
		if ($editor.fileselect.active) {
			$editor.fileselect.active = false;
			$(".fileselect").hide();
			$("[data-req]").each(function(ie, element) {
				dataReq(ie, element);
			});
		}
	}
}

$(document).on('change', "[type=file][imgPath]", function(e){
	//var backgroundid = parseInt($(this).attr("texture"));
	var path = $(this).attr("imgPath");
	var type = $(this).attr("imgType");
	var files = e.target.files; // FileList object
	$.each(files, function(i, f){
			var reader = new FileReader();
			reader.onload = (function(theFile) {
				return function(e) {
					console.log(e.srcElement.result);
					setObjFromPath($editor, path.split(","), e.srcElement.result);
					if (type == "rgba32") {
						imgToRGBA32(e.srcElement.result);
					} else if (type == "i8") {
						imgToI8(e.srcElement.result);
					} else if (type == "i4") {
						imgToI4(e.srcElement.result);
					} else if (type == "ia4") {
						imgToIA4(e.srcElement.result);
					} else if (type == "ia8") {
						imgToIA8(e.srcElement.result);
					} else if (type == "rgb5a3") {
						imgToRGB5A3(e.srcElement.result);
					}
					//$editor.settings.backgroundpaths[backgroundid] = e.srcElement.result;
				};
			})(f);
			var blob = f;
			reader.readAsDataURL(blob);
		});
		return false;
});

