function loadTexturesFromTableData() {
	$textures = {
		"icon_item_static":{
			/*
			0x00000 to 0x5A000 is the 90 item icons. size:32x32 format: rgba32
			Added by a loop below.
			*/
			0x5A000:{size:[48,48],format:"ia4",name:"Heart Piece 1/4",category:"Items"},
			0x5A900:{size:[48,48],format:"ia4",name:"Heart Piece 2/4",category:"Items"},
			0x5B200:{size:[48,48],format:"ia4",name:"Heart Piece 3/4",category:"Items"},
			0x875C0:{size:[24,16],format:"ia4",name:"A Button Symbol"},
			0x878C0:{size:[48,16],format:"ia4",name:"C Button Symbols"},
			0x87BC0:{size:[72,24],format:"ia4",name:"Title Panel Left"},
			0x88280:{size:[72,24],format:"ia4",name:"Title Panel Right"},
			0x88940:{size:[24,32],format:"ia4",name:"L Button"},
			0x88C40:{size:[24,32],format:"ia4",name:"R Button"},
			0x89440:{size:[16,24],format:"ia4",name:"Song Note",category:"Items"},
			0x5C3C0:{size:[80,32],format:"ia4",name:"Equipment 0,0"},
			//0x5C3C0:{size:[80,2208],format:"ia4",name:"backgroundtextures"},
			//0x00000:{size:[16,((0x89CA0-0x00000)/16)/2],format:"ia8",name:"title_static"},
		},
		"icon_item_24_static":{//COMPLETE
			0x0000:{size:[24,24],format:"rgba32",name:"Forest Medallion",category:"Items"},
			0x0900:{size:[24,24],format:"rgba32",name:"Fire Medallion",category:"Items"},
			0x1200:{size:[24,24],format:"rgba32",name:"Water Medallion",category:"Items"},
			0x1B00:{size:[24,24],format:"rgba32",name:"Spirit Medallion",category:"Items"},
			0x2400:{size:[24,24],format:"rgba32",name:"Shadow Medallion",category:"Items"},
			0x2D00:{size:[24,24],format:"rgba32",name:"Light Medallion",category:"Items"},
			0x3600:{size:[24,24],format:"rgba32",name:"Kokiri's Emerald",category:"Items"},
			0x3F00:{size:[24,24],format:"rgba32",name:"Goron's Ruby",category:"Items"},
			0x4800:{size:[24,24],format:"rgba32",name:"Zora's Sapphire",category:"Items"},
			0x5100:{size:[24,24],format:"rgba32",name:"Stone of Agony",category:"Items"},
			0x5A00:{size:[24,24],format:"rgba32",name:"Gerudo's Card",category:"Items"},
			0x6300:{size:[24,24],format:"rgba32",name:"Gold Skulltula",category:"Items"},
			0x6C00:{size:[24,24],format:"rgba32",name:"Heart Container",category:"Items"},
			0x7500:{size:[24,24],format:"rgba32",name:"Piece of Heart",category:"Items"},
			0x7E00:{size:[24,24],format:"rgba32",name:"Boss Key",category:"Items"},
			0x8700:{size:[24,24],format:"rgba32",name:"Compass",category:"Items"},
			0x9000:{size:[24,24],format:"rgba32",name:"Dungeon Map",category:"Items"},
			0x9900:{size:[24,24],format:"rgba32",name:"Small Key",category:"Items"},
			0xA200:{size:[24,24],format:"rgba32",name:"Small Magic Jar",category:"Items"},
			0xAB00:{size:[24,24],format:"rgba32",name:"Big Magic Jar",category:"Items"}
		},
		"icon_item_field_static":{
		},
		"icon_item_dungeon_static":{
			0x000:{size:[24,16],format:"ia4",name:"Blank Floor Button",category:"Menu"},
			0x180:{size:[24,16],format:"ia4",name:"1F Button",category:"Menu"},
			0x300:{size:[24,16],format:"ia4",name:"2F Button",category:"Menu"},
			0x480:{size:[24,16],format:"ia4",name:"3F Button",category:"Menu"},
			0x600:{size:[24,16],format:"ia4",name:"4F Button",category:"Menu"},
			0x780:{size:[24,16],format:"ia4",name:"5F Button",category:"Menu"},
			0x900:{size:[24,16],format:"ia4",name:"6F Button",category:"Menu"},
			0xA80:{size:[24,16],format:"ia4",name:"7F Button",category:"Menu"},
			0xC00:{size:[24,16],format:"ia4",name:"8F Button",category:"Menu"},
			0xD80:{size:[24,16],format:"ia4",name:"B1 Button",category:"Menu"},
			0xF00:{size:[24,16],format:"ia4",name:"B2 Button",category:"Menu"},
			0x1080:{size:[24,16],format:"ia4",name:"B3 Button",category:"Menu"},
			0x1200:{size:[24,16],format:"ia4",name:"B4 Button",category:"Menu"},
			0x1380:{size:[24,16],format:"ia4",name:"B5 Button",category:"Menu"},
			0x1500:{size:[24,16],format:"ia4",name:"B6 Button",category:"Menu"},
			0x1680:{size:[24,16],format:"ia4",name:"B7 Button",category:"Menu"},
			0x1800:{size:[24,16],format:"ia4",name:"B8 Button",category:"Menu"},
		},
		"icon_item_nes_static":{
		},
		"nes_font_static":{//COMPLETE
			/*
			The entire file contains 140 characters. size16x16 format: i4
			Added by a loop below.
			*/
		},
		"title_static":{
			0x00180:{size:[16,16],format:"ia4",name:"Forest Medallion"},
			0x00280:{size:[16,16],format:"ia4",name:"Fire Medallion"},
			0x00380:{size:[16,16],format:"ia4",name:"Water Medallion"},
			0x00480:{size:[16,16],format:"ia4",name:"Spirit Medallion"},
			0x00580:{size:[16,16],format:"ia4",name:"Shadow Medallion"},
			0x00680:{size:[16,16],format:"ia4",name:"Light Medallion"},
			0x00780:{size:[64,32],format:"ia8",name:"File Select Background Tile 0,0"},
			0x01780:{size:[64,32],format:"ia8",name:"File Select Background Tile 1,0"},
			0x02780:{size:[64,32],format:"ia8",name:"File Select Background Tile 2,0"},
			0x03780:{size:[48,32],format:"ia8",name:"File Select Background Tile 3,0"},
			0x04380:{size:[64,32],format:"ia8",name:"File Select Background Tile 0,1"},
			0x05380:{size:[64,32],format:"ia8",name:"File Select Background Tile 1,1"},
			0x06380:{size:[64,32],format:"ia8",name:"File Select Background Tile 2,1"},
			0x07380:{size:[48,32],format:"ia8",name:"File Select Background Tile 3,1"},
			0x07F80:{size:[64,32],format:"ia8",name:"File Select Background Tile 0,2"},
			0x08F80:{size:[64,32],format:"ia8",name:"File Select Background Tile 1,2"},
			0x09F80:{size:[64,32],format:"ia8",name:"File Select Background Tile 2,2"},
			0x0AF80:{size:[48,32],format:"ia8",name:"File Select Background Tile 3,2"},
			0x0BB80:{size:[64,32],format:"ia8",name:"File Select Background Tile 0,3"},
			0x0CB80:{size:[64,32],format:"ia8",name:"File Select Background Tile 1,3"},
			0x0DB80:{size:[64,32],format:"ia8",name:"File Select Background Tile 2,3"},
			0x0EB80:{size:[48,32],format:"ia8",name:"File Select Background Tile 3,3"},
			0x0F780:{size:[64,32],format:"ia8",name:"File Select Background Tile 0,4"},
			0x10780:{size:[64,32],format:"ia8",name:"File Select Background Tile 1,4"},
			0x11780:{size:[64,32],format:"ia8",name:"File Select Background Tile 2,4"},
			0x12780:{size:[48,32],format:"ia8",name:"File Select Background Tile 3,4"},
			0x15600:{size:[108,16],format:"ia8",name:"File Name Background"},
			0x1B680:{size:[72,24],format:"i8",name:"Big Button Highlight"},
			0x1BF80:{size:[56,24],format:"i8",name:"Medium Button Highlight"},
			0x1C4C0:{size:[40,24],format:"i8",name:"Small Button Highlight"},
			0x1C880:{size:[16,16],format:"rgba32",name:"Kokiri's Emerald"},
			0x1CC80:{size:[16,16],format:"rgba32",name:"Goron's Ruby"},
			0x1D080:{size:[16,16],format:"rgba32",name:"Zora's Sapphire"},
			0x35A00:{size:[64,16],format:"ia8",name:"Copy Button"},
			0x36200:{size:[64,16],format:"ia8",name:"Kopieren Button"},
			0x36A00:{size:[64,16],format:"ia8",name:"Copier Button"},
			0x37200:{size:[64,16],format:"ia8",name:"File 1 Button"},
			0x37A00:{size:[64,16],format:"ia8",name:"File 2 Button"},
			0x38200:{size:[64,16],format:"ia8",name:"File 3 Button"},
			0x38A00:{size:[64,16],format:"ia8",name:"Datei 1 Button"},
			0x39200:{size:[64,16],format:"ia8",name:"Datei 2 Button"},
			0x39A00:{size:[64,16],format:"ia8",name:"Datei 3 Button"},
			0x3A200:{size:[64,16],format:"ia8",name:"Fichier 1 Button"},
			0x3AA00:{size:[64,16],format:"ia8",name:"Fichier 2 Button"},
			0x3B200:{size:[64,16],format:"ia8",name:"Fichier 3 Button"},
			0x3BA00:{size:[64,16],format:"ia8",name:"Yes Button"},
			0x3C200:{size:[64,16],format:"ia8",name:"Ja Button"},
			0x3CA00:{size:[64,16],format:"ia8",name:"Oui Button"},
			0x3D200:{size:[64,16],format:"ia8",name:"Erase Button"},
			0x3DA00:{size:[64,16],format:"ia8",name:"Löschen Button"},
			0x3E200:{size:[64,16],format:"ia8",name:"Effacer Button"},
			0x3EA00:{size:[64,16],format:"ia8",name:"Quit Button"},
			0x3F200:{size:[64,16],format:"ia8",name:"Zurück Button"},
			0x3FA00:{size:[64,16],format:"ia8",name:"Retour Button"},
			0x45E00:{size:[64,16],format:"ia8",name:"Options Button"},
			0x46600:{size:[64,16],format:"ia8",name:"Optionen Button"},
			0x16380:{size:[36,56],format:"ia8",name:"File Select File Background Tile 1"},
			0x17340:{size:[36,56],format:"ia8",name:"File Select File Background Tile 2"},
			0x18300:{size:[36,56],format:"ia8",name:"File Select File Background Tile 3"},
			0x192C0:{size:[36,56],format:"ia8",name:"File Select File Background Tile 4"},
			0x1A280:{size:[24,56],format:"ia8",name:"File Select File Background Tile 5"},
			//0x40200:{size:[16*3,200],format:"ia4",name:"Options"},
			//0x02600:{size:[72,((0x47440-0x02600)/72)/2],format:"ia8",name:"title_static"},
		},
		"parameter_static":{
			0x0000:{size:[16,16],format:"ia4",name:"0/4 Heart",category:"UI"},
			0x0100:{size:[16,16],format:"ia4",name:"1/4 Heart",category:"UI"},
			0x0200:{size:[16,16],format:"ia4",name:"2/4 Heart",category:"UI"},
			0x0300:{size:[16,16],format:"ia4",name:"3/4 Heart",category:"UI"},
			0x0400:{size:[16,16],format:"ia4",name:"4/4 Heart",category:"UI"},
			0x0500:{size:[16,16],format:"ia4",name:"0/4 Heart (Double Defense)",category:"UI"},
			0x0600:{size:[16,16],format:"ia4",name:"1/4 Heart (Double Defense)",category:"UI"},
			0x0700:{size:[16,16],format:"ia4",name:"2/4 Heart (Double Defense)",category:"UI"},
			0x0800:{size:[16,16],format:"ia4",name:"3/4 Heart (Double Defense)",category:"UI"},
			0x0900:{size:[16,16],format:"ia4",name:"4/4 Heart (Double Defense)",category:"UI"},
			0x0A00:{size:[32,32],format:"ia4",name:"Action Button",category:"UI"},
			0x0E00:{size:[32,32],format:"ia4",name:"Equipped Item Border",category:"Menu"},
			0x1200:{size:[32,32],format:"ia4",name:"Empty C-Left Button Arrow",category:"UI"},
			0x1600:{size:[32,32],format:"ia4",name:"Empty C-Down Button Arrow",category:"UI"},
			0x1A00:{size:[32,32],format:"ia4",name:"Empty C-Right Button Arrow",category:"UI"},
			0x1E00:{size:[16,16],format:"ia4",name:"Small Key",category:"UI"},
			0x1F00:{size:[16,16],format:"ia4",name:"Rupee",category:"UI"},
			0x2000:{size:[16,16],format:"ia4",name:"Clock",category:"UI"},
			0x2100:{size:[16,16],format:"rgba32",name:"Carrot",category:"UI"},
			0x2500:{size:[8,8],format:"rgb5a1",name:"Minimap Dungeon Entrance",category:"UI"},
			0x2580:{size:[8,8],format:"rgb5a1",name:"Minimap Chest",category:"UI"},
			//0x2680 to 0x2900 (0x280 bytes) are unknown
			0x2900:{size:[8,8],format:"ia4",name:"Minimap Boss Skull",category:"UI"},
			0x2940:{size:[16,16],format:"ia4",name:"Ocarina A Button",category:"UI"},
			0x2A40:{size:[16,16],format:"ia4",name:"Ocarina C-Down Button",category:"UI"},
			0x2B40:{size:[16,16],format:"ia4",name:"Ocarina C-Right Button",category:"UI"},
			0x2C40:{size:[16,16],format:"ia4",name:"Ocarina C-Left Button",category:"UI"},
			0x2D40:{size:[16,16],format:"ia4",name:"Ocarina C-Up Button",category:"UI"},
			0x2E40:{size:[16,32],format:"i4",name:"Ocarina Clef",category:"UI"},
			//0x2F40 to 0x3040 (0x100 bytes) are unknown
			//Counter basically means that the texture is used for value displays such as rupee, clock and skulltula amount.
			0x3040:{size:[8,16],format:"i8",name:"Counter Digit 0",category:"UI"},
			0x30C0:{size:[8,16],format:"i8",name:"Counter Digit 1",category:"UI"},
			0x3140:{size:[8,16],format:"i8",name:"Counter Digit 2",category:"UI"},
			0x31C0:{size:[8,16],format:"i8",name:"Counter Digit 3",category:"UI"},
			0x3240:{size:[8,16],format:"i8",name:"Counter Digit 4",category:"UI"},
			0x32C0:{size:[8,16],format:"i8",name:"Counter Digit 5",category:"UI"},
			0x3340:{size:[8,16],format:"i8",name:"Counter Digit 6",category:"UI"},
			0x33C0:{size:[8,16],format:"i8",name:"Counter Digit 7",category:"UI"},
			0x3440:{size:[8,16],format:"i8",name:"Counter Digit 8",category:"UI"},
			0x34C0:{size:[8,16],format:"i8",name:"Counter Digit 9",category:"UI"},
			0x3540:{size:[8,16],format:"i8",name:"Counter Colon",category:"UI"},
			0x35C0:{size:[8,8],format:"ia4",name:"Item Amount Digit 0",category:"UI"},
			0x3600:{size:[8,8],format:"ia4",name:"Item Amount Digit 1",category:"UI"},
			0x3640:{size:[8,8],format:"ia4",name:"Item Amount Digit 2",category:"UI"},
			0x3680:{size:[8,8],format:"ia4",name:"Item Amount Digit 3",category:"UI"},
			0x36C0:{size:[8,8],format:"ia4",name:"Item Amount Digit 4",category:"UI"},
			0x3700:{size:[8,8],format:"ia4",name:"Item Amount Digit 5",category:"UI"},
			0x3740:{size:[8,8],format:"ia4",name:"Item Amount Digit 6",category:"UI"},
			0x3780:{size:[8,8],format:"ia4",name:"Item Amount Digit 7",category:"UI"},
			0x37C0:{size:[8,8],format:"ia4",name:"Item Amount Digit 8",category:"UI"},
			0x3800:{size:[8,8],format:"ia4",name:"Item Amount Digit 9",category:"UI"},
			0x3840:{size:[16,8],format:"ia4",name:"1/2 (Beta Double Magic Meter?)",category:"Other"},
			0x38C0:{size:[8,16],format:"ia4",name:"Magic Meter Side",category:"UI"},
			0x3940:{size:[24,16],format:"ia4",name:"Magic Meter Middle",category:"UI"},
			0x3AC0:{size:[8,8],format:"ia4",name:"Magic Meter Fill",category:"UI"},
			//0x2940:{size:[16,((0x3B00-0x2940)/16)],format:"ia4",name:"Unknown"},
			//0x0200:{size:[16,((0x3B00-0x0200)/16)],format:"ia4",name:"parameter_static"},
		},
	}
	
	var backgroundTiles = [
		"Equipment 0,0",
		"Equipment 2,0",
		"Map 0,0",
		"Map 2,0",
		"UNUSED Quest Status 0,0",
		"UNUSED Quest Status 2,0",
		"Save 0,0",
		"Save 2,0",
		"Equipment 0,1",
		"Equipment 1,1",
		"Equipment 2,1",
		"Select Item 0,1",
		"Select Item 1,1",
		"Select Item 2,1",
		"Map 0,1",
		"Map 1,1",
		"Map 2,1",
		"Quest Status 0,1",
		"Quest Status 1,1",
		"Quest Status 2,1",
		"Save 0,1",
		"Save 1,1",
		"Save 2,1",
		"Equipment 0,2",
		"Equipment 1,2",
		"Equipment 2,2",
		"Select Item 0,2",
		"Select Item 1,2",
		"Select Item 2,2",
		"Map 0,2",
		"Map 1,2",
		"Map 2,2",
		"Quest Status 0,2",
		"Quest Status 1,2",
		"Quest Status 2,2",
		"Save 0,2",
		"Save 1,2",
		"Save 2,2",
		"Equipment 0,3",
		"Equipment 1,3",
		"Equipment 2,3",
		"Select Item 0,3",
		"Select Item 1,3",
		"Select Item 2,3",
		"Map 0,3",
		"Map 1,3",
		"Map 2,3",
		"Quest Status 0,3",
		"Quest Status 1,3",
		"Quest Status 2,3",
		"Save 0,3",
		"Save 1,3",
		"Save 2,3",
		"Equipment 0,4",
		"Equipment 1,4",
		"Equipment 2,4",
		"Select Item 0,4",
		"Select Item 1,4",
		"Select Item 2,4",
		"Map 0,4",
		"Map 1,4",
		"Map 2,4",
		"Quest Status 0,4",
		"Quest Status 1,4",
		"Quest Status 2,4",
		"Save 0,4",
		"Save 1,4",
		"Save 2,4",
	];
	
	var backgroundTilesLoc = [
		"Equipment 1,0",
		"Select Item 0,0",
		"Select Item 1,0",
		"Select Item 2,0",
		"Map 1,0",
		"Quest Status 0,0",
		"Quest Status 1,0",
		"Quest Status 2,0",
		"Save 1,0",
	];
	
	for (var i=0;i<backgroundTiles.length;i++) {
		$textures["icon_item_static"][0x5C3C0+0xA00*i] = {size:[80,32],format:"ia4",name:backgroundTiles[i]};
	}

	for (var i=0;i<backgroundTilesLoc.length;i++) {
		$textures["icon_item_nes_static"][0x8280+0xA00*i] = {size:[80,32],format:"ia4",name:backgroundTilesLoc[i]};
	}
	
	for (var i=0;i<90;i++) {
		$textures["icon_item_static"][0x1000*i] = {size:[32,32],format:"rgba32",name:"Item "+i};
	}
	
	for (var i=0;i<140;i++) {
		$textures["nes_font_static"][128*i] = {size:[16,16],format:"i4",name:"Character "+i};
	}
	/*
	NOTE TEXTURES:
	Each texture is 0x100 bytes. since they're 16x16 that means it must be a 8bit/pixel format. The only formats it can be is I8 and IA4. The texture appears to have a separate alpha channel, so it should be IA4.

	Texture offset for C-Down Note: 02002A40 
	Texture offset for Number 0: 02003040
	Distance between textures is 0x600
	
	FILE SELECT BG TEXTURES:
	64x32
	*/

	//176640
			/*
			0x:{size:[,],format:"",name:""},
			*/
	/*
007EF980	16x16	rgb5a3	Link Head (Used on map subscreen to determine which floor you're on)
007EFB80	???		???		???
...
...
007F7C00	56x16	ia4		"to Equip"
007F7F80	64x16	ia4		"to Decide"
007F8380	???		???		???
...
007F8880	128x16	ia4		"To Select Item"
007F9080	128x16	ia4		"To Map"
007F9880	128x16	ia4		"To Quest Status"
007FA080	128x16	ia4		"To Equipment"
007FA880	152x16	ia4		"Would you like to save?"
007FBB80	48x16	ia4		"Yes"
007FBE80	48x16	ia4		"No"
*/	
	var texturelist = $(".texturelist");
	texturelist.empty();
	var textureFiles = [];
	$.each($textures, function(name, files){
		var texturesublist = $('<div data-req="settings,texturefile/'+name+'" />').appendTo(texturelist);
		$.each(files, function(offset, file){
			//console.log(name+" 0x"+pad(parseInt(offset).toString(16).toUpperCase(),6));
			//console.log(file);
			var texture = baseToImg(file.format, {"name":name,"offset":parseInt(offset)}, file.size);
			file.texture = texture;
			//console.log(texture);
			var scale = file.size[0]<=24&&file.size[1]<=24?1.5:1;
			texturesublist.append('<div class="texturelistItem" texture-offset="'+offset+'" texture-file="'+name+'"><div class="texturelistItemPreview"><img src="'+file.texture+'"/></div><div class="texturelistItemInfo"><div>'+file.name+'</div><div>'+file.size[0]+"x"+file.size[1]+' '+file.format+'</div><div>0x'+pad(parseInt(offset).toString(16).toUpperCase(),6)+'</div><div>'+name+'</div></div></div>');
		});
		if (Object.getOwnPropertyNames(files).length > 0) {
			textureFiles.push({"value":name,"text":name});
		}
	});
	var ignoreDrag = function(e) {
		var event = typeof e.originalEvent != 'undefined' ? e.originalEvent : e;
		if (event.stopPropagation) {
			event.stopPropagation();
		}
		if (event.preventDefault) {
			event.preventDefault();
		}
	};
	$('.texturelistItem, #selectedTextureBox').bind('dragover', ignoreDrag).bind('dragenter', ignoreDrag).bind('drop', function(e){
		e = (e&&e.originalEvent?e.originalEvent:window.event) || e;
		ignoreDrag(e);
		if (!$(this).attr("texture-file") || !$(this).attr("texture-offset")) return;
		//
		var item = $(this);
		var img = $(this).find("img");
		var texturefile = item.attr("texture-file");
		var textureoffset = parseInt(item.attr("texture-offset"));
		var texture = $textures[texturefile][textureoffset];
		var format = texture.format;

		var files = (e.files||e.dataTransfer.files);
		$.each(files, function(i, f){
			var reader = new FileReader();
			reader.onload = (function(theFile) {
				return function(e) {
					var imgcheck = new Image();
					imgcheck.src = e.srcElement.result;
					if (imgcheck.width == texture.size[0] && imgcheck.height == texture.size[1]) {
						if (format == "rgba32") {
							var newtexture = imgToRGBA32(e.srcElement.result);
							//console.log(format);
						} else if (format == "i8") {
							var newtexture = imgToI8(e.srcElement.result);
						} else if (format == "i4") {
							var newtexture = imgToI4(e.srcElement.result);
						} else if (format == "ia4") {
							var newtexture = imgToIA4(e.srcElement.result);
						} else if (format == "ia8") {
							var newtexture = imgToIA8(e.srcElement.result);
						} else if (format == "rgb5a3") {
							var newtexture = imgToRGB5A3(e.srcElement.result);
						}
						for (var i=0;i<newtexture.length/2;i++) {
							setFileData(texturefile, "uint8", textureoffset+i, parseInt(newtexture.substring(i*2,i*2+2),16), (i==0?{type:"texture",data:{format:format,size:texture.size,name:texture.name}}:false));
						}
						texture.texture = baseToImg(format, {"name":texturefile,"offset":textureoffset}, texture.size);
						//texture.texture = e.srcElement.result;
						//img.attr("src",texture.texture);
						$("[texture-file="+texturefile+"][texture-offset="+textureoffset+"]").find("img").attr("src",texture.texture);
						$.each($editor.menu, function(i,menu) {
							if (menu.object) {
								var objects = menu.object.filter(function (object) { return (object.texture.file == texturefile && object.texture.offset == textureoffset) });
								$.each(objects, function (i,o){
									o.texture.refresh = true;
								});
							}
							if (menu.background) {
								var objects = [];
								for (var i=0;i<3;i++) {
									$.each(menu.background[i], function (index,obj){
										objects.push(obj);
									});
								}
								//console.log(objects);
								objects = objects.filter(function (object) { return (object.file == texturefile && object.offset == textureoffset) });
								$.each(objects, function (i,o){
									o.refresh = true;
								});
							}
						});
					} else {
						alert("The dimensions of the provided texture was not "+texture.size[0]+"x"+texture.size[1]);
						console.log("Incorrect Dimensions");
					}
				};
			})(f);
			var blob = f;
			reader.readAsDataURL(blob);
		});
		return false;
	});
	$("#textureFileList").heapbox("set",JSON.stringify(textureFiles));
}

/********************************
GAME TO IMAGE
********************************/

function baseToImg(format, file, size) {
	var canvas = document.createElement('canvas');
	var ctx = canvas.getContext('2d');
	canvas.width = size[0];
	canvas.height = size[1];
	var imgPixels = ctx.getImageData(0, 0, canvas.width, canvas.height);
	if (format == "ia4") {
		for (var i=0;i<size[0]*size[1];i++) {
			var pixel = $editor.files.loaded[file.name].getUint8(file.offset+i);
			var color = ((pixel&0xF0)>>4)*0x11;
			var alpha = (pixel&0x0F)*0x11;
			imgPixels.data[i*4+0] = color;
			imgPixels.data[i*4+1] = color;
			imgPixels.data[i*4+2] = color;
			imgPixels.data[i*4+3] = alpha;
		}
	} else if (format == "rgba32") {
		for (var i=0;i<size[0]*size[1]*4;i++) {
			var pixel = $editor.files.loaded[file.name].getUint8(file.offset+i);
			imgPixels.data[i] = pixel;
		}
		//console.log(imgPixels.data);
	} else if (format == "i4") {
		for ( var i=0;i<(size[0]*size[1]);i++) {
			var pixel = $editor.files.loaded[file.name].getUint8(file.offset+Math.floor(i/2));
			if (Math.floor(i/2) == i/2) {
				var color = ((pixel&0xF0)>>4)*0x11;
			} else {
				var color = (pixel&0x0F)*0x11;
			}
			imgPixels.data[i*4+0] = color;
			imgPixels.data[i*4+1] = color;
			imgPixels.data[i*4+2] = color;
			imgPixels.data[i*4+3] = color;
		}
	} else if (format == "i8") {
		for (var i=0;i<size[0]*size[1];i++) {
			var pixel = $editor.files.loaded[file.name].getUint8(file.offset+i);
			imgPixels.data[i*4+0] = pixel;
			imgPixels.data[i*4+1] = pixel;
			imgPixels.data[i*4+2] = pixel;
			imgPixels.data[i*4+3] = pixel;
		}
	} else if (format == "ia8") {
		for (var i=0;i<(size[0]*size[1]);i++) {
			var alpha = $editor.files.loaded[file.name].getUint8(file.offset+i*2+1);
			var color = $editor.files.loaded[file.name].getUint8(file.offset+i*2);
			imgPixels.data[i*4+0] = color;
			imgPixels.data[i*4+1] = color;
			imgPixels.data[i*4+2] = color;
			imgPixels.data[i*4+3] = alpha;
		}
	} else if (format == "rgb5a1") {
		for (var i=0;i<(size[0]*size[1]);i++) {
			var pixel = $editor.files.loaded[file.name].getUint16(file.offset+i*2);
			var red = ((pixel>>11)&0x1F)*0x8;
			var green = ((pixel>>6)&0x1F)*0x8;
			var blue = ((pixel>>1)&0x1F)*0x8;
			imgPixels.data[i*4+0] = red;
			imgPixels.data[i*4+1] = green;
			imgPixels.data[i*4+2] = blue;
			imgPixels.data[i*4+3] = ((pixel&0x01)==0x01?0xFF:0x00);
		}
	}
	ctx.putImageData(imgPixels, 0, 0, 0, 0, imgPixels.width, imgPixels.height);
	return canvas.toDataURL();
}

/********************************
IMAGE TO GAME
********************************/

function imgToBase(src) {
	var canvas = document.createElement('canvas');
	var ctx = canvas.getContext('2d');
	var imgObj = new Image();
	imgObj.src = src;
	if (!imgObj.width || !imgObj.height) {
		return false;
	}
	canvas.width = imgObj.width;
	canvas.height = imgObj.height; 
	ctx.drawImage(imgObj, 0, 0); 
	var imgPixels = ctx.getImageData(0, 0, canvas.width, canvas.height);
	console.log(imgPixels);
	return imgPixels;
}

//Title Screen Logo
//Carrot Icon
//
function imgToRGBA32(src){
	var imgPixels = imgToBase(src);
	if (imgPixels == false) {
		return false;
	}
	var result = "";
	$.each(imgPixels.data, function(i,v) {
		result += pad(v.toString(16).toUpperCase(),2);
	});
	console.log(result);
	return result;
}

//Letters and Numbers
//Navi Text
function imgToI4(src, alpha){
	var imgPixels = imgToBase(src);
	if (imgPixels == false) {
		return false;
	}
	if (alpha) {
		var start = 3;
	} else {
		var start = 0;
	}
	var result = "";
	for ( var i=start; i< imgPixels.data.length; i+=8) {
		var val = (Math.floor(imgPixels.data[i] / 0x11)<<4) + Math.floor(imgPixels.data[i+4] / 0x11);
		result += pad(val.toString(16).toUpperCase(),2);
	}
	console.log(result);
	return result;
}

function imgToI8(src, alpha){
	var imgPixels = imgToBase(src);
	if (imgPixels == false) {
		return false;
	}
	if (alpha) {
		var start = 3;
	} else {
		var start = 0;
	}
	var result = "";
	for ( var i=start; i< imgPixels.data.length; i+=4) {
		result += pad(imgPixels.data[i].toString(16).toUpperCase(),2);
	}
	console.log(result);
	return result;
}

function imgToIA4(src){
	var imgPixels = imgToBase(src);
	if (imgPixels == false) {
		return false;
	}
	var result = "";
	for ( var i=0; i < imgPixels.data.length; i+=4) {
		var color = Math.floor(imgPixels.data[i] / 0x11).toString(16).toUpperCase();
		var alpha = Math.floor(imgPixels.data[i+3] / 0x11).toString(16).toUpperCase();
		var val = color + alpha;
		result += val;
	}
	console.log(result);
	return result;
}

function imgToIA8(src){
	var imgPixels = imgToBase(src);
	if (imgPixels == false) {
		return false;
	}
	var result = "";
	for ( var i=0; i < imgPixels.data.length; i+=4) {
		var alpha = imgPixels.data[i+3];
		var color = imgPixels.data[i];
		result += pad(alpha.toString(16).toUpperCase(),2);
		result += pad(color.toString(16).toUpperCase(),2);
	}
	console.log(result);
	return result;
}

function imgToRGB5A3(src){
	var imgPixels = imgToBase(src);
	if (imgPixels == false) {
		return false;
	}
	var result = "";
	for ( var i=0; i < imgPixels.data.length; i+=4) {
		if (imgPixels.data[i+3] != 0xFF) {
			var type = 0;
			var alpha = Math.floor(imgPixels.data[i+3] / 0x20) << 1;
			var blue = Math.floor(imgPixels.data[i+2] / 0x11) << 4;
			var green = Math.floor(imgPixels.data[i+1] / 0x11) << 8;
			var red = Math.floor(imgPixels.data[i] / 0x11) << 12;
			var color = pad((type + alpha + red + green + blue).toString(16),4);
		} else {
			var type = 1;
			var blue = Math.floor(imgPixels.data[i+2] / 0x8) << 1;
			var green = Math.floor(imgPixels.data[i+1] / 0x8) << 6;
			var red = Math.floor(imgPixels.data[i] / 0x8) << 11;
			var color = pad((type + red + green + blue).toString(16),4);
			console.log("red: "+red.toString(16)+", green: "+green.toString(16)+", blue: "+blue.toString(16)+", type: "+type+", result: "+color);
		}
		result += color;
	}
	console.log(result);
	return result;
}

/*
World Map
$00852000  216x126 CI8 texture
$00858C00  palette
*/

/*
0b1111101111000001
0b???????????????1 RGB Mode
0b11111??????????? 0x1F Red
0b?????01111?????? 0x0F Green
0b??????????00000? 0x00 Blue

*/