/********************************
VERSION
********************************/

$version = {
	"type":"Beta",
	"major":"3",
	"standard":"0",
	"minor":"0",
	"suffix":"Preview",
	get text () {
		return this.type+' '+this.major+'.'+this.standard+'.'+this.minor+' '+this.suffix;
	  },
	get num () {
		return (this.major*100+this.standard*10+this.minor*1)/1000;
	  }
}

/********************************
EDITOR PATHS
********************************/

$src = {
	"scripts":"resources/scripts/",
	"data":"resources/data/",
	"textures":[
		"resources/textures/oot/",
		"resources/textures/mm/"
	],
	"ui":"ui/",
	"icons":"icons/",
	"skyboxes":"skyboxes/"
};


/********************************
GAME DATA SETUP
********************************/

$requiredfiles = ["dmadata","ovl_kaleido_scope","icon_item_static","icon_item_24_static","icon_item_field_static","icon_item_dungeon_static","icon_item_nes_static","nes_font_static","title_static","parameter_static"];

$gamenames = [
	{
		"short":"OoT",
		"long":"Ocarina of Time"
	},
	{
		"short":"MM",
		"long":"Majora's Mask"
	}
]

$panelnames = [
	[
		"Equipment",
		"Select Item",
		"Map",
		"Quest Status",
		"Save"
	],
	[
		"Masks",
		"Select Item",
		"Map",
		"Quest Status"
	]
]

$objectnames = [
	[
		[],
		[],
		[],
		[
			"Forest Medallion",
			"Fire Medallion",
			"Water Medallion",
			"Spirit Medallion",
			"Shadow Medallion",
			"Light Medallion",
			"Minuet of Forest",
			"Bolero of Fire",
			"Serenade of Water",
			"Requiem of Spirit",
			"Nocturne of Shadow",
			"Prelude of Light",
			"Zelda's Lullaby",
			"Epona's Song",
			"Saria's Song",
			"Sun's Song",
			"Song of Time",
			"Song of Storms",
			"Kokiri's Emerald",
			"Goron's Ruby",
			"Zora's Sapphire",
			"Stone of Agony",
			"Gerudo's Card",
			"Gold Skulltula",
			"Piece of Heart",
			"Ocarina Note #1",
			"Ocarina Note #2",
			"Ocarina Note #3",
			"Ocarina Note #4",
			"Ocarina Note #5",
			"Ocarina Note #6",
			"Ocarina Note #7",
			"Ocarina Note #8",
			"Ocarina Replay Note #1",
			"Ocarina Replay Note #2",
			"Ocarina Replay Note #3",
			"Ocarina Replay Note #4",
			"Ocarina Replay Note #5",
			"Ocarina Replay Note #6",
			"Ocarina Replay Note #7",
			"Ocarina Replay Note #8",
			"Skulltula Counter 3rd digit shadow",
			"Skulltula Counter 2nd digit shadow",
			"Skulltula Counter 1st digit shadow",
			"Skulltula Counter 3rd digit",
			"Skulltula Counter 2nd digit",
			"Skulltula Counter 1st digit"
		]
	],
	[
		[],
		[],
		[],
		[
			"Odolwa's Remains",
			"Goht's Remains",
			"Gyorg's Remains",
			"Twinmold's Remains",
			"Shield",
			"Sword",
			"Sonata of Awakening",
			"Goron Lullaby",
			"New Wave Bossa Nova",
			"Elegy of Emptiness",
			"Oath to Order",
			"Saria's Song",
			"Song of Time",
			"Song of Healing",
			"Epona's Song",
			"Song of Soaring",
			"Song of Storms",
			"Sun's Song",
			"Bomber's Notebook",
			"Quiver",
			"Bomb Bag",
			"Gold Skulltula",
			"Piece of Heart",
			"Ocarina Note #1",
			"Ocarina Note #2",
			"Ocarina Note #3",
			"Ocarina Note #4",
			"Ocarina Note #5",
			"Ocarina Note #6",
			"Ocarina Note #7",
			"Ocarina Note #8",
			"Ocarina Replay Note #1",
			"Ocarina Replay Note #2",
			"Ocarina Replay Note #3",
			"Ocarina Replay Note #4",
			"Ocarina Replay Note #5",
			"Ocarina Replay Note #6",
			"Ocarina Replay Note #7",
			"Ocarina Replay Note #8"
		]
	]
];

$dataTable = [
	[ //Ocarina of Time
		{//Equipment
			"backgroundGradient":{
				"offset":0x17628+0x4
			}
		},
		{//Select Item
			"backgroundGradient":{
				"offset":0x17628+0x0
			}
		},
		{//Map
			"backgroundGradient":{
				"offset":0x17628+0x10
			}
		},
		{//Quest Status
			"objectTable":{
				"offset":0x17918,
				"entries":0x2F
			},
			"zr":{
				"zdirection":0x5D0,
				"rdirection":0x6A8
			},
			"notesY":{
				"offset":0x4D4,
				"replayoffset":0x820
			},
			"directionTable":{
				"offset":0x1698C,
				"entries":24
			},
			"song":{
				"coloroffset":0x16944,
				"colorentries":0xC
			},
			"backgroundGradient":{
				"offset":0x17628+0xC
			},
			"noteColor":{
				"offset":0x1B40,
				"replayOffset":0x1860,
				"enterOffset":0x1E30
			},
			"heartColor":{
				"offset":0x16850
			}
		},
		{//Save
			"backgroundGradient":{
				"offset":0x17628+0x14
			}
		},
		{//Global
			"backgroundTextures":{
				"offset":0x17128
			},
			"cursorColors":{
				"offset":0x17484,
				"fadeOffset":0x174D4
			}
		}
	],
	[ //Majora's Mask
		{//Masks
			"backgroundColor":{
				"focus":0xD1C8,
				"unfocus":0xCB44
			}
		},
		{//Select Item
			"backgroundColor":{
				"focus":0xCC9C,
				"unfocus":0xC728

			}
		},
		{//Map
			"backgroundColor":{
				"focus":0xCDB8,
				"unfocus":0xC850
			}
		},
		{//Quest Status
			"backgroundColor":{
				"focus":0xD090,
				"unfocus":0xC9F8
			},
			"objectTable":{
				"offset":0x15AD4,
				"entries":39
			},
			"cursorTable":{
				"offset":0x15D2C,
				"entries":23
			},
			"directionTable":{
				"offset":0x14F8C,
				"entries":23
			},
			"remains":{//8074B388 
				"itemoffset":0x1E00,
				"iconoffset":0x46C
			},
			"notebook":{//8074B94C
				"itemoffset":0x1E58,
				"iconoffset":0xA10
			},
			"quiver":{//8074BA6C
				"itemoffset":0x1FC4,
				"iconoffset":0x14F6C
			},
			"bombbag":{//8074BA6C
				"itemoffset":0x1FC4,
				"iconoffset":0x14F78
			},
			"sword":{//8074B594
				"itemoffset":0x1EFC,
				"iconoffset":0x65C
			},
			"shield":{//8074B4FC
				"itemoffset":0x1EA0,
				"iconoffset":0x5C4
			},
			"song":{
				"coloroffset":0x14F24,
				"colorentries":0xC
			},
			"zr":{
				"zdirection":0x2614,
				"rdirection":0x269C
			},
			"notesY":{
				"offset":0x21F8,
				"replayoffset":0x27A4
			}
		},
		{
		},
		{//Global
			"backgroundTextures":{
				"offset":0x15660
			}
		}
	]
]

/********************************
EDITOR DATA
********************************/

$editor = {};

$defaultSetup = {
	"currentmenu":{
		"selection":{
			"object":[],
			"cursor":[]
		},
		"settings":{
			"zoom":100
		},
		"background":[
			[],
			[],
			[]
		],
		"cursor":[],
		"object":[],
		"data":{}
	},
	"menu":[
	],
	"drag":[],
	"data":{
		"selection":{
		},
		"menu":{
			"cursorcolor":{
				"fill":[
					{},
					{},
					{}
				],
				"fade":[
					[{},{},{},{}],
					[{},{},{},{}],
					[{},{},{},{}]
				]
			}
		},
		"offline":(window.location.protocol=="file:"||window.location.hostname=="192.168.1.50"?true:false)
	},
	"settings":{
		"menu":undefined,
		"attached":false,
		"showObjects":true,
		"showCursors":true,
		"hideObjList":false,
		"directmode":true,
		"confirmdialog":false,
		"downloadUnmodified":false,
		"showobject":[[],[],[],[],[]],
		"showcursor":[[],[],[],[],[]],
		"showBottom":true,
		"texturefile":"",
		"backgroundpaths":[
		]
	},
	"menutable":$dataTable,
	"menunames":$objectnames,
	"panelnames":$panelnames,
	"gamenames":$gamenames,
	"cache":{
		"textures":{
		}
	},
	"files":{
		"loaded":{},
		"offsets":{},
		"changes":{}
	}
};

/********************************
ASM HACKS
********************************/

$extensions = {
	"improvedinventory":{
		"type":"menu",
		"asm": "813D8B88 2400\
					813D8C68 2400\
					813D8DD0 2400\
					813D8DD4 2400\
					813D8EA8 2400\
					813D8EAC 2400\
					813D8FAC 2400\
					813D9004 2400\
					813E2168 9445\
					813E216A 023C\
					813E2170 28A1\
					813E2172 00FF\
					813E2174 5001\
					813E2176 0070\
					813E1370 29E1\
					813E1372 00FF\
					813E1378 5001\
					813E137A 011B\
					813D909C 25AD\
					813D909E 97B4\
					813D90B4 008D\
					813D90B6 8021\
					813D9578 004D\
					813D957A 1021\
					813D9584 9042\
					813D9586 97B4\
					813D849C 930E\
					813D849E 0074\
					813D84AC 9042\
					813D84AE 97B4\
		"
	}
}
						