/*************************************************************************************************************
EVENT CALLS
*************************************************************************************************************/

/********************************
HOTKEYS
********************************/

$(document).on("keydown", function (e) {
	var sel = $(document.activeElement);
	if (sel.prop("tagName") != "INPUT") { //When not focusing on an input
		var cursorID = $editor.currentmenu.selection.cursor[0];
		var objectID = $editor.currentmenu.selection.object[0];
		if (objectID)
			var object = $editor.currentmenu.object[objectID];
		if (cursorID)
			var cursor = $editor.currentmenu.cursor[cursorID];
		var zoom = Math.round(0.01*$editor.currentmenu.settings.zoom);
		switch(e.keyCode) {
			case 8: //Backspace
				break;
			case 9: //Tab
				if (!$editor.settings.menu) $editor.settings.menu = 0;
				if (e.shiftKey) $editor.settings.menu += ($editor.settings.menu>0?-1:+($editor.menu.length-1))
				else $editor.settings.menu += ($editor.settings.menu<$editor.menu.length-1?1:-($editor.menu.length-1))
				break;
			case 27: //Esc
				$editor.currentmenu.selection.object = [];
				$editor.currentmenu.selection.cursor = [];
				$editor.data.selection.active = false;
				if ($editor.data.selection.element) $editor.data.selection.element.hide();
				break;
			case 37: //Left
				if (cursor)
					setObj("cursor", cursorID, [cursor.position[0]-zoom, cursor.position[1]]);
				break;
			case 38: //Up
				if (cursor)
					setObj("cursor", cursorID, [cursor.position[0], cursor.position[1]-zoom]);
				break;
			case 39: //Right
				if (cursor)
					setObj("cursor", cursorID, [cursor.position[0]+zoom, cursor.position[1]]);
				break;
			case 40: //Down
				if (cursor)
					setObj("cursor", cursorID, [cursor.position[0], cursor.position[1]+zoom]);
				break;
			case 49: //1
				$editor.settings.showObjects = !$editor.settings.showObjects;
				break;
			case 50: //2
				$editor.settings.showCursors = !$editor.settings.showCursors;
				break;
			case 51: //3
				$editor.settings.attached = !$editor.settings.attached;
				break;
			case 65: //A
				if (object)
					setObj("object", objectID, [object.position[0]-zoom, object.position[1]]);
				break;
			case 68: //D
				if (object)
					setObj("object", objectID, [object.position[0]+zoom, object.position[1]]);
				break;
			case 83: //S
				if (object)
					setObj("object", objectID, [object.position[0], object.position[1]+zoom]);
				break;
			case 87: //W
				if (object)
					setObj("object", objectID, [object.position[0], object.position[1]-zoom]);
				break;
			default: //None of the above
				console.log(e.keyCode);
				return true;
		}
		e.preventDefault();
	} else { //When focusing on an input
		if (sel.attr("type") == "number") {
			switch(e.keyCode) {
				case 27: //Esc
					$(document.activeElement).blur();
					return true;
				case 38: //Up
					var val = 1;
					break;
				case 40: //Down
					var val = -1;
					break;
				default: //None of the above
					return true;
			}	
			var newval = parseInt(sel.val())+val;
			sel.val(newval).change();
			e.preventDefault();	
			return false;
		} else {
			switch(e.keyCode) {
				case 13: //enter
					break;
				default: //None of the above
					return true;
			}
			e.preventDefault();
		}
	}
});

/********************************
ZOOM WORKSPACE
********************************/
	
$(document).bind('mousewheel', function(e){
	if (e.shiftKey) {
		$editor.currentmenu.settings.zoom += (e.originalEvent.wheelDelta/12);
		$editor.currentmenu.settings.zoom = Math.min(Math.max($editor.currentmenu.settings.zoom,100),200);
		e.preventDefault();
		return false;
	}
});

/********************************
INPUT
********************************/

function change(e) {
	var e = $(e);
	if (e.attr("type") == "number") {
		var val = e.val();
		val = Math.min(e.attr("max")||val,val);
		val = Math.max(e.attr("min")||val,val);
		e.val(val);
	}
	var parameters = e.attr("change");
	parameters = parameters.replace("crntobject",$editor.currentmenu.selection.object[0]);
	parameters = parameters.replace("crntcursor",$editor.currentmenu.selection.cursor[0]);
	parameters = parameters.replace("crntmenu",$editor.settings.menu);
	parameters = parameters.split(",");
	var val = $.isNumeric(e.val())?parseInt(e.val()):e.val();
	if (parameters[0] == "setobj") {
		if (parameters[3] == "move") {
			if (parameters[4] == "x") {var pos = [val,$editor.currentmenu[parameters[1]][parameters[2]].position[1]];}
			else if (parameters[4] == "y") {var pos = [$editor.currentmenu[parameters[1]][parameters[2]].position[0],val];}
		}
		setObj(parameters[1], parameters[2], pos);
		e.attr("value", value);
	} else if (typeof(getObjFromPath($editor, parameters)) !== "undefined") {
		if (e.prop("tagName") == "INPUT") {
			if (e.attr("type") == "checkbox") {
				var value = e.is(':checked');
			} else if (e.hasClass("colorpick")) {
				var value = e.spectrum("get").toRgb();
			} else {
				var value = val;
			}
		} else if (e.prop("tagName") == "SELECT") {
			var value = e.val();
		} else {
			var value = (e.attr("value") == "false");
			e.attr("value", value);
		}
		setObjFromPath($editor, parameters, value);
	}
}


$(document).on('change propertychange keyup input paste keyup mouseup', "[change]:not([disabled]), select[change]", function(){
	change(this);
});


/********************************
RESET OBJECTS & CURSORS
********************************/

$(document).on('click', "[reset]:not(:disabled)", function(e){
	if (!(e.which == 1 || e.which == 0)) return false;
	var type = $(this).attr("reset");
	if (type == "panel") {
		loadPanelFromTableData($editor.settings.menu);
	} else {
		$.each($editor.currentmenu.selection[type], function(i,o) {
			loadObjectFromTableData($editor.settings.menu,type,o);
		});
	}
});

/********************************
TABS
********************************/

$(document).on("click", ".paneltab", function (e) {
	if (!(e.which == 1 || e.which == 0) || $(this).is("[disabled]")) return false;
	var parent = $(this).parents("[tabGroup]");
	var tabGroup = parent.attr("tabGroup");
	var tabs = parent.find(".paneltab");
	var index = tabs.index($(this));
	tabs.filter(":nth("+index+")").attr("current","").end().not(this).removeAttr("current");
	$("#"+tabGroup).children(".tabpanel,.sidetabpanel").eq(index).show().siblings(".tabpanel,.sidetabpanel").hide();
});
	
$(document).on("click", ".panelclose", function (e) {
	if (!(e.which == 1 || e.which == 0) || $(this).is("[disabled]")) return false;
	var parent = $(this).parents("[tabGroup]");
	var tabGroup = parent.attr("tabGroup");
	var tabs = parent.find(".paneltab");
	tabs.removeAttr("current");
	$("#"+tabGroup).children(".tabpanel,.sidetabpanel").hide();
});

/********************************
WORKSPACE TAB
********************************/

$(document).on("click", ".workspacetab", function (e) {
	if (!(e.which == 1 || e.which == 0)) return false;
	$editor.settings.menu = $(".workspacetab").index($(this));
});

/********************************
MOVE MOUSE
********************************/

$(document).on("MSPointerMove mousemove touchmove",function(e) {
	if (!(e.which == 1 || e.which == 0) || !isMainCursor(e)) return false;
	var x = [];
	var y = [];
	var pos = getCursorPos(e);
	x.push(pos[0]);
	y.push(pos[1]);
	if ($editor.data.selection.active) { //Drag selection
		var selection = $editor.data.selection;
		var workspaceoffset = $(".workspace").offset();
		selection.current = [x[0]-workspaceoffset.left+$(".workspace").scrollLeft(),y[0]-workspaceoffset.top+$(".workspace").scrollTop()];
		if (!selection.element) {
			selection.element = $('<div/>', {
				"class": "selectionbox"
			}).appendTo($(".workspace"));
		}
		selection.element.css({
			"left":Math.min(selection.start[0],selection.current[0]),
			"top":Math.min(selection.start[1],selection.current[1]),
			"width":Math.max(selection.start[0],selection.current[0])-Math.min(selection.start[0],selection.current[0]),
			"height":Math.max(selection.start[1],selection.current[1])-Math.min(selection.start[1],selection.current[1])
		});
		selection.element.show();
		return true;
	} else if (!$editor.currentmenu) { //no menu selected
		return false;
	} //Drag
	var draglist = [];
	draglist.push(0);
	$editor.currentmenu.selection.move = true;
	$.each(draglist, function(key, value) {
		var index = value;
		if ($editor.drag[index]) {
			e.preventDefault();
			var scale = $(".zoomRange").val()/100;
			var type = $editor.drag[index].type;
			var id = $editor.drag[index].id;
			var object = $editor.currentmenu[type][id];
			var element = object.objectElement;
			var workspaceOffset = $(".screen").offset();
			var cursorpos = [
				(y[key]-workspaceOffset.top)/scale+workspaceOffset.top,
				(x[key]-workspaceOffset.left)/scale+workspaceOffset.left
			];
			var newPos = [
				Math.round(cursorpos[1]-workspaceOffset.left-$editor.drag[index].offset[1]-element.css('margin-left').replace(/[^-\d\.]/g, '')),
				Math.round(cursorpos[0]-workspaceOffset.top-$editor.drag[index].offset[0]-element.css('margin-top').replace(/[^-\d\.]/g, ''))
			]
			setObj(type,id,newPos);
		}
	});
});
	
/********************************
MOUSE UP
********************************/

$(document).on("MSPointerUp mouseup touchend", function (e) {
	if (!(e.which == 1 || e.which == 0) || !isMainCursor(e)) return false;
	if ($editor.data.selection.active) { //Mouse Up from Selection Box
		var selection = $editor.data.selection;
		selection.active = false;
		if (selection.element) selection.element.hide();
		var ws = $(".workspace").offset();
		var boundary = [
			Math.min(selection.start[1],selection.current[1])+ws.top-$(".workspace").scrollTop(), //Top
			Math.min(selection.start[0],selection.current[0])+ws.left-$(".workspace").scrollLeft(), //Left
			Math.max(selection.start[0],selection.current[0])+ws.left-$(".workspace").scrollLeft(), //Right
			Math.max(selection.start[1],selection.current[1])+ws.top-$(".workspace").scrollTop() //Bottom
		]
		if (!e.shiftKey) {
			$editor.currentmenu.selection.object = [];
			$editor.currentmenu.selection.cursor = [];
		}
		$(".object,.cursor").each(function(i,object){
			if ($(object).hasClass("object"))
				var type = "object"
			else
				var type = "cursor"
			var id = $(object).attr("object").toString();
			var offset = $(object).offset();
			var objSize = [
				$(object).width(),
				$(object).height()
			]
			if (offset.top >= boundary[0]-objSize[1] && offset.top <= boundary[3] && offset.left >= boundary[1]-objSize[0] && offset.left <= boundary[2]) {
				if ($editor.currentmenu.selection[type].indexOf(id) < 0) {
					$editor.currentmenu.selection[type].push(id);
				}
			}
		});
	} else { //Mouse Up from Direct Selection
		if ($editor.currentmenu.selection.clicked && !$editor.currentmenu.selection.move) {
			var index = $editor.currentmenu.selection[$editor.currentmenu.selection.clicked.type].indexOf($editor.currentmenu.selection.clicked.id.toString());
			if (index > -1) $editor.currentmenu.selection[$editor.currentmenu.selection.clicked.type].splice(index, 1);
		} else {
			$editor.currentmenu.selection.clicked = undefined;
		}
	}
	$editor.drag = [];
});	

/********************************
SELECT OBJECT/CURSOR
********************************/

$(document).on("MSPointerDown mousedown touchstart", ".object,.cursor", function (e) {
	if (!(e.which == 1 || e.which == 0) || !isMainCursor(e)) return false;
	$(document.activeElement).blur();
	if ($(this).hasClass("object"))
		type = "object"
	else
		type = "cursor"
	if (e.shiftKey) { //Shift Click Object/Cursor
		var obji = $editor.currentmenu.selection[type].indexOf($(this).attr("object"));
		if (obji < 0) { //It's not Selected, Add it
			$editor.currentmenu.selection[type].push($(this).attr("object"));
		} else { //It's Selected, set clicked object
			$editor.currentmenu.selection.move = false;
			$editor.currentmenu.selection.clicked = {
				"type":type,
				"id":$(this).attr("object")
			}
		}
	} else if ($editor.currentmenu.selection[type].indexOf($(this).attr("object")) < 0) {
		$editor.currentmenu.selection[type] = [$(this).attr("object")];
	}
	var parentOffset = $(this).offset(); 
	var scale = $(".zoomRange").val()/100;
	var pos = getCursorPos(e);
	var index = 0;
	var relX = (pos[0] - parentOffset.left)/scale;
	var relY = (pos[1] - parentOffset.top)/scale;
	$editor.drag[index] = {
		"type":type,
		"id": $(this).attr("object"),
		"offset":[relY,relX]
	};
	e.preventDefault();
	return false;
});

/********************************
MOUSE DRAG SELECTION
********************************/
$(document).on("MSPointerDown mousedown touchstart", ".workspace", function (e) {
	if (!(e.which == 1 || e.which == 0)) return false;
	if (typeof($(e.target).attr("object")) === 'undefined' && !$editor.data.selection.active) {
		var workspaceoffset = $(this).offset();
		$editor.data.selection.active = true;
		var pos = getCursorPos(e);
		$editor.data.selection.start = [pos[0]-workspaceoffset.left+$(this).scrollLeft(),pos[1]-workspaceoffset.top+$(this).scrollTop()];
		$editor.data.selection.current = [pos[0]-workspaceoffset.left+$(this).scrollLeft(),pos[1]-workspaceoffset.top+$(this).scrollTop()];
		if (!e.shiftKey) {
			$editor.currentmenu.selection.object = [];
			$editor.currentmenu.selection.cursor = [];
		}
	}
	e.preventDefault();
	return false;
});

/********************************
SELECT OBJECT LIST ITEM
********************************/

$(document).on("click", ".listobjInfo", function (e) {
	if (!(e.which == 1 || e.which == 0)) return false;
	$(document.activeElement).blur();
	var type = $(this).parent().attr("listtype");
	var id = $(this).parent().attr("listid");
	var index = $editor.currentmenu.selection[type].indexOf(id);
	if (!e.shiftKey) {
		$editor.currentmenu.selection[type] = [];
	} else if (index > -1) {
		$editor.currentmenu.selection[type].splice(index, 1);
	}
	if (index < 0) {
		$editor.currentmenu.selection[type].push(id);
	}
});

/********************************
SAVE & LOAD FILE
********************************/

$(document).on('click', "[save]:not(:disabled),[load]:not(:disabled)", function(e){
	if (!(e.which == 1 || e.which == 0)) return false;
	type = $(this).attr("save");
	if (type) {
		if (type == "zdata") {
			saveFile();
		} else if (type == "autoload") {
			generateAutoload();
		}
	} else {
		type = $(this).attr("load");
		if (type == "localstorage") {
			loadDataFromStorage("z64editormenufile");
			loadTableData();
		}
	}
});

/********************************
LOAD .ZDATA FILE
********************************/

$(document).on('change', "[load=decompressedfile]", function(e){
	var files = e.target.files; // FileList object
	// Loop through the FileList
	$.each(files, function(i, f){
		var reader = new FileReader();
		reader.onload = (function(theFile) {
			return function(e) {
				loadFile(e.target.result);
			}
		})(f);
		var blob = f;
		reader.readAsArrayBuffer(blob);
	});
});

$(document).on('change', "[type=file][texture]", function(e){
	var backgroundid = parseInt($(this).attr("texture"));
	var files = e.target.files; // FileList object
	$.each(files, function(i, f){
			var reader = new FileReader();
			reader.onload = (function(theFile) {
				return function(e) {
					console.log(e.srcElement.result);
					$editor.settings.backgroundpaths[backgroundid] = e.srcElement.result;
				};
			})(f);
			var blob = f;
			reader.readAsDataURL(blob);
		});
		return false;
});

/********************************
SELECT TEXTURE
********************************/

$(document).on('click', ".texturelistItem", function(e){
	var offset = parseInt($(this).attr("texture-offset"));
	var file = $(this).attr("texture-file");
	var name = $textures[file][offset].name;
	var format = $textures[file][offset].format;
	var size = $textures[file][offset].size;
	var texture = $textures[file][offset].texture;
	$("#selectedTextureBox").attr("texture-file",file);
	$("#selectedTextureBox").attr("texture-offset",offset);
	$("#selTextureTe").text(name);
	$("#selTextureFo").text(size[0]+"x"+size[1]+" "+format);
	$("#selTextureFi").text(file);
	$("#selTextureOf").text("0x"+pad(offset.toString(16).toUpperCase(),6));
	$("#selTextureImg").attr("src",texture);
});

/********************************
APPLY ASM EXTENSIONS
********************************/

$(document).on('click', "[asm]:not(:disabled)", function(e){
	var asm = $(this).attr("asm");
	if ($extensions[asm]) {
		var asmdata = gameShark2ROM($extensions[asm].asm,$extensions[asm].type);
	}
	if (asmdata) {
		$.each(asmdata, function(i,o){
			$editor.menufile.setUint16(o.address, o.value);
		});
	}
});

/********************************
UNSAVED CHANGES
********************************/

window.onbeforeunload = function(e) {
        if ($editor.data.loaded && $editor.settings.confirmdialog) {
			return "You're about to close the editor.\n\rYou'll lose all changes that have been made by doing so.";
		}
}    