/*************************
LOAD FILE
*************************/

function loadFile(e, name) {
	var $filebuffer = e;
	//LOAD INDIVIDUAL FILES
	if ($filebuffer && name) {
		var $filedata = new DataView($filebuffer);
		//Setup offset table
		if (name == "dmadata") {
			loadSetup(0, $filedata, 0x0, true);
		}
		//Add File to $editor.files
		$editor.files.loaded[name] = $filedata;
		var loaded = true;
		$.each($requiredfiles, function(key, val){
			if (!$editor.files.loaded[val]) {loaded = false;}
		});
		if (loaded) {
			$editor.data.game = 0;
			$editor.data.loaded = false;
		}
		return;
	}
	//LOAD ROM FILE
	if ($filebuffer) {
		var $filedata = new DataView($filebuffer);
		var ID = "";
		for (var i = 0; i < 4; i++) {
			ID += String.fromCharCode($filedata.getUint8(0x3B+i));
		}
		var Ver = $filedata.getUint8(0x3F);
		console.log("ID: "+ID+", Ver: "+Ver);
		if (ID == "NZLE" && Ver == 0x0F) {
			console.log("File Detected as the Ocarina of Time: Master Quest Debug ROM");
			//Setup offset table
			loadSetup(0, $filedata, 0x12F70);
			//Slice files and add to $editor.files
			$.each($editor.files.offsets, function(key, val){
				$editor.files.loaded[key] = new DataView($filebuffer.slice(val[0],val[1]));
			});
			//set game to OoT
			$editor.data.game = 0;
			$editor.data.loaded = false;
		} else if (ID == "NZSE" && Ver == 0x00) {
			console.log("File Detected as the Decompressed Majoras Mask NTSC-U 1.0 ROM");
			//$editor.data.game = 1;
		}
	}
};

function loadSetup(game, data, offset) {
	if (game == 0) {
		$editor.files.offsets = {
			"dmadata":[data.getUint32(offset+0x20),data.getUint32(offset+0x20+0x4)],
			"ovl_kaleido_scope":[data.getUint32(offset+0x210),data.getUint32(offset+0x210+0x4)],
			"icon_item_static":[data.getUint32(offset+0x70),data.getUint32(offset+0x70+0x4)],
			"icon_item_24_static":[data.getUint32(offset+0x80),data.getUint32(offset+0x80+0x4)],
			"icon_item_field_static":[data.getUint32(offset+0x90),data.getUint32(offset+0x90+0x4)],
			"icon_item_dungeon_static":[data.getUint32(offset+0xA0),data.getUint32(offset+0xA0+0x4)],
			"icon_item_nes_static":[data.getUint32(offset+0xC0),data.getUint32(offset+0xC0+0x4)],
			"nes_font_static":[data.getUint32(offset+0x140),data.getUint32(offset+0x140+0x4)],
			"title_static":[data.getUint32(offset+0x3AB0),data.getUint32(offset+0x3AB0+0x4)],
			"parameter_static":[data.getUint32(offset+0x3AC0),data.getUint32(offset+0x3AC0+0x4)]
		}
	}
}

/********************************
GET FILE MENU INFO
********************************/

function getMenuFileInfo() {
}

/********************************
LOAD DATA
********************************/

function loadObjectFromTableData(menu,type,id) {
	var id = parseInt(id);
	if (!$editor.menu[menu]) {
		$editor.menu[menu] = {};
	}
	if (!$editor.menu[menu][type]) {
		$editor.menu[menu][type] = [];
	}
	if (type=="object") {
		var table = $editor.menutable[$editor.data.game][menu].objectTable;
		var offset = table.offset;
		var entries = table.entries;
		
		if ($editor.data.game == 1) { //Majora's Mask
			var x = 160 + getFileData("ovl_kaleido_scope", "int16", offset+id*0x2);
			var y = 120 - getFileData("ovl_kaleido_scope", "int16", offset+id*0x2+(entries+1)*0x2);
			var w = getFileData("ovl_kaleido_scope", "int16", offset+id*0x2+(entries+1)*0x4);
			var h = getFileData("ovl_kaleido_scope", "int16", offset+id*0x2+(entries+1)*0x6);
			if (menu == 3) {
				var icon = "resource/unavailable";
				var itemid = null;
				if (id < 4) {
					var offset = $editor.menutable[$editor.data.game][menu].remains.iconoffset;
					var itemid = id;
				} else if (id == 4) {
					var offset = $editor.menutable[$editor.data.game][menu].shield.iconoffset;
					var itemid = 1;
				} else if (id == 5) {
					var offset = $editor.menutable[$editor.data.game][menu].sword.iconoffset;
					var itemid = 2;
				} else if (id < 18) {
					var icon = "resource/ui/note";
				} else if (id == 18) {
					var offset = $editor.menutable[$editor.data.game][menu].notebook.iconoffset;
					var icon = (getFileData("ovl_kaleido_scope", "uint8", offset+0x3)*0x10)+(getFileData("ovl_kaleido_scope", "uint8", offset+0x6)/0x10);
				} else if (id == 19) { //Quiver
					var offset = $editor.menutable[$editor.data.game][menu].quiver.iconoffset;
					var upgrade = 0x2;
					var icon = (getFileData("ovl_kaleido_scope", "uint8", offset+upgrade*0x4+0x1)*0x10)+(getFileData("ovl_kaleido_scope", "uint8", offset+upgrade*0x4+0x2)/0x10);
				} else if (id == 20) { //Bomb Bag
					var offset = $editor.menutable[$editor.data.game][menu].bombbag.iconoffset;
					var upgrade = 0x2;
					var icon = (getFileData("ovl_kaleido_scope", "uint8", offset+upgrade*0x4+0x1)*0x10)+(getFileData("ovl_kaleido_scope", "uint8", offset+upgrade*0x4+0x2)/0x10);
				} else if (id == 21) { //Skulltula
					var icon = "resource/unavailable";
				} else if (id == 22) {
					var icon = "resource/ui/3heartpieces";
				} else if (id < 39) { //Notes
					var noteicons = [
						"a","d","r","l","u"
					]
					if (id < 31) { //Regular Notes
						var noteid = (id-23)%5
					} else { //Replay Notes
						var noteid = (id-31)%5
					}
					var icon = "resource/ui/ocarina/"+noteicons[noteid];
				} else if (id < 39) { 
					var icon = "resource/unavailable";
				} else {
					var icon = "resource/unavailable";
				}
				if (typeof(itemid) == "number") {
					offset = getFileData("ovl_kaleido_scope", "uint16", offset+0x2);
					offset -= 0x1E6C;
					offset = offset/0x4;
					var icon = offset+itemid;
				}
				if (typeof(icon) == "number") {
					if (icon > 0x60) icon += 0xC
					icon = $src.icons+icon;
				}
				$.extend(
					$editor.menu[menu].object[id], 
					{
						"position":[x,y],
						"size":[w,h],
						"icon":icon
					}
				)
				
				if (id > 5 && id < 18) {
					var offset = $editor.menutable[$editor.data.game][menu].song.coloroffset;
					var entries = $editor.menutable[$editor.data.game][menu].song.colorentries;
					var song = id - 0x6;
					var red = getFileData("ovl_kaleido_scope", "int16", offset+song*0x2);
					var green = getFileData("ovl_kaleido_scope", "int16", offset+song*0x2+entries*0x2);
					var blue = getFileData("ovl_kaleido_scope", "int16", offset+song*0x2+entries*0x4);
					var color = {"r":red,"g":green,"b":blue};
					//var color = rgb2hex([red,green,blue]);
					$editor.menu[menu].object[id].color = color;
				} else if (id > 22 && id < 39) {
					if (id > 30) {
						var notetype = "replaynote";
					} else {
						notetype = "note";
					}
					$editor.menu[menu].object[id][notetype] = noteid;
				}
			}
		} else if ($editor.data.game == 0) { //Ocarina of Time
			var x = 160 + getFileData("ovl_kaleido_scope", "int16", offset+id*0x2);
			var y = 120 - getFileData("ovl_kaleido_scope", "int16", offset+id*0x2+(entries+1)*0x2);
			var size = getFileData("ovl_kaleido_scope", "int16", offset+id*0x2+(entries+1)*0x4);
			if (menu == 3) {
				if (id < 6) {//Medallions
					var texture = {file:"icon_item_24_static",offset:0x900*id}
				} else if (id < 18) { //Songs
					var texture = {file:"icon_item_static",offset:0x89440}
				} else if (id < 24) { //Spiritual Stones & Gear
					var texture = {file:"icon_item_24_static",offset:0x900*(id-12)}
				} else if (id == 24) {//Heart Piece
					var texture = {file:"icon_item_static",offset:0x5B200}
				} else if (id < 41) { //Notes
					if (id < 33) { //Regular Notes
						var noteid = (id-25)%5
						var texture = {file:"parameter_static",offset:0x2940+0x100*(noteid)}
					} else { //Replay Notes
						var noteid = (id-33)%5
						var texture = {file:"parameter_static",offset:0x2940+0x100*(noteid)}
					}
				} else { //Skulltulla Counter Digits
					var texture = {file:"parameter_static",offset:0x3040}
				}
				$editor.menu[menu].object[id] = $.extend(
					$editor.menu[menu].object[id], 
					{
						"position":[x,y],
						"size":size,
						"texture":texture
					}
				);
				$editor.menu[menu].object[id].texture.refresh = true;
				//console.log($editor.menu[menu].object[id]);
				if (id > 5 && id < 18) { //Song Color
					var offset = $editor.menutable[$editor.data.game][menu].song.coloroffset;
					var entries = $editor.menutable[$editor.data.game][menu].song.colorentries;
					var song = id - 0x6;
					var red = getFileData("ovl_kaleido_scope", "int16", offset+song*0x2);
					var green = getFileData("ovl_kaleido_scope", "int16", offset+song*0x2+entries*0x2);
					var blue = getFileData("ovl_kaleido_scope", "int16", offset+song*0x2+entries*0x4);
					var color = {"r":red,"g":green,"b":blue};
					$editor.menu[menu].object[id].color = color;
				} else if (id == 24) { //Heart Piece Color
					var offset = $editor.menutable[$editor.data.game][menu].heartColor.offset;
					var fadecolor = [];
					for (var j=0;j<4;j++) {
						fadecolor[j] = {
							"r":getFileData("ovl_kaleido_scope", "uint16", offset+0x0+0x8*j),
							"g":getFileData("ovl_kaleido_scope", "uint16", offset+0x2+0x8*j),
							"b":getFileData("ovl_kaleido_scope", "uint16", offset+0x4+0x8*j),
							"a":getFileData("ovl_kaleido_scope", "uint16", offset+0x6+0x8*j)/0xFF
						}
					}
					$editor.menu[menu].object[id].fadeColor = fadecolor;
				} else if (id > 24 && id < 41) { //Song Notes
					if (id > 32) {
						var notetype = "replaynote";
					} else {
						notetype = "note";
					}
					$editor.menu[menu].object[id][notetype] = noteid;
				} else if (id > 40 && id < 44) { //Skulltula Counter Shadow
					$editor.menu[menu].object[id].color = {"r":0,"g":0,"b":0};
				}
				var table = $editor.menutable[$editor.data.game][menu].directionTable;
				if (id <= table.entries) {
					var directions = [
						getFileData("ovl_kaleido_scope", "int8", table.offset+id*0x4),
						getFileData("ovl_kaleido_scope", "int8", table.offset+id*0x4+0x1),
						getFileData("ovl_kaleido_scope", "int8", table.offset+id*0x4+0x2),
						getFileData("ovl_kaleido_scope", "int8", table.offset+id*0x4+0x3)
					]
					$editor.menu[menu].object[id].direction = directions;
				}
			}
		} 
	} else if (type=="cursor") {
		var table = $editor.menutable[$editor.data.game][menu].cursorTable;
		var x = 160 + Math.round(getFileData("ovl_kaleido_scope", "float32", table.offset+id*0x4)/0.8);
		var y = 120 - Math.round(getFileData("ovl_kaleido_scope", "float32", table.offset+id*0x4+table.entries*0x4)/0.8);
		var table = $editor.menutable[$editor.data.game][menu].directionTable;
		var directions = [
			getFileData("ovl_kaleido_scope", "int16", table.offset+id*0x8),
			getFileData("ovl_kaleido_scope", "int16", table.offset+id*0x8+0x2),
			getFileData("ovl_kaleido_scope", "int16", table.offset+id*0x8+0x4),
			getFileData("ovl_kaleido_scope", "int16", table.offset+id*0x8+0x6)
		]
		
		if (id >= 6 && id <= 17) var size = [24,24]
		else var size = [32,32]
		$editor.menu[menu].cursor[id] = {
			"position":[x,y],
			"size": size,
			"direction":directions,
			"element":element
		}
	}
}

function loadPanelFromTableData(menu) {
		if (!$editor.menu[menu]) { 
			$editor.menu[menu] = {
				"data":{}
			};
		} else if (!$editor.menu[menu].data) {
			$editor.menu[menu].data = {};
		}
		//BG COLOR
		if ($editor.menutable[$editor.data.game][menu].backgroundColor) { //Majora's Mask BG Color
			var offset = $editor.menutable[$editor.data.game][menu].backgroundColor.focus;
			var red = getFileData("ovl_kaleido_scope", "uint8", offset+0x2);
			var green = getFileData("ovl_kaleido_scope", "uint8", offset+0x3);
			var blue = getFileData("ovl_kaleido_scope", "uint8", offset+0x6);
			$editor.menu[menu].data.backgroundcolor = {"r":red,"g":green,"b":blue};
			//$editor.menu[menu].data.backgroundcolor = rgb2hex([red,green,blue]);
		} else if ($editor.menutable[$editor.data.game][menu].backgroundGradient) { //Ocarina of Time BG Gradient
			var offset = $editor.menutable[$editor.data.game][menu].backgroundGradient.offset;
			var color = [
				{"r":getFileData("ovl_kaleido_scope", "uint8", offset),"g":getFileData("ovl_kaleido_scope", "uint8", offset+0x18),"b":getFileData("ovl_kaleido_scope", "uint8", offset+0x18*0x2)},
				{"r":getFileData("ovl_kaleido_scope", "uint8", offset+0x1),"g":getFileData("ovl_kaleido_scope", "uint8", offset+0x1+0x18),"b":getFileData("ovl_kaleido_scope", "uint8", offset+0x1+0x18*0x2)},
				{"r":getFileData("ovl_kaleido_scope", "uint8", offset+0x2),"g":getFileData("ovl_kaleido_scope", "uint8", offset+0x2+0x18),"b":getFileData("ovl_kaleido_scope", "uint8", offset+0x2+0x18*0x2)},
				{"r":getFileData("ovl_kaleido_scope", "uint8", offset+0x3),"g":getFileData("ovl_kaleido_scope", "uint8", offset+0x3+0x18),"b":getFileData("ovl_kaleido_scope", "uint8", offset+0x3+0x18*0x2)}
			];
			$editor.menu[menu].data.backgroundcolor = color;
		}
		//BG TEXTURES
		var offset = $editor.menutable[$editor.data.game][5].backgroundTextures.offset;
		for (var x=0;x<3;x++) {
			for (var y=0;y<5;y++) {
				var texture = pad(getFileData("ovl_kaleido_scope", "uint32", offset+(x*0x5+y)*0x4+menu*(0x4*15)).toString(16),8).toUpperCase();
				if (texture.substring(0,2) == "08") {
					var file = "icon_item_static";
				} else if (texture.substring(0,2) == "0D") {
					var file = "icon_item_nes_static";
				} else {
					console.log("Unknown Pause Menu Texture Pointer!");
					continue;
				}
				texture = parseInt(texture.substring(2),16);
				if (!$editor.menu[menu].background) $editor.menu[menu].background = [[],[],[]];
				$editor.menu[menu].background[x][y] = {
					"file":file,
					"offset":texture,
					"refresh":true
				}
			}
		}	
		//Quest Status Menu
		if (menu == 3) {
			//Z and R Button
			var offset = $editor.menutable[$editor.data.game][menu].zr.zdirection;
			var direction = getFileData("ovl_kaleido_scope", "int16", offset+0x2);
			$editor.menu[menu].data.zdirection = direction;
			var offset = $editor.menutable[$editor.data.game][menu].zr.rdirection;
			var direction = getFileData("ovl_kaleido_scope", "int16", offset+0x2);
			$editor.menu[menu].data.rdirection = direction;
			//Song Note Y Positions
			var offset = $editor.menutable[$editor.data.game][menu].notesY.offset;
			var replayoffset = $editor.menutable[$editor.data.game][menu].notesY.replayoffset;
			$editor.menu[menu].data.notey = [];
			$editor.menu[menu].data.replaynotey = [];
			var notedistance = [
				[
					[0x0,0x10,0x20,0x30,0x40],
					[0x0,0x4,0xC,0x10,0x14]
				],
				[
					[0x0,0x4,0x10,0x20,0x2C],
					[0x0,0x4,0x8,0xC,0x10]
				]
			];
			for (var i=0;i<5;i++) {
				var y = 120 - getFileData("ovl_kaleido_scope", "int16", offset+notedistance[0][$editor.data.game][i]+0x2);
				$editor.menu[menu].data.notey[i] = y;
				var y = 120 - getFileData("ovl_kaleido_scope", "int16", replayoffset+notedistance[1][$editor.data.game][i]+0x2);
				$editor.menu[menu].data.replaynotey[i] = y;
			}
			//Song Note Color
			if ($editor.menutable[$editor.data.game][menu].noteColor) {
				var offset = $editor.menutable[$editor.data.game][menu].noteColor.offset;
				var color = [
					{"r":getFileData("ovl_kaleido_scope", "uint8", offset+0x8+0x2),"g":getFileData("ovl_kaleido_scope", "uint8", offset+0x8+0x1+0x2),"b":getFileData("ovl_kaleido_scope", "uint8", offset+0xC+0x2),"a":getFileData("ovl_kaleido_scope", "uint8", offset+0xC+0x1+0x2)/0xFF},
					{"r":getFileData("ovl_kaleido_scope", "uint8", offset+0x4+0x2),"g":getFileData("ovl_kaleido_scope", "uint8", offset+0x4+0x1+0x2),"b":getFileData("ovl_kaleido_scope", "uint8", offset+0x10+0x2),"a":getFileData("ovl_kaleido_scope", "uint8", offset+0x10+0x1+0x2)/0xFF},
					{"r":getFileData("ovl_kaleido_scope", "uint8", offset+0x2),"g":getFileData("ovl_kaleido_scope", "uint8", offset+0x1+0x2),"b":getFileData("ovl_kaleido_scope", "uint8", offset+0x14+0x2),"a":getFileData("ovl_kaleido_scope", "uint8", offset+0x14+0x1+0x2)/0xFF}
				];
				$editor.menu[menu].data.noteColor = color;
			}
		}
}

function loadGlobalPanelFromTableData() {
	if ($editor.menutable[$editor.data.game][5].cursorColors) {
		var offset = $editor.menutable[$editor.data.game][5].cursorColors.offset;
		var fadeoffset = $editor.menutable[$editor.data.game][5].cursorColors.fadeOffset;
		for (var i=0;i<3;i++) {
			var color = {
				"r":getFileData("ovl_kaleido_scope", "uint16", offset+0x0+0x6*i),
				"g":getFileData("ovl_kaleido_scope", "uint16", offset+0x2+0x6*i),
				"b":getFileData("ovl_kaleido_scope", "uint16", offset+0x4+0x6*i)
			}
			$editor.data.menu.cursorcolor.fill[i] = color;
			var fadecolor = [];
			for (var j=0;j<4;j++) {
				fadecolor[j] = {
					"r":getFileData("ovl_kaleido_scope", "uint16", fadeoffset+0x0+0x6*j+0x18*i),
					"g":getFileData("ovl_kaleido_scope", "uint16", fadeoffset+0x2+0x6*j+0x18*i),
					"b":getFileData("ovl_kaleido_scope", "uint16", fadeoffset+0x4+0x6*j+0x18*i)
				}
			}
			$editor.data.menu.cursorcolor.fade[i] = fadecolor;
		}
	}
}

function loadTableData() {
	var entries = $editor.menutable[$editor.data.game][3].objectTable.entries;
	for (var i=0;i<entries;i++) {
		loadObjectFromTableData(3,"object",i);
	}
	if ($editor.data.game == 1) { //Majora's Mask
		var entries = $editor.menutable[$editor.data.game][3].cursorTable.entries;
		for (var i=0;i<entries;i++) {
			loadObjectFromTableData(3,"cursor",i);
		}
	}
	if ($editor.data.game == 1) { //Majora's Mask
		var length = 4;
	} else if ($editor.data.game == 0) { //Ocarina of Time
		var length = 5;
	} else {
		var length = 0;
	}
	$editor.settings.backgroundpaths = [];
	for (var i=0;i<length;i++) {
		loadPanelFromTableData(i);
	
	}
	loadGlobalPanelFromTableData();
	loadTexturesFromTableData();
}


/********************************
SAVE DATA
********************************/

function saveFile() {
	//DATA
	var entries = $editor.menutable[$editor.data.game][3].objectTable.entries;
	for (var i=0;i<entries;i++) {
		saveObjectToFile(3,"object",i);
	}
	if ($editor.data.game == 1) { //Majora's Mask
		var entries = $editor.menutable[$editor.data.game][3].cursorTable.entries;
		for (var i=0;i<entries;i++) {
			saveObjectToFile(3,"cursor",i);
		}
	}
	var panelcount = 5;
	if ($editor.data.game == 1) panelcount = 4;
	for (var i=0;i<panelcount;i++) {
		savePanelToFile(i);
	}
	saveGlobalPanelToFile();
	//SET UP ZIP
	var zip = new JSZip();
	//SET UP ROM FILES
	var editedfiles = '';
	var filechanges = '';
	var folder = zip.folder("files");
	$.each($editor.files.loaded, function(key, val){
		var filename = key;
		for (var i=filename.length;i<40;i++) {
			filename += " ";
		}
		if ($.isEmptyObject($editor.files.changes[key])) {
			if ($editor.settings.downloadUnmodified) {
				folder.file(key, val.buffer);
			}
			return true;
		}
		folder.file(key, val.buffer);
		editedfiles += filename+"0x"+pad($editor.files.offsets[key][0].toString(16).toUpperCase(),7)+"  0x"+pad(($editor.files.offsets[key][1]-$editor.files.offsets[key][0]).toString(16).toUpperCase(),7)+"  "+"\r\n";
		filechanges += key+"\r\n";
		if (key.indexOf('_static') < 0) {
			filechanges += "        Offset    Type      Object                   Data                Old Val   New Val   \r\n";
			$.each($editor.files.changes[key], function(offset, change){
				var offset = "0x"+pad(parseInt(offset).toString(16).toUpperCase(),6);
				var type = change.type;
				var obj = change.object;
				var data = change.data;
				var oldval = change.oldval.toString();
				var val = change.val.toString();
				var tab = "        ";
				for (var i=offset.length;i<10;i++) {offset += " ";}
				for (var i=type.length;i<10;i++) {type += " ";}
				for (var i=obj.length;i<25;i++) {obj += " ";}
				for (var i=data.length;i<20;i++) {data += " ";}
				for (var i=oldval.length;i<10;i++) {oldval += " ";}
				for (var i=val.length;i<10;i++) {val += " ";}
				filechanges += tab+offset+type+obj+data+oldval+val+"\r\n";
			});
		} else {
			filechanges += "        Offset    Format    Size      Texture                                                \r\n";
			$.each($editor.files.changes[key], function(offset, change){
				var offset = "0x"+pad(parseInt(offset).toString(16).toUpperCase(),6);
				var format = change.format;
				var size = change.size[0]+"x"+change.size[1];
				var texture = change.texture;
				var tab = "        ";
				for (var i=offset.length;i<10;i++) {offset += " ";}
				for (var i=format.length;i<10;i++) {format += " ";}
				for (var i=size.length;i<10;i++) {size += " ";}
				filechanges += tab+offset+format+size+texture+"\r\n";
			});
		}
	});
	//SET UP HELP FILE
	var time = new Date;
var helptxt = '\
All the files that have been edited has been saved and downloaded to the files folder.\r\n\
Files were generated '+time.toLocaleString()+' using CloudMax\'s z64editor '+$version.text+'\r\n\
******************************************************************************************\r\n\
** Files that were modified                                                             **\r\n\
******************************************************************************************\r\n\
File                                    Offset     Length\r\n\
'+editedfiles+'\
******************************************************************************************\r\n\
                                                                                          \r\n\
******************************************************************************************\r\n\
** Changes that were made                                                               **\r\n\
******************************************************************************************\r\n\
'+filechanges+'\
******************************************************************************************\r\n\
';
	zip.file("help.txt", helptxt);
	var blob = zip.generate({type:"blob"});
	saveAs(blob, "z64editor_save.zip");
}
function saveObjectToFile(menu,type,id) {
	if (!$editor.menu[menu][type]) $editor.menu[menu][type] = [];
	if (type=="object") {
		var table = $editor.menutable[$editor.data.game][menu].objectTable;
		var offset = table.offset;
		var entries = table.entries;
		
		if ($editor.data.game == 1) { //Majora's Mask
			var x = $editor.menu[menu].object[id].position[0] - 160;
			var y = 120 - $editor.menu[menu].object[id].position[1];
			var w = $editor.menu[menu].object[id].size[0];
			var h = $editor.menu[menu].object[id].size[1];
			setFileData("ovl_kaleido_scope", "int16", offset+id*0x2, x, [$editor.menunames[$editor.data.game][menu][id],"X Position"]);
			setFileData("ovl_kaleido_scope", "int16", offset+id*0x2+(entries+1)*0x2, y, [$editor.menunames[$editor.data.game][menu][id],"Y Position"]);
			setFileData("ovl_kaleido_scope", "int16", offset+id*0x2+(entries+1)*0x4, w, [$editor.menunames[$editor.data.game][menu][id],"Width"]);
			setFileData("ovl_kaleido_scope", "int16", offset+id*0x2+(entries+1)*0x6, h, [$editor.menunames[$editor.data.game][menu][id],"Height"]);
			if (menu == 3) {
				if (id > 5 && id < 18) {
					var offset = $editor.menutable[$editor.data.game][menu].song.coloroffset;
					var entries = $editor.menutable[$editor.data.game][menu].song.colorentries;
					var song = id - 0x6;
					var color = $editor.menu[menu].object[id].color;
					setFileData("ovl_kaleido_scope", "int16", offset+song*0x2, color.r, [$editor.menunames[$editor.data.game][menu][id],"Red"]);
					setFileData("ovl_kaleido_scope", "int16", offset+song*0x2+entries*0x2, color.g, [$editor.menunames[$editor.data.game][menu][id],"Green"]);
					setFileData("ovl_kaleido_scope", "int16", offset+song*0x2+entries*0x4, color.b, [$editor.menunames[$editor.data.game][menu][id],"Blue"]);
				}
			}
		} else if ($editor.data.game == 0) { //Ocarina of Time
			var x = $editor.menu[menu].object[id].position[0] - 160;
			var y = 120 - $editor.menu[menu].object[id].position[1];
			var size = $editor.menu[menu].object[id].size;
			setFileData("ovl_kaleido_scope", "int16", offset+id*0x2, x, [$editor.menunames[$editor.data.game][menu][id],"X Position"]);
			setFileData("ovl_kaleido_scope", "int16", offset+id*0x2+(entries+1)*0x2, y, [$editor.menunames[$editor.data.game][menu][id],"Y Position"]);
			setFileData("ovl_kaleido_scope", "int16", offset+id*0x2+(entries+1)*0x4, size, [$editor.menunames[$editor.data.game][menu][id],"Size"]);
			
			if (menu == 3) {
				if (id > 5 && id < 18) {
					var offset = $editor.menutable[$editor.data.game][menu].song.coloroffset;
					var entries = $editor.menutable[$editor.data.game][menu].song.colorentries;
					var song = id - 0x6;
					var color = $editor.menu[menu].object[id].color;
					setFileData("ovl_kaleido_scope", "int16", offset+song*0x2, color.r, [$editor.menunames[$editor.data.game][menu][id],"Red"]);
					setFileData("ovl_kaleido_scope", "int16", offset+song*0x2+entries*0x2, color.g, [$editor.menunames[$editor.data.game][menu][id],"Green"]);
					setFileData("ovl_kaleido_scope", "int16", offset+song*0x2+entries*0x4, color.b, [$editor.menunames[$editor.data.game][menu][id],"Blue"]);
				} else if (id == 24) {
					//Heart Container Color
					var offset = $editor.menutable[$editor.data.game][menu].heartColor.offset;
					var fadecolor = $editor.menu[menu].object[id].fadeColor;
					for (var i=0;i<4;i++) {
						setFileData("ovl_kaleido_scope", "uint16", offset+0x0+0x8*i, fadecolor[i].r, ["Heart Container","Fade "+i+" Red"]);
						setFileData("ovl_kaleido_scope", "uint16", offset+0x2+0x8*i, fadecolor[i].g, ["Heart Container","Fade "+i+" Green"]);
						setFileData("ovl_kaleido_scope", "uint16", offset+0x4+0x8*i, fadecolor[i].b, ["Heart Container","Fade "+i+" Blue"]);
						setFileData("ovl_kaleido_scope", "uint16", offset+0x6+0x8*i, fadecolor[i].a*0xFF, ["Heart Container","Fade "+i+" Alpha"]);
					}
				}
			}
			var table = $editor.menutable[$editor.data.game][menu].directionTable;
			if (id <= table.entries) {
				var directions = $editor.menu[menu].object[id].direction;
				setFileData("ovl_kaleido_scope", "int8", table.offset+id*0x4, directions[0], [$editor.menunames[$editor.data.game][menu][id],"Up Direction ID"]),
				setFileData("ovl_kaleido_scope", "int8", table.offset+id*0x4+0x1, directions[1], [$editor.menunames[$editor.data.game][menu][id],"Down Direction ID"]),
				setFileData("ovl_kaleido_scope", "int8", table.offset+id*0x4+0x2, directions[2], [$editor.menunames[$editor.data.game][menu][id],"Left Direction ID"]),
				setFileData("ovl_kaleido_scope", "int8", table.offset+id*0x4+0x3, directions[3], [$editor.menunames[$editor.data.game][menu][id],"Right Direction ID"])
			}
		}
	} else if (type=="cursor" && $editor.data.game == 1) {
		var table = $editor.menutable[$editor.data.game][menu].cursorTable;
		var x = ($editor.menu[menu].cursor[id].position[0] - 160)*0.8;
		var y = (120 - $editor.menu[menu].cursor[id].position[1])*0.8;
		setFileData("ovl_kaleido_scope", "float32", table.offset+id*0x4, x);
		setFileData("ovl_kaleido_scope", "float32", table.offset+id*0x4+table.entries*0x4, y);
		var table = $editor.menutable[$editor.data.game][menu].directionTable;
		var directions = $editor.menu[menu].cursor[id].direction;
		setFileData("ovl_kaleido_scope", "int16", table.offset+id*0x8, directions[0]);
		setFileData("ovl_kaleido_scope", "int16", table.offset+id*0x8+0x2, directions[1]);
		setFileData("ovl_kaleido_scope", "int16", table.offset+id*0x8+0x4, directions[2]);
		setFileData("ovl_kaleido_scope", "int16", table.offset+id*0x8+0x6, directions[3]);
	}	
}

function savePanelToFile(menu) {
	//BG COLOR
	if ($editor.data.game == 1) { //Majora's Mask
		var color = $editor.menu[menu].data.backgroundcolor;
		var offset = $editor.menutable[$editor.data.game][menu].backgroundColor.focus;
		setFileData("ovl_kaleido_scope", "uint8", offset+0x2, color.r);
		setFileData("ovl_kaleido_scope", "uint8", offset+0x3, color.g);
		setFileData("ovl_kaleido_scope", "uint8", offset+0x6, color.b);
		var offset = $editor.menutable[$editor.data.game][menu].backgroundColor.unfocus;
		setFileData("ovl_kaleido_scope", "uint8", offset+0x2, color.r);
		setFileData("ovl_kaleido_scope", "uint8", offset+0x3, color.g);
		setFileData("ovl_kaleido_scope", "uint8", offset+0x6, color.b);
	} else if ($editor.data.game == 0) { //Ocarina of Time BG Gradient
		var color = [
			$editor.menu[menu].data.backgroundcolor[0],
			$editor.menu[menu].data.backgroundcolor[1],
			$editor.menu[menu].data.backgroundcolor[2],
			$editor.menu[menu].data.backgroundcolor[3]
		];
		var offset = $editor.menutable[$editor.data.game][menu].backgroundGradient.offset;
		$.each(color, function(i,v) {
			setFileData("ovl_kaleido_scope", "uint8", offset+i,v.r, [$editor.panelnames[$editor.data.game][menu]+" Panel", "Gradient "+i+" Red"]);
			setFileData("ovl_kaleido_scope", "uint8", offset+i+0x18,v.g, [$editor.panelnames[$editor.data.game][menu]+" Panel", "Gradient "+i+" Green"]);
			setFileData("ovl_kaleido_scope", "uint8", offset+i+0x18*0x2,v.b, [$editor.panelnames[$editor.data.game][menu]+" Panel", "Gradient "+i+" Blue"]);
		});

	}
	if (menu == 3) {	
		//Add R Direction ID
		setFileData("ovl_kaleido_scope", "uint16", 0x6A8, 0x2401, ["Quest Status R Button","Direction ID - ASM"]);		//ADDIU    AT, R0, Direction ID
		setFileData("ovl_kaleido_scope", "uint32", 0x6AC, 0xA681021C, ["Quest Status R Button","Direction ID - ASM"]);	//SH       AT, 0x021C(S4)
		//Z and R Button
		var offset = $editor.menutable[$editor.data.game][menu].zr.zdirection;
		var direction = $editor.menu[menu].data.zdirection;
		setFileData("ovl_kaleido_scope", "int16", offset+0x2, direction, ["Quest Status Z Button","Direction ID"]);
		var offset = $editor.menutable[$editor.data.game][menu].zr.rdirection;
		var direction = $editor.menu[menu].data.rdirection;
		setFileData("ovl_kaleido_scope", "int16", offset+0x2, direction, ["Quest Status R Button","Direction ID"]);
		//Song Note Y Positions
		var offset = $editor.menutable[$editor.data.game][menu].notesY.offset;
		var replayoffset = $editor.menutable[$editor.data.game][menu].notesY.replayoffset;
		var notey = $editor.menu[menu].data.notey;
		var replaynotey = $editor.menu[menu].data.replaynotey;
		var notedistance = [
			[
				[0x0,0x10,0x20,0x30,0x40],
				[0x0,0x4,0xC,0x10,0x14]
			],
			[
				[0x0,0x4,0x10,0x20,0x2C],
				[0x0,0x4,0x8,0xC,0x10]
			]
		];
		for (var i=0;i<5;i++) {
			setFileData("ovl_kaleido_scope", "int16", offset+notedistance[0][$editor.data.game][i]+0x2, 120-notey[i], ["Note "+i,"Y Position"]);
			setFileData("ovl_kaleido_scope", "int16", replayoffset+notedistance[1][$editor.data.game][i]+0x2, 120-replaynotey[i], ["Replay Note "+i,"Y Position"]);
		}
		//Song Note Color
		if ($editor.menutable[$editor.data.game][menu].noteColor) {
			var offset = $editor.menutable[$editor.data.game][menu].noteColor.offset;
			var replayOffset = $editor.menutable[$editor.data.game][menu].noteColor.replayOffset;
			var enterOffset = $editor.menutable[$editor.data.game][menu].noteColor.enterOffset;
			var color = $editor.menu[menu].data.noteColor;
			
			/*A Button*/
			//Default State
			setFileData("ovl_kaleido_scope", "uint8", offset+0x8+0x2, color[0].r, ["Song Note A Button","Red (Default)"]);
			setFileData("ovl_kaleido_scope", "uint8", offset+0x8+0x3, color[0].g, ["Song Note A Button","Green (Default)"]);
			setFileData("ovl_kaleido_scope", "uint8", offset+0xC+0x2, color[0].b, ["Song Note A Button","Blue (Default)"]);
			setFileData("ovl_kaleido_scope", "uint8", offset+0xC+0x3, color[0].a*0xFF, ["Song Note A Button","Alpha"]);
			//Playing State
			setFileData("ovl_kaleido_scope", "uint8", replayOffset+0x8+0x2, color[0].r, ["Song Note A Button","Red (Playing)"]);
			setFileData("ovl_kaleido_scope", "uint8", replayOffset+0x8+0x3, color[0].g, ["Song Note A Button","Green (Playing)"]);
			setFileData("ovl_kaleido_scope", "uint8", replayOffset+0xC+0x2, color[0].b, ["Song Note A Button","Blue (Playing)"]);
			//Enter State
			setFileData("ovl_kaleido_scope", "uint8", enterOffset+0x8+0x2, color[0].r, ["Song Note A Button","Red (Entered)"]);
			setFileData("ovl_kaleido_scope", "uint8", enterOffset+0x8+0x3, color[0].g, ["Song Note A Button","Green (Entered)"]);
			setFileData("ovl_kaleido_scope", "uint8", enterOffset+0x8+0x8+0x2, color[0].b, ["Song Note A Button","Blue (Entered)"]);
			
			/*C Button*/
			//Default State
			setFileData("ovl_kaleido_scope", "uint8", offset+0x4+0x2, color[1].r, ["Song Note C Button","Red (Default)"]);
			setFileData("ovl_kaleido_scope", "uint8", offset+0x4+0x3, color[1].g, ["Song Note C Button","Green (Default)"]);
			setFileData("ovl_kaleido_scope", "uint8", offset+0x10+0x2, color[1].b, ["Song Note C Button","Blue (Default)"]);
			setFileData("ovl_kaleido_scope", "uint8", offset+0x10+0x3, color[1].a*0xFF, ["Song Note C Button","Alpha"]);
			//Playing State
			setFileData("ovl_kaleido_scope", "uint8", replayOffset+0x4+0x2, color[1].r, ["Song Note C Button","Red (Playing)"]);
			setFileData("ovl_kaleido_scope", "uint8", replayOffset+0x4+0x3, color[1].g, ["Song Note C Button","Green (Playing)"]);
			setFileData("ovl_kaleido_scope", "uint8", replayOffset+0x10+0x2, color[1].b, ["Song Note C Button","Blue (Playing)"]);
			//Enter State
			setFileData("ovl_kaleido_scope", "uint8", enterOffset+0x4+0x2, color[1].r, ["Song Note C Button","Red (Entered)"]);
			setFileData("ovl_kaleido_scope", "uint8", enterOffset+0x4+0x3, color[1].g, ["Song Note C Button","Green (Entered)"]);
			setFileData("ovl_kaleido_scope", "uint8", enterOffset+0x4+0x10+0x2, color[1].b, ["Song Note C Button","Blue (Entered)"]);
			
			/*Replay Button*/
			setFileData("ovl_kaleido_scope", "uint8", offset+0x2, color[2].r, ["Song Note Replay Button","Red"]);
			setFileData("ovl_kaleido_scope", "uint8", offset+0x3, color[2].g, ["Song Note Replay Button","Green"]);
			setFileData("ovl_kaleido_scope", "uint8", offset+0x14+0x2, color[2].b, ["Song Note Replay Button","Blue"]);
			setFileData("ovl_kaleido_scope", "uint8", offset+0x14+0x3, color[2].a*0xFF, ["Song Note Replay Button","Alpha"]);
		}
	}
}

function saveGlobalPanelToFile() {
	if ($editor.menutable[$editor.data.game][5].cursorColors) {
		var offset = $editor.menutable[$editor.data.game][5].cursorColors.offset;
		var fadeoffset = $editor.menutable[$editor.data.game][5].cursorColors.fadeOffset;
		var cursors = ["Standard","C Button","A Button"];
		for (var i=0;i<3;i++) {
			var color = $editor.data.menu.cursorcolor.fill[i];
			setFileData("ovl_kaleido_scope", "uint16", offset+0x0+0x6*i,color.r, [cursors[i]+" Cursor","Fill Red"]);
			setFileData("ovl_kaleido_scope", "uint16", offset+0x2+0x6*i,color.g, [cursors[i]+" Cursor","Fill Green"]);
			setFileData("ovl_kaleido_scope", "uint16", offset+0x4+0x6*i,color.b, [cursors[i]+" Cursor","Fill Blue"]);
			var fadecolor = $editor.data.menu.cursorcolor.fade[i];
			for (var j=0;j<4;j++) {
				setFileData("ovl_kaleido_scope", "uint16", fadeoffset+0x0+0x6*j+0x18*i,fadecolor[j].r, [cursors[i]+" Cursor","Fade "+j+" Red"]);
				setFileData("ovl_kaleido_scope", "uint16", fadeoffset+0x2+0x6*j+0x18*i,fadecolor[j].g, [cursors[i]+" Cursor","Fade "+j+" Green"]);
				setFileData("ovl_kaleido_scope", "uint16", fadeoffset+0x4+0x6*j+0x18*i,fadecolor[j].b, [cursors[i]+" Cursor","Fade "+j+" Blue"]);
			}
		}
	}
}

function setFileData(file, type, offset, val, description) {
	var val = Math.floor(val);
	var oldval = $editor.files.loaded[file]["get"+type.charAt(0).toUpperCase() + type.slice(1).toLowerCase()](offset);
	if (oldval != val && description != false && description instanceof Array) {
		if (!$editor.files.changes[file]) $editor.files.changes[file] = {};
		$editor.files.changes[file][offset] = {
			object: description[0],
			data: description[1],
			oldval: oldval,
			val: val,
			type: type
		}
	} else if (typeof(description) == "object") {
		if (!$editor.files.changes[file]) $editor.files.changes[file] = {};
		if (description.type == "texture") {
			$editor.files.changes[file][offset] = {
				texture: description.data.name,
				size: description.data.size,
				format: description.data.format
			}
		}
	}
	return $editor.files.loaded[file]["set"+type.charAt(0).toUpperCase() + type.slice(1).toLowerCase()](offset, val);
}

function getFileData(file, type, offset) {
	return $editor.files.loaded[file]["get"+type.charAt(0).toUpperCase() + type.slice(1).toLowerCase()](offset);
}

/*************************
AUTOLOAD
*************************/

function generateAutoload() {
	if (!$editor.files.autoload) {
		$editor.files.autoload = {
		};
	}
	var zip = new JSZip();
	var helptxt = '\
This feature is only available for those who\'ve downloaded the editor. You can download the editor here: https://github.com/CloudMax94/CloudMaxs_z64editor\r\n\
Put the autoload folder in the same directory as the editor and it\'ll automatically load the files when you launch the editor.\r\n\
This folder was generated for version '+$version.text+' and may not be compatible with future versions of the editor.\r\n\
Generated Files:\r\n\
';
	var folder = zip.folder("autoload");
	helptxt += "autoload\r\n";
	var autoloaddata = '\
$autoload={data:{game:'+$editor.data.game+',ver:'+$version.num+'}};\r\n\
$.each($requiredfiles, function(i, v){\r\n\
	document.write(\'<script src="autoload/\'+v.replace(/\\..*/,"")+\'.js"><\/script>\');\r\n\
});\r\n\
';
	folder.file("autoload_data.js",autoloaddata);
	helptxt += "\tautoload_data.js\r\n";
	$.each($editor.files.offsets, function(key, val){
		var str = '';
		for (var i=0; i<$editor.files.loaded[key].byteLength; i++) {
			str += String.fromCharCode($editor.files.loaded[key].getUint8(i));
		}
		str = window.btoa(str);
		folder.file(key+".js", '$autoload.'+key+'="'+str+'";');
		helptxt += "\t"+key+".js\r\n";
	});
	helptxt += "help.txt\r\n";
	zip.file("help.txt", helptxt);
	var blob = zip.generate({type:"blob"});
	saveAs(blob, "autoload.zip");
}