/********************************
CREATE ELEMENTS
********************************/

function createElements(object) {
	var newobject = $("<"+object.element+"/>", object.data);
	if (object.children) {
		$.each(object.children, function(index, child){
			$(newobject).append(createElements(child));
		});
	}
	return newobject;
}

/********************************
PAD
********************************/

function pad(n, width, z) {
  z = z || '0';
  n = n + '';
  return n.length >= width ? n : new Array(width - n.length + 1).join(z) + n;
}


/********************************
GET OBJECT VALUE USING PATH
********************************/

function getObjFromPath(obj, keyPath) {
   lastKeyIndex = keyPath.length-1;
   for (var i = 0; i < lastKeyIndex; ++ i) {
	 key = keyPath[i];
	 if (!(key in obj))
	   return undefined;
	 obj = obj[key];
   }
   return obj[keyPath[lastKeyIndex]];
}

/********************************
SET OBJECT VALUE USING PATH
********************************/

function setObjFromPath(obj, keyPath, value) {
   lastKeyIndex = keyPath.length-1;
   for (var i = 0; i < lastKeyIndex; ++ i) {
	 key = keyPath[i];
	 if (!(key in obj))
	   obj[key] = {}
	 obj = obj[key];
   }
   obj[keyPath[lastKeyIndex]] = value;
}

/********************************
GET EVENT CURSOR POS
********************************/
function getCursorPos(e) {
	if (e.originalEvent.touches)  {
		var x = e.originalEvent.touches[0].pageX;
		var y = e.originalEvent.touches[0].pageY;
	} else if (e.originalEvent.pointerId) {
		var x = e.originalEvent.pageX;
		var y = e.originalEvent.pageY;
	} else {
		var x = e.pageX;
		var y = e.pageY;
	}
	return [x,y];
}
/********************************
IS MAIN CURSOR
********************************/

function isMainCursor(e) {
	var maincursor = true;
	if (e.originalEvent.touches)  {
		if (e.originalEvent.changedTouches[0].identifier != 0) {
			maincursor = false;
		}
	} else if (e.originalEvent.pointerId) {
		
	}
	return maincursor;
}

/********************************
OBJECT SIZE
********************************/
Object.size = function(obj) {
    var size = 0, key;
    for (key in obj) {
        if (obj.hasOwnProperty(key)) size++;
    }
    return size;
};

/********************************
LOAD DATA FROM STORAGE
********************************/

function loadDataFromStorage(item) {
	try {
		var menufile = localStorage.getItem(item);
		var menufile = $.parseJSON(menufile);
		var filelength = (menufile.byteLength?menufile.byteLength:Object.size(menufile));
		var buffer = new ArrayBuffer(filelength);
		$filedata = new DataView(buffer);
		$filedata.byteLength = filelength;
		for (var i=0; i<$filedata.byteLength; i++) {
			$filedata.setUint8(i, menufile[i]);
		}
		$editor.menufile = $filedata;
		if ($editor.menufile.byteLength == 96688) { //Majora's Mask
			$editor.data.game = 1;
		} else if ($editor.menufile.byteLength == 125312) { //Ocarina of Time
			$editor.data.game = 0;
		}
		getMenuFileInfo();
	}
	catch(e){
		 //catch and just suppress error
	}
}

/********************************
MERGE OBJECT
********************************/
function mergeObject(object, template) {
	newObject = new $.extend(true, {}, object);
	$.each(template, function(key, value) {
		if (typeof(object[key]) === "undefined") {
			if (typeof(value) === "object" || typeof(value) === "array") {
				object[key] = new $.extend(true, value, object[key]);
			} else {
				object[key] = value;
			}
		} else if (typeof(value) === "object" || typeof(value) === "array") {
			mergeObject(object[key], value);
		}
	});
}

/********************************
REFRESH EDITOR OBJECT
********************************/

function refreshEditorObject() {
	var setup = new $.extend(true, {}, $defaultSetup);
	if ($editor.settings && $editor.settings.menu >= 5) {
		delete setup.currentmenu.background;
		delete setup.currentmenu.cursor;
		delete setup.currentmenu.object;
	}
	mergeObject($editor,setup);
}

/********************************
MOVE OBJECT
********************************/

function setObj(type, id, pos, size) {
	pos = pos || $editor.currentmenu[type][id].position;
	size = size || $editor.currentmenu[type][id].size;
	var posdifference = [
		pos[0]-$editor.currentmenu[type][id].position[0],
		pos[1]-$editor.currentmenu[type][id].position[1]
	];
	if (typeof(size) == "object") {
		$editor.currentmenu[type][id].size = [size[0], size[1]];
	} else {
		$editor.currentmenu[type][id].size = size;
	}
	var note = [];
	var replaynote = [];
	$.each($editor.currentmenu.selection[type], function(i,v){
		$editor.currentmenu[type][v].position[0] += posdifference[0];
		$editor.currentmenu[type][v].position[1] += posdifference[1];
		if (typeof($editor.currentmenu[type][v].note) !== "undefined") {
			note[$editor.currentmenu[type][v].note] = $editor.currentmenu[type][v].note;
		} else if (typeof($editor.currentmenu[type][v].replaynote) !== "undefined") {
			replaynote[$editor.currentmenu[type][v].replaynote] = $editor.currentmenu[type][v].replaynote;
		}
		if ($editor.settings.attached == true && $editor.currentmenu.selection[type].length == 1) {
			if (type == "object") linkedtype = "cursor";
			else linkedtype = "object";
			var pos = $editor.currentmenu[type][v].position;
			if ($editor.data.game == 1) { //Majora's Mask
				if ($editor.settings.menu == 3) {
					if (v < 23)  { //Cursors
						posModifier = [
							(($editor.currentmenu.object[v].size[0]/2)+3),
							(($editor.currentmenu.object[v].size[1]/2)+3)
						]
						if (type == "cursor") {
							posModifier[0] *= -1;
							posModifier[1] *= -1;
						}
						$editor.currentmenu[linkedtype][v].position[0] = pos[0]+posModifier[0];
						$editor.currentmenu[linkedtype][v].position[1] = pos[1]+posModifier[1];
					} else { //Ocarina Notes
						if (v < 31) {
							$editor.currentmenu.object[parseInt(v)+0x8].position[0] = $editor.currentmenu.object[v].position[0];
							$editor.currentmenu.data.replaynotey[$editor.currentmenu.object[v].note] = pos[1];
						} else {
							$editor.currentmenu.object[parseInt(v)-0x8].position[0] = $editor.currentmenu.object[v].position[0];
							$editor.currentmenu.data.notey[$editor.currentmenu.object[v].replaynote] = pos[1];
						}
					}
				}
			} else if ($editor.data.game == 0 ) { //Ocarina of Time
				if ($editor.settings.menu == 3) {
					if (v < 25) { //
					} else if (v < 33) { //Notes
						$editor.currentmenu.object[parseInt(v)+0x8].position[0] = $editor.currentmenu.object[v].position[0];
						$editor.currentmenu.data.replaynotey[$editor.currentmenu.object[v].note] = pos[1];
					} else if (v < 41) { //Replay Notes
						$editor.currentmenu.object[parseInt(v)-0x8].position[0] = $editor.currentmenu.object[v].position[0];
						$editor.currentmenu.data.notey[$editor.currentmenu.object[v].replaynote] = pos[1];
					} else if (v < 44) { //Skulltulla Digit Shadows
						$editor.currentmenu.object[parseInt(v)+0x3].position = [
							$editor.currentmenu.object[v].position[0]-2,
							$editor.currentmenu.object[v].position[1]-2
						];
					} else if (v < 47) { //Skulltulla Digits
						$editor.currentmenu.object[parseInt(v)-0x3].position = [
							$editor.currentmenu.object[v].position[0]+2,
							$editor.currentmenu.object[v].position[1]+2
						];
					}
				}
			}
		}
	});
	$.each(note, function(i,v){
		$editor.currentmenu.data.notey[v] += posdifference[1];
	});
	$.each(replaynote, function(i,v){
		$editor.currentmenu.data.replaynotey[v] += posdifference[1];
	});
}


/********************************
DATA REQUIREMENT
********************************/

function dataReq(ie, element){
	var req = $(element).attr("data-req");
	//Get Function to use
	req = req.split("$");
	var type = (req[1]?req.pop():"show");
	var arg = [null,null];
	if (type == "show" || type == "hide") {
		var fn = [type,(type=="show"?"hide":"show")];
	} else if (type == "enable") {
		var fn = ["removeAttr","attr"];
		arg = [["disabled"],["disabled", ""]];
	}
	req = req[0];
	//Get Required value
	req = req.split("/");
	var val = (req[1]?req[1].split("|"):undefined);
	//Get Path
	var path = req[0];
	path = path.replace("crntobject",$editor.currentmenu.selection.object[0]);
	path = path.replace("crntcursor",$editor.currentmenu.selection.cursor[0]);
	path = path.split(",");
	//Get variable
	var result = getObjFromPath($editor, path);
	//Check if variable is set, and if it has the proper value
	if ((typeof(result) !== "undefined" || path == []) && (typeof(val) === "undefined" || $.inArray(result.toString(),val) >= 0)) {
		$(element)[fn[0]].apply($(element),arg[0]);
	} else {
		$(element)[fn[1]].apply($(element),arg[1]);
	}
}

/********************************
RGB2HEX
********************************/

function rgb2hex(rgb){
	var red = pad(rgb[0].toString(16),2);
	var green = pad(rgb[1].toString(16),2);
	var blue = pad(rgb[2].toString(16),2);
	return ("#"+red+green+blue).toUpperCase();
}

/********************************
HEX2RGB
********************************/

function hex2rgb(hex){
	var hex = parseInt(hex.replace("#",""), 16);
	var r = (hex & 0xff0000) >> 16;
	var g = (hex & 0x00ff00) >> 8;
	var b = hex & 0x0000ff;
	return [r, g, b];
}

/********************************
GRADIENT
********************************/

function multiplyColor(src, color){
	var canvas = document.createElement('canvas');
	var ctx = canvas.getContext('2d');
	
	var imgObj = new Image();
	imgObj.src = src;
	if (!imgObj.width || !imgObj.height) {
		return false;
	}
	canvas.width = imgObj.width;
	canvas.height = imgObj.height; 
	
	function getgradient(startcolor, endcolor, percent) {
		if (!endcolor.a) endcolor.a = 1;
		if (!startcolor.a) startcolor.a = 1;
		var red = startcolor.r + (percent * (endcolor.r - startcolor.r));
		var green = startcolor.g + (percent * (endcolor.g - startcolor.g));
		var blue = startcolor.b + (percent * (endcolor.b - startcolor.b));
		var alpha = startcolor.a + (percent * (endcolor.a - startcolor.a));
		var result = {"r":red, "g":green, "b":blue, "a":alpha};
		return result;
	}
	
	ctx.drawImage(imgObj, 0, 0); 
	var imgPixels = ctx.getImageData(0, 0, canvas.width, canvas.height);

	var gradient = (typeof(color[0]) === "object"?true:false);
	
	for(var x = 0; x < imgPixels.width; x++){
		if (gradient){
			var gradients = color.length - 1;
			var grad = Math.ceil((x+1)/(imgPixels.width/gradients));
			var pos = (x+1-((grad-1)*(imgPixels.width/gradients)))/(imgPixels.width/gradients);
			var newcolor = getgradient(color[grad-1], color[grad], pos);
		} else {
			if (!color.a) color.a = 1;
			var newcolor = color;
		}
		for(var y = 0; y < imgPixels.height; y++){
			var xo = x * 4;
			var yo = y * imgPixels.width * 4;
			imgPixels.data[xo+yo] = Math.floor( ( newcolor.r * imgPixels.data[xo+yo] ) / 0xff );
			imgPixels.data[xo+yo+1] = Math.floor( ( newcolor.g * imgPixels.data[xo+yo+1] ) / 0xff );
			imgPixels.data[xo+yo+2] = Math.floor( ( newcolor.b * imgPixels.data[xo+yo+2] ) / 0xff );
			imgPixels.data[xo+yo+3] = Math.floor( ( newcolor.a * imgPixels.data[xo+yo+3] ) / 0x1 );
		}
	}
	ctx.putImageData(imgPixels, 0, 0, 0, 0, imgPixels.width, imgPixels.height);
	return canvas.toDataURL();
}

/********************************
GAMESHARK TO ROM
********************************/

function gameShark2ROM(string, type) {
	type = type || "menu";
	if ($editor.data.game == 0) { //Ocarina of Time
		if (type == "menu") {
			var RAM = 0x813D23B0;
		} else {
			return false;
		}
	} else if ($editor.data.game == 1) { //Majora's Mask
		if (type == "menu") {
			var RAM = 0x8174AF20;
		} else {
			return false;
		}
	} else {
		return false;
	}
	var parsed = string.match(/([a-fA-F0-9]{8}) ([a-fA-F0-9]{4})/g);
	var addresses = [];
	$.each(parsed, function(index,string){
		var data = string.split(" ");
		var address = parseInt(data[0],16) - RAM;
		var value = parseInt(data[1],16);
		addresses.push({'address':address,'value':value});
	});
	return addresses;
}