function update() {
	//Update Current Menu
	if ($editor.currentmenu != $editor.menu[$editor.settings.menu]) {
		if (!$editor.menu[$editor.settings.menu]) {
			$editor.menu[$editor.settings.menu] = {};
		}
		//$(".object,.cursor,.listobject").remove();
		$editor.drag = [];
		$(document.activeElement).blur();
		$editor.currentmenu = $editor.menu[$editor.settings.menu];
		var loadingTab = true;
	}
	$(".workspacetab:not(:nth("+$editor.settings.menu+"))[current]").removeAttr('current');
	$(".workspacetab:nth("+$editor.settings.menu+"):not([current])").attr('current','');
	
	//Setup unexisting values
	refreshEditorObject();
	
	//Update Displayed Objects
	if ($editor.settings.showObjects) {
		$(".screen").removeClass("hideObjects");
	} else {
		$(".screen").addClass("hideObjects");
	}
	if ($editor.settings.showCursors) {
		$(".screen").removeClass("hideCursors");
	} else {
		$(".screen").addClass("hideCursors");
	}
	
	//Update Toggled Panels
	if ($editor.settings.showBottom) {
		$(".editor.toggledbottom").removeClass("toggledbottom");
	} else {
		$(".editor:not(.toggledbottom)").addClass("toggledbottom");
	}
	
	/*
	//Update Tabs
	$.each($editor.settings.tabs, function(key,value){
		if ($("[tabgroup="+key+"]").is(":hidden")) {
			return;
		}
		var tab = $("[tabgroup="+key+"]").children(".paneltab").eq(value);
		while (tab.is(":hidden")) {
			var tab = tab.prev(".paneltab");
			value -= 1;
		}
		$editor.settings.tabs[key] = value;
		tab.attr("current","").siblings(".paneltab").removeAttr("current");
		$("#"+key).children(".tabpanel,.sidetabpanel").eq(value).show().siblings(".tabpanel,.sidetabpanel").hide();
	});
	*/
	
	//Update data-req elements (reduces FPS by ~25)
	$("[data-req]").each(function(ie, element) {
		dataReq(ie, element);
	});

	//Update Tab Overflow
	/*
	function a() {
		$.each($("[tabgroup]"), function(i,group) {
			var grp = $(group);
			var overflown = false;
			$.each(grp.children(".paneltab"), function(ii, tab){
				var ele = $(tab);
				if (ele.position().top > 0) {
					grp.find(".overflowlist > div:contains('"+ele.text()+"')").show();
					overflown = true;
				} else {
					grp.find(".overflowlist > div:contains('"+ele.text()+"')").hide();
				}
			});
			grp.children(".paneloverflow").toggle(overflown);
		});
	}
	a();
	*/
    
	//Update Input Elements
	$("input[change]:not(:focus):not(.active)").each(function(i, o){
		var parameters = $(o).attr("change");
		parameters = parameters.replace("setobj","currentmenu");
		parameters = parameters.replace("move,x","position,0");
		parameters = parameters.replace("move,y","position,1");
		if ($editor.settings.menu < 5) {
			parameters = parameters.replace("crntobject",$editor.currentmenu.selection.object[0]);
			parameters = parameters.replace("crntcursor",$editor.currentmenu.selection.cursor[0]);
		}
		parameters = parameters.split(",");
		var value = getObjFromPath($editor,parameters);
		if (typeof(value) === "undefined") value = false;
		if ($(o).hasClass("colorpick") && $(o).next().is(":visible")) {
			$(o).spectrum("set", value);
		} else if ($(o).attr("type") == "checkbox") {
			$(o).prop('checked', value);
		} else {
			$(o).val(value);
		}
	});
	$('[static]').attr('disabled','');
	
	
	//Update zoom
	function zoomWorkspace() {
		object = $(".screen");
		workspace = $(".workspace");
		
		workspaceWidth = workspace.width();
		workspaceHeight = workspace.height()-20;
		scale = $editor.currentmenu.settings.zoom/100;
		
		object.css({
			'transform': 'scale(' + scale + ')',
			'-ms-transform': 'scale(' + scale + ')',
			'-moz-transform': 'scale(' + scale + ')',
			'-webkit-transform': 'scale(' + scale + ')',
			"transform-origin":'top left'
		});
		objectWidth = object.width()*scale;
		objectHeight = object.height()*scale;
		
		marginWidth = Math.max((workspaceWidth - (objectWidth))/2,0);
		marginHeight = Math.max((workspaceHeight - (objectHeight))/2,0);
		object.css({
			"margin-top":marginHeight+"px",
			"margin-left":marginWidth+"px"
		});
	}
	zoomWorkspace();
	if ($editor.settings.menu>4) {
		$editor.settings.hideObjList = true;
		return false;
	} else {
		$editor.settings.hideObjList = false;
	}
	
	/**********************************************************************************************************************************************
	THE FOLLOWING CODE WILL ONLY RUN WHEN YOU'RE VIEWING A PAUSE MENU PANEL
	**********************************************************************************************************************************************/
	
	//Update Selected Objects
	function updateSelectedInput(type) {
		var selected = $("");
		$.each($editor.currentmenu.selection[type], function(i,v){
			selected = selected.add($editor.currentmenu[type][v].objectElement);
			selected = selected.add($editor.currentmenu[type][v].listElement);
		});
		selected.addClass('selected');
		$("."+type+",.listobject[listtype="+type+"]").not(selected).removeClass('selected');
	
		if ($editor.currentmenu.selection[type][0]) {
			//Update selected object class
			var id = $editor.currentmenu.selection[type][0];
			var object = $editor.currentmenu[type][id];
			$('#'+type+'Settings :input:not([static])').removeAttr('disabled');
			$('#'+type+'Name').html($editor.menunames[$editor.data.game][$editor.settings.menu][id]);
			$('#'+type+'ID').val(id);
		} else {
			$('#'+type+'Settings :input').attr('disabled', 'disabled');
			$('#'+type+'Name').html("No "+type+" is selected");
		}
	}
	updateSelectedInput("object");
	updateSelectedInput("cursor");
	
	function createAllObjects() {
		var menuContainer = $(".menucontainer");
		var listContainer = $("#objectlist");
		$.each($editor.menu, function(menuIndex,menu){
			var objectContainer = $("<div id='mContainer"+menuIndex+"' data-req='settings,menu/"+menuIndex+"' />").appendTo(menuContainer);
			var itemContainer = $("<div id='lContainer"+menuIndex+"' data-req='settings,menu/"+menuIndex+"' />").appendTo(listContainer);
			if (!menu.object) {return true;}
			$.each(menu.object, function (objectIndex,object) {
				object.objectElement = $('<div/>', {
					"class": "object",
					"object": objectIndex
				}).appendTo(objectContainer);
				//Setup object list
				object.listElement = $('<div/>', {
					"class": "listobject",
					"id": "objList"+"object"+objectIndex,
					"listType": "object",
					"listID": objectIndex
				})
				.append('<div class="listobjToggle"><input type="checkbox" id="objList'+"object"+objectIndex+'toggle"/><label for="objList'+"object"+objectIndex+'toggle" title="Toggle display object" change="settings,show'+"object"+',crntmenu,'+objectIndex+'"><span></span></label></div>')
				.append('<div class="listobjInfo">'+$editor.menunames[$editor.data.game][menuIndex][objectIndex]+'</div>')
				.appendTo(itemContainer);
				object.texture.refresh = true;
				$editor.settings['show'+"object"][menuIndex][objectIndex] = true;
			});
		});
	}
	
	var loaded = true;
	$.each($requiredfiles, function(key, val){
		if (!$editor.files.loaded[val]) {
			loaded = false;
		} else {
			$("#load_"+val).addClass("fileLoaded");
		}
	});
	if ($editor.data.loaded != true && loaded == true) {
		$editor.menu = [{},{},{},{},{}];
		getMenuFileInfo();
		loadTableData();
		createAllObjects();
		$(".providefile").fadeOut(1000);
		$(".pausescreen,.screen,.workspacetab:not([data-req])").show();
		$("[save=zdata],[tab=global],[reset=panel],[reset=object]").removeAttr("disabled");
		$(".workspacetab.menutab").each(function(i,e) {
			$(this).html($editor.panelnames[$editor.data.game][i]);
		});
	}
	$editor.data.loaded = loaded;

	if (!$editor.data.loaded) return false
	/**********************************************************************************************************************************************
	THE FOLLOWING CODE WILL ONLY RUN WHEN YOU'VE LOADED THE .ZDATA FILE
	**********************************************************************************************************************************************/
	$(".pausescreen").show();
	//Update workspace objects
	function updateAllObjects(type) {
		$.each($editor.currentmenu[type], function (index,object) {
			var texture = $textures[object.texture.file][object.texture.offset].texture;	
			var element = object.objectElement;
			var listElement = object.listElement;
			if ($editor.data.game == 1) { //Majora's Mask
				if ($editor.settings.menu == 3) {
					if (index < 6) {
						element.css("background-size","100% 100%");
					} else {
						element.css("background-size","90% 90%");
					}
				} 
			} else if ($editor.data.game == 0) { //Ocarina of Time
				if ($editor.settings.menu == 3) {
					if (index < 6) {
						element.css("background-size","100% 100%");
					} else if (index < 18) {
						element.css("background-size","60% 90%");
						element.css("background-position","top left");
					} else if (index > 40) {
						element.css("background-size","90% 90%");
						element.css("background-position","left");
					} else {
						element.css("background-size","90% 90%");
					}
				}
			}
			if (object.texture.refresh) {
				delete object.texture.refresh;
				object.objectElement.removeAttr("tint");
				element.css({
					"background-image":"url('"+texture+"')"
				});
				listElement.children(".listobjInfo").css("background-image","url("+texture+")");
			}
			
			$("#objList"+type+index+"toggle").prop("checked", $editor.settings['show'+type][$editor.settings.menu][index]);
			if ($editor.settings['show'+type][$editor.settings.menu][index]) {
				element.removeClass("hideObject");
			} else {
				element.addClass("hideObject");
			}
			
			if (typeof(object.note) !== "undefined") {
				object.position[1] = $editor.currentmenu.data.notey[object.note];
				if ($editor.currentmenu.data.noteColor) var newcolor = (object.note==0?$editor.currentmenu.data.noteColor[0]:$editor.currentmenu.data.noteColor[1]);
			} else if (typeof(object.replaynote) !== "undefined") {
				object.position[1] = $editor.currentmenu.data.replaynotey[object.replaynote];
				if ($editor.currentmenu.data.noteColor) var newcolor = $editor.currentmenu.data.noteColor[2];
			}
			
			if (typeof(object.size) == "object") {
				var size = object.size;
			} else {
				var size = [object.size, object.size];
				if (index > 40) { //SKULLTULA COUNTER FIX
					size[0] = size[0]*0.75;
					size[1] = size[1]*1.25;
				}
			}
			
			element.css({
				"left": object.position[0]+"px",
				"top": object.position[1]+"px",
				"width": size[0]+"px",
				"height": size[1]+"px"
			});
			
			if (object.color) var newcolor = object.color;
			else if (object.fadeColor) var newcolor = object.fadeColor[0];
			
			if (newcolor) {
				if (!newcolor.a) newcolor.a = 1;
				var newcolorString = (pad(newcolor.r.toString(16),2)+pad(newcolor.g.toString(16),2)+pad(newcolor.b.toString(16),2)+pad(Math.round(newcolor.a*0xFF).toString(16),2)).toUpperCase();
				if (!$editor.cache.textures[texture]) {			
					$editor.cache.textures[texture] = {};
				}
				if (!$editor.cache.textures[texture][newcolorString]) {
					$editor.cache.textures[texture][newcolorString] = multiplyColor(texture, newcolor);
				}
				if (element.attr("tint") != newcolorString) {
					if ($editor.cache.textures[texture][newcolorString]) {
						element.attr("tint", newcolorString);
						element.css("background-image","url("+$editor.cache.textures[texture][newcolorString]+")");
						listElement.children(".listobjInfo").css("background-image","url("+$editor.cache.textures[texture][newcolorString]+")");
					}
				}
			}
		});
		return "All "+"object"+"s has been updated.";
	}		
	updateAllObjects("object");

	//Update Background Grid
	function updateTextureGrid() {
		var color = $editor.currentmenu.data.backgroundcolor;
		if (color) {
			if ($editor.data.game == 0) {
				var newcolor = ["","","",""];
				var newcolorString = "";
				$.each(color, function(i,v) {
					newcolor[i] = color[i];
					if (!newcolor[i].a) newcolor[i].a = 1;
					newcolorString += (pad(newcolor[i].r.toString(16),2)+pad(newcolor[i].g.toString(16),2)+pad(newcolor[i].b.toString(16),2)+pad(Math.round(newcolor[i].a*0xFF).toString(16),2)).toUpperCase();
				});
			} else {
				var newcolor = color;
				if (!newcolor.a) newcolor.a = 1;
				var newcolorString = (pad(newcolor.r.toString(16),2)+pad(newcolor.g.toString(16),2)+pad(newcolor.b.toString(16),2)+pad(Math.round(newcolor.a*0xFF).toString(16),2)).toUpperCase();
			}
		}
		$.each($editor.currentmenu.background, function (x) {
			$.each($(this), function (y,object) {
				var element = $(".bgTile[xy='"+x.toString()+y.toString()+"']");
				var texture = $textures[object.file][object.offset].texture;
				if (object.refresh || loadingTab == true) {
					delete object.refresh;
					element.removeAttr("tint");
					element.css({
						"background-image":"url('"+texture+"')"
					});
				}
				if (newcolor) {
					if (element.attr("tint") != newcolorString) {
						if (!$editor.cache.textures[texture]) {			
							$editor.cache.textures[texture] = {};
						}
						if (!$editor.cache.textures[texture][newcolorString]) {
							$editor.cache.textures[texture][newcolorString] = [];
						}
						if ($editor.data.game == 0) { //Ocarina of Time
							var color = [newcolor[0+x],newcolor[1+x]];
							if (!$editor.cache.textures[texture][newcolorString][x]) {
								$editor.cache.textures[texture][newcolorString][x] = multiplyColor(texture, color);
								//console.log($editor.cache.textures[texture][newcolorString][x]);
							}
						}
						if ($editor.cache.textures[texture][newcolorString][x]) {
							element.css("background-image","url("+$editor.cache.textures[texture][newcolorString][x]+")");
							element.attr("tint",newcolorString);
						}
					}
				}
			});
		});
	}
	updateTextureGrid();
}